package com.xebialabs.deployit.core.rest.json

import java.io.{IOException, OutputStream, OutputStreamWriter}
import java.lang.annotation.Annotation
import java.lang.reflect.Type
import java.util

import ai.digital.deploy.sql.model.{ResolvedPlaceholderReference, ResolvedPlaceholderView}
import com.xebialabs.xltype.serialization.json.JsonWriter
import jakarta.ws.rs.core.{MediaType, MultivaluedMap}
import jakarta.ws.rs.ext.{MessageBodyWriter, Provider}
import jakarta.ws.rs.{Produces, WebApplicationException}
import org.springframework.stereotype.Component

@Component
@Provider
@Produces(Array(MediaType.APPLICATION_JSON))
class ResolvedPlaceholderViewJsonWriter extends MessageBodyWriter[util.Collection[ResolvedPlaceholderView]] {

  private val helper = new JsonWriterHelper

  override def isWriteable(`type`: Class[_], genericType: Type, annotations: Array[Annotation],
                           mediaType: MediaType): Boolean = classOf[ResolvedPlaceholderView].isAssignableFrom(helper.getType(`type`, genericType))

  override def getSize(viewList: util.Collection[ResolvedPlaceholderView], `type`: Class[_], genericType: Type, annotations: Array[Annotation],
                       mediaType: MediaType): Long = -1

  @throws[IOException]
  @throws[WebApplicationException]
  override def writeTo(viewList: util.Collection[ResolvedPlaceholderView], `type`: Class[_], genericType: Type, annotations: Array[Annotation],
                       mediaType: MediaType, httpHeaders: MultivaluedMap[String, AnyRef],
                       entityStream: OutputStream): Unit = {
    val reportStreamWriter: OutputStreamWriter = new OutputStreamWriter(entityStream)
    writeJson(viewList, new JsonWriter(reportStreamWriter))
    reportStreamWriter.flush()
  }

  private def writeReference(key: String, reference: ResolvedPlaceholderReference, writer: JsonWriter): Unit = {
    writer.key(key)
    writer.`object`()
    writer.key("canRead").value(reference.getCanRead)
    writer.key("exists").value(reference.getExists)
    writer.key("id").value(reference.getId)
    writer.endObject()
  }

  private def writeJson(viewList: util.Collection[ResolvedPlaceholderView], writer: JsonWriter): Unit = {
    writer.array
    viewList.forEach(view => {
      writer.`object`()
      writer.key("key").value(view.getKey)
      writer.key("value").value(view.getValue)
      writer.key("encrypted").value(view.getEncrypted)
      writer.key("versionId").value(view.getVersionId)

      writeReference("container", view.getContainer, writer)
      writeReference("dictionary", view.getDictionary, writer)
      writeReference("deployedApp", view.getDeployedApp, writer)
      writeReference("environment", view.getEnvironment, writer)

      writer.endObject()
    })
    writer.endArray
  }
}
