/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.rest.api.support.PaginationSupport;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.DeployUserService;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.security.UserProfile;
import com.xebialabs.deployit.engine.spi.event.UserCreatedEvent;
import com.xebialabs.deployit.engine.spi.event.UserDeletedEvent;
import com.xebialabs.deployit.engine.spi.event.UserPasswordChangedEvent;
import com.xebialabs.deployit.engine.spi.event.UserUpdateEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.RepoUser;
import com.xebialabs.deployit.security.User;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.authentication.UserAlreadyExistsException;
import com.xebialabs.deployit.security.model.XldUserProfile;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.security.service.UserProfileService;
import com.xebialabs.deployit.security.validator.UserValidator;
import com.xebialabs.xlplatform.security.dto.PasswordValidationResult;
import jakarta.ws.rs.core.Context;
import java.util.List;
import java.util.Objects;
import org.jboss.resteasy.spi.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.session.SessionInformation;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;
import org.springframework.session.SessionRepository;
import org.springframework.stereotype.Controller;
import scala.collection.immutable.HashSet;
import scala.collection.immutable.Set;

@Controller
public class UserResource
extends AbstractSecuredResource
implements DeployUserService {
    @Context
    private HttpResponse response;
    @Autowired
    UserService userService;
    @Autowired
    UserProfileService userProfileService;
    @Autowired
    UserValidator userValidator;
    @Autowired
    SessionRegistry sessionRegistry;
    @Autowired
    SessionRepository sessionRepository;
    @Autowired
    PersistentTokenRepository persistentTokenRepository;
    private static final Logger logger = LoggerFactory.getLogger(UserResource.class);

    public com.xebialabs.deployit.engine.api.security.User create(String username, com.xebialabs.deployit.engine.api.security.User user) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        UserResource.sanityCheckUser(username, user);
        this.userValidator.check(user);
        this.checkNoUserProfileAlreadyExists(username);
        logger.debug("Creating user and UserProfile {}", (Object)username);
        this.userService.create(username, user.getPassword());
        XldUserProfile userProfile = UserResource.getXldUserProfile(user);
        this.userProfileService.createOrUpdateUserProfile(userProfile);
        User u = this.userService.read(username);
        logger.debug("Created user {}", (Object)u.getUsername());
        XldUserProfile profile = this.userProfileService.findOne(userProfile.username());
        logger.debug("Created userProfile {}", (Object)profile.username());
        UserProfile userProfile1 = this.getUserProfile(profile);
        EventBusHolder.publish((Object)new UserCreatedEvent(username));
        return new com.xebialabs.deployit.engine.api.security.User(u.getUsername(), u.isAdmin(), userProfile1);
    }

    public com.xebialabs.deployit.engine.api.security.User read(String username) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        logger.debug("Read userProfile {}", (Object)username);
        XldUserProfile profile = this.userProfileService.findOne(username);
        if (profile == null) {
            throw new NotFoundException("User {} does not exist", new Object[]{username});
        }
        UserProfile userProfile = this.getUserProfile(profile);
        logger.debug("Read user {}", (Object)username);
        Object u = profile.isInternal() ? this.userService.read(username) : new RepoUser(profile.username(), Objects.equals(profile.username(), "admin"));
        return new com.xebialabs.deployit.engine.api.security.User(u.getUsername(), u.isAdmin(), userProfile);
    }

    public List<String> listUserNames(String username, Paging paging, Ordering order) {
        this.checkPermissions(new Permission[]{PlatformPermissions.EDIT_SECURITY, PlatformPermissions.VIEW_SECURITY});
        List usernames = this.userService.listUsernames(username, paging, order);
        PaginationSupport.addTotalCountHeader((long)this.userService.countUsers(username), (HttpResponse)this.response);
        return usernames;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void modifyPassword(String username, com.xebialabs.deployit.engine.api.security.User user) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        UserResource.sanityCheckUser(username, user);
        this.userValidator.checkPassword(user);
        Authentication authentication = Permissions.getAuthentication();
        if (username.equals(authentication.getName())) {
            if (user.getCurrentPassword() == null || user.getCurrentPassword().trim().isEmpty()) throw new IllegalArgumentException("Current password is mandatory ");
            this.userService.modifyPassword(username, user.getPassword(), user.getCurrentPassword());
        } else {
            this.userService.modifyPassword(username, user.getPassword());
            this.expireUserSession(username);
        }
        EventBusHolder.publish((Object)new UserPasswordChangedEvent(username));
    }

    public List<PasswordValidationResult> validatePassword(com.xebialabs.deployit.engine.api.security.User user) {
        String password = user.getPassword() == null ? "" : user.getPassword();
        return this.userValidator.validatePassword(password);
    }

    public void delete(String username) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        this.userService.delete(username);
        this.expireUserSession(username);
        EventBusHolder.publish((Object)new UserDeletedEvent(username));
    }

    public void updateUser(String username, com.xebialabs.deployit.engine.api.security.User user) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        UserResource.sanityCheckUser(username, user);
        XldUserProfile profile = this.userProfileService.findOne(username);
        if (profile == null) {
            throw new NotFoundException("User {} does not exist", new Object[]{username});
        }
        XldUserProfile updatedProfile = new XldUserProfile(profile.username(), profile.analyticsEnabled(), (Set)new HashSet(), user.getUserProfile() != null && user.getUserProfile().getFullName() != null ? user.getUserProfile().getFullName() : null, user.getUserProfile() != null && user.getUserProfile().getEmail() != null ? user.getUserProfile().getEmail() : null, user.getUserProfile().getLoginAllowed().booleanValue(), profile.lastActive(), profile.isInternal());
        this.userProfileService.createOrUpdateUserProfile(updatedProfile);
        if (user.getPassword() != null && !user.getPassword().isEmpty() && user.getUserProfile().getIsInternal().booleanValue()) {
            this.modifyPassword(username, user);
        }
        EventBusHolder.publish((Object)new UserUpdateEvent(username));
    }

    public List<com.xebialabs.deployit.engine.api.security.User> listAllUserProfiles(String username, String fullName, String email, Paging paging, Ordering order) {
        this.checkPermissions(new Permission[]{PlatformPermissions.EDIT_SECURITY, PlatformPermissions.VIEW_SECURITY});
        List xldUserProfiles = this.userProfileService.listAllUserProfiles(username, fullName, email, paging, order);
        List<com.xebialabs.deployit.engine.api.security.User> usersList = xldUserProfiles.stream().map(xldUserProfile -> {
            UserProfile userProfile = new UserProfile();
            userProfile.setEmail(xldUserProfile.email());
            userProfile.setFullName(xldUserProfile.fullName());
            userProfile.setIsInternal(Boolean.valueOf(xldUserProfile.isInternal()));
            userProfile.setLoginAllowed(Boolean.valueOf(xldUserProfile.loginAllowed()));
            userProfile.setLastActive(xldUserProfile.lastActive());
            return new com.xebialabs.deployit.engine.api.security.User(xldUserProfile.username(), false, userProfile);
        }).toList();
        PaginationSupport.addTotalCountHeader((long)this.userProfileService.countUsers(username, fullName, email), (HttpResponse)this.response);
        return usersList;
    }

    private void expireUserSession(String username) {
        for (SessionInformation information : this.sessionRegistry.getAllSessions((Object)username, false)) {
            this.sessionRepository.deleteById(information.getSessionId());
        }
        this.persistentTokenRepository.removeUserTokens(username);
    }

    private static void sanityCheckUser(String username, com.xebialabs.deployit.engine.api.security.User user) {
        if (user.getUsername() == null || user.getUsername().trim().isEmpty()) {
            throw new IllegalArgumentException("User name cannot be empty");
        }
        if (!user.getUsername().equals(username)) {
            throw new IllegalArgumentException("Username in URL is " + username + " but username in POST data is " + user.getUsername());
        }
    }

    void setUserService(UserService userService) {
        this.userService = userService;
    }

    void setUserValidator(UserValidator userValidator) {
        this.userValidator = userValidator;
    }

    void setUserProfileService(UserProfileService userProfileService) {
        this.userProfileService = userProfileService;
    }

    void setSessionRegistry(SessionRegistry sessionRegistry) {
        this.sessionRegistry = sessionRegistry;
    }

    void setPersistentTokenRepository(PersistentTokenRepository persistentTokenRepository) {
        this.persistentTokenRepository = persistentTokenRepository;
    }

    private UserProfile getUserProfile(XldUserProfile profile) {
        if (profile != null) {
            UserProfile userProfile = new UserProfile();
            userProfile.setEmail(profile.email() != null ? profile.email() : null);
            userProfile.setFullName(profile.fullName() != null ? profile.fullName() : null);
            userProfile.setIsInternal(Boolean.valueOf(profile.isInternal()));
            userProfile.setLoginAllowed(Boolean.valueOf(profile.loginAllowed()));
            userProfile.setLastActive(profile.lastActive());
            return userProfile;
        }
        return null;
    }

    private static XldUserProfile getXldUserProfile(com.xebialabs.deployit.engine.api.security.User user) {
        XldUserProfile userProfile = new XldUserProfile(user.getUsername(), true, (Set)new HashSet(), user.getUserProfile() != null && user.getUserProfile().getFullName() != null ? user.getUserProfile().getFullName() : null, user.getUserProfile() != null && user.getUserProfile().getEmail() != null ? user.getUserProfile().getEmail() : null, true, null, true);
        return userProfile;
    }

    private void checkNoUserProfileAlreadyExists(String username) {
        try {
            boolean userProfileExists;
            boolean bl = userProfileExists = this.userProfileService.findOne(username) != null;
            if (userProfileExists) {
                throw new UserAlreadyExistsException(username);
            }
        }
        catch (NotFoundException nof) {
            logger.debug("User {} does not exist", (Object)username);
        }
    }
}

