package com.xebialabs.deployit.core.rest.json;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.xebialabs.deployit.engine.api.security.Permission;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import org.springframework.stereotype.Component;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.annotation.Annotation;

@Component
@Provider
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
public class PermissionJsonWriter implements MessageBodyWriter<Permission> {

    @Override
    public boolean isWriteable(Class<?> type, final java.lang.reflect.Type genericType, final Annotation[] annotations, final MediaType mediaType) {
        return Permission.class.isAssignableFrom(type);
    }

    @Override
    public long getSize(final Permission permission, final Class<?> type, final java.lang.reflect.Type genericType, final Annotation[] annotations, final MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(final Permission permission, final Class<?> type, final java.lang.reflect.Type genericType, final Annotation[] annotations, final MediaType mediaType, final MultivaluedMap<String, Object> httpHeaders, final OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(toJson(permission).getBytes());
    }

    @VisibleForTesting
    String toJson(Permission permission) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter(stringWriter);
        writeJson(permission, writer);
        return stringWriter.toString();
    }

    static void writeJson(final Permission permission, final JsonWriter writer) {
        writer.object();
        writer.key("level").value(permission.getLevel());
        writer.key("permissionName").value(permission.getPermissionName());
        if (!Strings.isNullOrEmpty(permission.getRoot())) {
            writer.key("root").value(permission.getRoot());
        }
        writer.endObject();
    }
}
