package com.xebialabs.deployit.core.rest.json;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.engine.api.dto.DeploymentInfo;
import com.xebialabs.xltype.serialization.json.DeploymentInfoJsonConverter;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import org.springframework.stereotype.Component;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;

@Component
@Provider
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
public class DeploymentsInfoJsonReaderWriter implements MessageBodyWriter<Collection<DeploymentInfo>> {

    private final DeploymentInfoJsonConverter converter = new DeploymentInfoJsonConverter();

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType) {
            type = (Class<?>) ((ParameterizedType) genericType).getActualTypeArguments()[0];
        }
        return DeploymentInfo.class.isAssignableFrom(type);
    }

    @Override
    public long getSize(Collection<DeploymentInfo> deploymentInfos, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1;
    }

    @Override
    public void writeTo(Collection<DeploymentInfo> deploymentInfos, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(toJson(deploymentInfos).getBytes());
    }

    @VisibleForTesting
    String toJson(Collection<DeploymentInfo> deploymentInfos) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter(stringWriter);

        if (deploymentInfos != null && !deploymentInfos.isEmpty()) {
            writer.array();
            for (DeploymentInfo info: deploymentInfos) {
                converter.toJson(info, writer);
            }
            writer.endArray();
        }

        return writer.toString();
    }
}
