package com.xebialabs.deployit.core.service.impl

import com.xebialabs.deployit.core.service.PendoMetadataService
import com.xebialabs.deployit.repository.XlMetadataRepository
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

@Service
class PendoMetadataServiceImpl(@Autowired xlMetadataRepository: XlMetadataRepository)
  extends PendoMetadataService {

  private val pendoAccountId = "analytics_id"

  override def getPendoAccountId(): String = {
    xlMetadataRepository.get(pendoAccountId)
  }

  override def savePendoAccountId(accountId: String): Unit = {
    xlMetadataRepository.save(pendoAccountId, accountId)
  }
}
