package com.xebialabs.deployit.core.rest.json;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import com.xebialabs.xltype.serialization.json.TaskWithBlockJsonConverter;
import org.springframework.stereotype.Component;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;

@Component
@Provider
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
public class TaskWithBlocksJsonWriter implements MessageBodyWriter<List<TaskWithBlock>> {

    static final TaskWithBlockJsonConverter taskWithBlockJsonConverter = new TaskWithBlockJsonConverter();

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType) {
            type = (Class<?>) ((ParameterizedType) genericType).getActualTypeArguments()[0];
        }

        return TaskWithBlock.class.isAssignableFrom(type);
    }

    @Override
    public long getSize(List<TaskWithBlock> taskWithBlocks, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1;
    }

    @Override
    public void writeTo(List<TaskWithBlock> taskWithBlocks, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(toJson(taskWithBlocks).getBytes());
    }

    @VisibleForTesting
    String toJson(List<TaskWithBlock> taskWithBlocks) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter(stringWriter);

        if (taskWithBlocks != null && !taskWithBlocks.isEmpty()) {
            writer.array();
            for (TaskWithBlock taskWithBlock: taskWithBlocks) {
                taskWithBlockJsonConverter.writeJsonObject(taskWithBlock, writer);
            }
            writer.endArray();
        }

        return writer.toString();
    }
}
