package com.xebialabs.deployit.core.rest.api.reports.widgets;

import ai.digital.deploy.sql.model.Report;
import ai.digital.deploy.sql.model.ReportLine;
import com.xebialabs.deployit.task.archive.DeploymentResult;
import com.xebialabs.deployit.task.archive.StatusOverviewReportLine;
import com.xebialabs.deployit.task.archive.TaskArchive;
import org.joda.time.DateTime;

import java.util.Collection;

/**
 * Status overview widget
 */
public class DeploymentsPercentageWidgetData extends DashboardWidgetBase {

    public DeploymentsPercentageWidgetData(final TaskArchive taskArchive) {
        super(taskArchive);
    }

    @Override
    public Report getReport(final DateTime beginDate, final DateTime endDate) {
        Collection<StatusOverviewReportLine> searchResult = taskArchive.statusOverview(beginDate, endDate);
        return transformResult(searchResult);
    }

    private Report transformResult(Collection<StatusOverviewReportLine> searchResult) {
        Report report = new Report();
        if (searchResult.isEmpty()) {
            return report;
        }
        ReportLine line = report.addLine();
        int total = searchResult.stream()
                .filter(sr -> sr.executionState().equals(DeploymentResult.TOTAL.name()))
                .map(StatusOverviewReportLine::amount).findFirst().orElse(0);

        line.addValue(PERCENTAGE_SUCCESSFUL_DEPLOYMENTS, searchResult.stream()
                .filter(sr -> sr.executionState().equals(DeploymentResult.SUCCESS.name()))
                .map(sr -> {
                    line.addValue(NUMBER_SUCCESSFUL_DEPLOYMENTS, Integer.toString(sr.amount()));
                    return getFormattedPercentage(sr.amount(), total);
                }).findFirst().orElse(ZERO));

        line.addValue(PERCENTAGE_ABORTED_DEPLOYMENTS, searchResult.stream()
                .filter(sr -> sr.executionState().equals(DeploymentResult.ABORTED.name()))
                .map(sr -> {
                    line.addValue(NUMBER_ABORTED_DEPLOYMENTS, Integer.toString(sr.amount()));
                    return getFormattedPercentage(sr.amount(), total);
                }).findFirst().orElse(ZERO));

        line.addValue(PERCENTAGE_FAILED_DEPLOYMENTS, searchResult.stream()
                .filter(sr -> sr.executionState().equals(DeploymentResult.FAILED.name()))
                .map(sr -> {
                    line.addValue(NUMBER_FAILED_DEPLOYMENTS, Integer.toString(sr.amount()));
                    return getFormattedPercentage(sr.amount(), total);
                }).findFirst().orElse(ZERO));

        line.addValue(PERCENTAGE_ROLLBACK_DEPLOYMENTS, searchResult.stream()
                .filter(sr -> sr.executionState().equals(DeploymentResult.ROLLBACK.name()))
                .map(sr -> {
                    line.addValue(NUMBER_ROLLBACK_DEPLOYMENTS, Integer.toString(sr.amount()));
                    return getFormattedPercentage(sr.amount(), total);
                }).findFirst().orElse(ZERO));

        return report;
    }

}
