/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.websockets;

import com.xebialabs.deployit.core.events.CiRef;
import com.xebialabs.deployit.core.events.JmsCiChangeSetEvent;
import com.xebialabs.deployit.core.websockets.WebSocketEndpoints;
import com.xebialabs.deployit.engine.spi.event.MaintenanceStartEvent;
import com.xebialabs.deployit.engine.spi.event.MaintenanceStopEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import java.util.Collection;
import nl.javadude.t2bus.Subscribe;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Controller;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Autowired
@Controller
@ScalaSignature(bytes="\u0006\u0005\u0005mc\u0001B\u0005\u000b\u0001]A\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\u0006m\u0001!\ta\u000e\u0005\u0006y\u0001!\t!\u0010\u0005\u0006)\u0002!\t!\u0016\u0005\u0006C\u0002!\tA\u0019\u0005\u0006Q\u0002!I!\u001b\u0005\u0006_\u0002!I\u0001\u001d\u0005\b\u0003K\u0001A\u0011BA\u0014\u0005]9VMY*pG.,G/T3tg\u0006<Wm]*f]\u0012,'O\u0003\u0002\f\u0019\u0005Qq/\u001a2t_\u000e\\W\r^:\u000b\u00055q\u0011\u0001\u0002:fgRT!a\u0004\t\u0002\t\r|'/\u001a\u0006\u0003#I\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003'Q\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003U\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\r\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\r\u0005s\u0017PU3g\u0003=iWm]:bO\u0016$V-\u001c9mCR,\u0007C\u0001\u0011*\u001b\u0005\t#B\u0001\u0012$\u0003\u0011\u0019\u0018.\u001c9\u000b\u0005\u0011*\u0013!C7fgN\fw-\u001b8h\u0015\t1s%A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005A\u0013aA8sO&\u0011!&\t\u0002\u0016'&l\u0007/T3tg\u0006<\u0017N\\4UK6\u0004H.\u0019;fQ\t\tA\u0006\u0005\u0002.i5\taF\u0003\u00020a\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005E\u0012\u0014a\u00024bGR|'/\u001f\u0006\u0003g\u0015\nQAY3b]NL!!\u000e\u0018\u0003\u0013\u0005+Ho\\<je\u0016$\u0017A\u0002\u001fj]&$h\b\u0006\u00029uA\u0011\u0011\bA\u0007\u0002\u0015!)aD\u0001a\u0001?!\u0012!\bL\u0001\u001ag\u0016tGmV:DS\u000eC\u0017M\\4f'\u0016$X*Z:tC\u001e,7\u000f\u0006\u0002?\u0003B\u0011\u0011dP\u0005\u0003\u0001j\u0011A!\u00168ji\")!i\u0001a\u0001\u0007\u0006)QM^3oiB\u0011AiR\u0007\u0002\u000b*\u0011aID\u0001\u0007KZ,g\u000e^:\n\u0005!+%a\u0005&ng\u000eK7\t[1oO\u0016\u001cV\r^#wK:$\bFA\u0002K!\tY%+D\u0001M\u0015\tie*A\u0003ue\t,8O\u0003\u0002P!\u0006A!.\u0019<bIV$WMC\u0001R\u0003\tqG.\u0003\u0002T\u0019\nI1+\u001e2tGJL'-Z\u0001\u0017g\u0016tG-T1j]R,g.\u00198dKN#\u0018M\u001d;fIR\u0011aH\u0016\u0005\u0006\u0005\u0012\u0001\ra\u0016\t\u00031zk\u0011!\u0017\u0006\u0003\u0005jS!a\u0017/\u0002\u0007M\u0004\u0018N\u0003\u0002^!\u00051QM\\4j]\u0016L!aX-\u0003+5\u000b\u0017N\u001c;f]\u0006t7-Z*uCJ$XI^3oi\"\u0012AAS\u0001\u0017g\u0016tG-T1j]R,g.\u00198dKN#x\u000e\u001d9fIR\u0011ah\u0019\u0005\u0006\u0005\u0016\u0001\r\u0001\u001a\t\u00031\u0016L!AZ-\u0003)5\u000b\u0017N\u001c;f]\u0006t7-Z*u_B,e/\u001a8uQ\t)!*\u0001\u0011o_RLg-_!c_V$X*Y5oi\u0016t\u0017M\\2f\u001b>$Wm\u00115b]\u001e,GC\u0001 k\u0011\u0015Yg\u00011\u0001m\u0003\u001d)g.\u00192mK\u0012\u0004\"!G7\n\u00059T\"a\u0002\"p_2,\u0017M\\\u0001\u0014]>$\u0018NZ=DSNLeMT8u\u000b6\u0004H/\u001f\u000b\u0006}ED\u00181\u0002\u0005\u0006e\u001e\u0001\ra]\u0001\tK:$\u0007o\\5oiB\u0011AO^\u0007\u0002k*\u00111BD\u0005\u0003oV\u0014!cV3c'>\u001c7.\u001a;F]\u0012\u0004x.\u001b8ug\")\u0011p\u0002a\u0001u\u0006)1-[%egB)10!\u0001\u0002\u00065\tAP\u0003\u0002~}\u0006!Q\u000f^5m\u0015\u0005y\u0018\u0001\u00026bm\u0006L1!a\u0001}\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\t\u0004\t\u0006\u001d\u0011bAA\u0005\u000b\n)1)\u001b*fM\"9\u0011QB\u0004A\u0002\u0005=\u0011\u0001C;tKJt\u0017-\\3\u0011\t\u0005E\u0011q\u0004\b\u0005\u0003'\tY\u0002E\u0002\u0002\u0016ii!!a\u0006\u000b\u0007\u0005ea#\u0001\u0004=e>|GOP\u0005\u0004\u0003;Q\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002\"\u0005\r\"AB*ue&twMC\u0002\u0002\u001ei\t\u0011D\\8uS\u001aLx+\u001b;i\u0013R,Wn]%g\u001d>$X)\u001c9usV!\u0011\u0011FA\u001c)\u001dq\u00141FA\u0017\u0003\u0013BQA\u001d\u0005A\u0002MDq!a\f\t\u0001\u0004\t\t$A\u0003ji\u0016l7\u000fE\u0003|\u0003\u0003\t\u0019\u0004\u0005\u0003\u00026\u0005]B\u0002\u0001\u0003\b\u0003sA!\u0019AA\u001e\u0005\u0005!\u0016\u0003BA\u001f\u0003\u0007\u00022!GA \u0013\r\t\tE\u0007\u0002\b\u001d>$\b.\u001b8h!\rI\u0012QI\u0005\u0004\u0003\u000fR\"aA!os\"9\u0011Q\u0002\u0005A\u0002\u0005=\u0001f\u0001\u0001\u0002NA!\u0011qJA+\u001b\t\t\tFC\u0002\u0002T\u0015\n!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\t9&!\u0015\u0003\u0015\r{g\u000e\u001e:pY2,'\u000f\u000b\u0002\u0001Y\u0001")
public class WebSocketMessagesSender {
    @Autowired
    private final SimpMessagingTemplate messageTemplate;

    @Subscribe
    public void sendWsCiChangeSetMessages(JmsCiChangeSetEvent event) {
        String username = event.username();
        this.notifyCisIfNotEmpty(WebSocketEndpoints.TOPIC_CI_CREATE, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)event.createCis()).asJava(), username);
        this.notifyCisIfNotEmpty(WebSocketEndpoints.TOPIC_CI_UPDATE, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)event.updateCis()).asJava(), username);
        this.notifyWithItemsIfNotEmpty(WebSocketEndpoints.TOPIC_CI_DELETE, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)event.deleteCis()).asJava(), username);
        this.notifyWithItemsIfNotEmpty(WebSocketEndpoints.TOPIC_CI_RENAME, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)event.renameCis()).asJava(), username);
        this.notifyWithItemsIfNotEmpty(WebSocketEndpoints.TOPIC_CI_MOVE, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)event.moveCis()).asJava(), username);
        this.notifyWithItemsIfNotEmpty(WebSocketEndpoints.TOPIC_CI_COPY, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)event.copyCis()).asJava(), username);
    }

    @Subscribe
    public void sendMaintenanceStarted(MaintenanceStartEvent event) {
        this.notifyAboutMaintenanceModeChange(true);
    }

    @Subscribe
    public void sendMaintenanceStopped(MaintenanceStopEvent event) {
        this.notifyAboutMaintenanceModeChange(false);
    }

    private void notifyAboutMaintenanceModeChange(boolean enabled) {
        this.messageTemplate.convertAndSend((Object)WebSocketEndpoints.TOPIC_MAINTENANCE.getName(), (Object)BoxesRunTime.boxToBoolean((boolean)enabled));
    }

    private void notifyCisIfNotEmpty(WebSocketEndpoints endpoint, Collection<CiRef> ciIds, String username) {
        this.notifyWithItemsIfNotEmpty(endpoint, ciIds, username);
    }

    private <T> void notifyWithItemsIfNotEmpty(WebSocketEndpoints endpoint, Collection<T> items, String username) {
        if (!items.isEmpty()) {
            this.messageTemplate.convertAndSendToUser(username, endpoint.getName(), items);
            return;
        }
    }

    public WebSocketMessagesSender(@Autowired SimpMessagingTemplate messageTemplate) {
        this.messageTemplate = messageTemplate;
        EventBusHolder.register((Object)this);
    }
}

