/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports.mapper;

import ai.digital.deploy.sql.model.ReportLine;
import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ReportToCsvMapper {
    private final RowMapper rowMapper;

    public ReportToCsvMapper(Stream<ReportLine> reportLines) {
        this.rowMapper = new ImplicitRowMapper(reportLines);
    }

    public ReportToCsvMapper(Collection<ReportLine> reportLines) {
        this(reportLines.stream());
    }

    public ReportToCsvMapper(Stream<ReportLine> reportLines, Collection<String> fields) {
        this.rowMapper = fields == null ? new ImplicitRowMapper(reportLines) : new ExplicitRowMapper(reportLines, this.sortFields(fields));
    }

    private List<String> sortFields(Collection<String> fields) {
        return fields.stream().sorted().collect(Collectors.toList());
    }

    public Stream<String> getCsv() {
        return this.rowMapper.getRows();
    }

    private static class ExplicitRowMapper
    extends RowMapper {
        private final List<String> fields;

        ExplicitRowMapper(Stream<ReportLine> reportLines, List<String> fields) {
            super(reportLines);
            this.fields = fields;
        }

        @Override
        public Stream<String> getRows() {
            return Stream.concat(Stream.of(this.getHeader()), this.reportLines.map(this::getLine));
        }

        private String getHeader() {
            return this.line(this.fields);
        }

        private String getLine(ReportLine reportLine) {
            Map values = reportLine.getValues();
            List sortedValues = this.fields.stream().map(values::get).collect(Collectors.toList());
            return this.line(sortedValues);
        }
    }

    private static class ImplicitRowMapper
    extends RowMapper {
        private boolean first = true;

        ImplicitRowMapper(Stream<ReportLine> reportLines) {
            super(reportLines);
        }

        @Override
        public Stream<String> getRows() {
            return this.reportLines.map(this::getLine);
        }

        private String getLine(ReportLine reportLine) {
            TreeMap<String, Object> sorted = ImplicitRowMapper.sorted(reportLine);
            if (this.first) {
                this.first = false;
                return LINE_JOINER.join((Object)this.line(sorted.keySet()), (Object)this.line(sorted.values()), new Object[0]);
            }
            return this.line(sorted.values());
        }

        private static TreeMap<String, Object> sorted(ReportLine line) {
            return new TreeMap<String, Object>(line.getValues());
        }
    }

    private static abstract class RowMapper {
        protected static final Joiner LINE_JOINER = Joiner.on((String)"\n");
        protected static final Joiner FIELD_JOINER = Joiner.on((String)",");
        protected static final Function<Object, @Nullable String> QUOTE = input -> String.format("\"%s\"", input);
        protected final Stream<ReportLine> reportLines;

        public abstract Stream<String> getRows();

        RowMapper(Stream<ReportLine> reportLines) {
            this.reportLines = reportLines;
        }

        protected String line(Iterable<?> fields) {
            return FIELD_JOINER.join((Iterable)StreamSupport.stream(fields.spliterator(), false).map(QUOTE).collect(Collectors.toList()));
        }
    }
}

