/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import ai.digital.deploy.sql.http.enricher.PaginationService;
import com.xebialabs.deployit.core.api.HostService;
import com.xebialabs.deployit.core.rest.api.RepositoryResource;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.DeploymentInfo;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.DeployedApplicationsRepository;
import com.xebialabs.deployit.repository.EnvironmentRepository;
import java.util.List;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005Me\u0001\u0002\u0007\u000e\u0001iA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!A1\u0007\u0001B\u0001B\u0003%A\u0007\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003F\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u001dy\u0006A1A\u0005\u0002\u0001Daa\u001b\u0001!\u0002\u0013\t\u0007\"\u0002=\u0001\t\u0013I\bbBA\u0013\u0001\u0011\u0005\u0013q\u0005\u0005\b\u0003C\u0002A\u0011IA2\u0011\u001d\t\t\b\u0001C!\u0003g\u0012q\u0002S8tiN+'O^5dK&k\u0007\u000f\u001c\u0006\u0003\u001d=\t1!\u00199j\u0015\t\u0001\u0012#\u0001\u0003sKN$(B\u0001\n\u0014\u0003\u0011\u0019wN]3\u000b\u0005Q)\u0012\u0001\u00033fa2|\u00170\u001b;\u000b\u0005Y9\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005A\u0012aA2p[\u000e\u00011c\u0001\u0001\u001cGA\u0011A$I\u0007\u0002;)\u0011adH\u0001\u0005Y\u0006twMC\u0001!\u0003\u0011Q\u0017M^1\n\u0005\tj\"AB(cU\u0016\u001cG\u000f\u0005\u0002%M5\tQE\u0003\u0002\u000f#%\u0011q%\n\u0002\f\u0011>\u001cHoU3sm&\u001cW-A\u000bf]ZL'o\u001c8nK:$(+\u001a9pg&$xN]=\u0011\u0005)jS\"A\u0016\u000b\u00051\u001a\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011af\u000b\u0002\u0016\u000b:4\u0018N]8o[\u0016tGOU3q_NLGo\u001c:z\u0003y!W\r\u001d7ps\u0016$\u0017\t\u001d9mS\u000e\fG/[8ogJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002+c%\u0011!g\u000b\u0002\u001f\t\u0016\u0004Hn\\=fI\u0006\u0003\b\u000f\\5dCRLwN\\:SKB|7/\u001b;pef\f\u0011\u0003]1hS:\fG/[8o'\u0016\u0014h/[2f!\t)$)D\u00017\u0015\t9\u0004(\u0001\u0005f]JL7\r[3s\u0015\tI$(\u0001\u0003iiR\u0004(BA\u001e=\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003{y\na\u0001Z3qY>L(BA A\u0003\u001d!\u0017nZ5uC2T\u0011!Q\u0001\u0003C&L!a\u0011\u001c\u0003#A\u000bw-\u001b8bi&|gnU3sm&\u001cW-\u0001\nsKB|7/\u001b;pef\u0014Vm]8ve\u000e,\u0007C\u0001$H\u001b\u0005i\u0011B\u0001%\u000e\u0005I\u0011V\r]8tSR|'/\u001f*fg>,(oY3\u0002\rqJg.\u001b;?)\u0015YE*\u0014(P!\t1\u0005\u0001C\u0003)\u000b\u0001\u0007\u0011\u0006C\u00030\u000b\u0001\u0007\u0001\u0007C\u00034\u000b\u0001\u0007A\u0007C\u0003E\u000b\u0001\u0007Q\t\u000b\u0002\u0006#B\u0011!+X\u0007\u0002'*\u0011A+V\u0001\u000bC:tw\u000e^1uS>t'B\u0001,X\u0003\u001d1\u0017m\u0019;pefT!\u0001W-\u0002\u000b\t,\u0017M\\:\u000b\u0005i[\u0016aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003q\u000b1a\u001c:h\u0013\tq6KA\u0005BkR|w/\u001b:fI\u0006A!/Z:q_:\u001cX-F\u0001b!\t\u0011\u0017.D\u0001d\u0015\t!W-A\u0002ta&T!AZ4\u0002\u0011I,7\u000f^3bgfT!\u0001[.\u0002\u000b)\u0014wn]:\n\u0005)\u001c'\u0001\u0004%uiB\u0014Vm\u001d9p]N,\u0017!\u0003:fgB|gn]3!Q\t9Q\u000e\u0005\u0002om6\tqN\u0003\u0002\u0013a*\u0011\u0011O]\u0001\u0003eNT!a\u001d;\u0002\u0005]\u001c(\"A;\u0002\u000b)\fg/\u0019=\n\u0005]|'aB\"p]R,\u0007\u0010^\u0001\u001aG\",7m[%g+N,'\u000fS1t!\u0016\u0014X.[:tS>t7\u000fF\u0002{\u0003\u000f\u00012a_A\u0002\u001b\u0005a(BA?\u007f\u0003\r)H-\u001c\u0006\u0003\u001d}T1!!\u0001\u0014\u0003\u0019\u0001H.^4j]&\u0019\u0011Q\u0001?\u0003#\r{gNZ5hkJ\fG/[8o\u0013R,W\u000eC\u0004\u0002\n!\u0001\r!a\u0003\u0002\r!|7\u000f^%e!\u0011\ti!a\b\u000f\t\u0005=\u00111\u0004\t\u0005\u0003#\t9\"\u0004\u0002\u0002\u0014)\u0019\u0011QC\r\u0002\rq\u0012xn\u001c;?\u0015\t\tI\"A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\u001e\u0005]\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002\"\u0005\r\"AB*ue&twM\u0003\u0003\u0002\u001e\u0005]\u0011\u0001\u00074j]\u0012$U\r\u001d7ps\u0016$\u0017\t\u001d9mS\u000e\fG/[8ogRQ\u0011\u0011FA$\u0003\u0013\ni%a\u0016\u0011\r\u0005-\u0012\u0011GA\u001b\u001b\t\tiCC\u0002\u00020}\tA!\u001e;jY&!\u00111GA\u0017\u0005\u0011a\u0015n\u001d;\u0011\t\u0005]\u00121I\u0007\u0003\u0003sQA!a\u000f\u0002>\u0005\u0019A\r^8\u000b\u00079\tyDC\u0002\u0002BM\ta!\u001a8hS:,\u0017\u0002BA#\u0003s\u00111cQ8oM&<WO]1uS>t\u0017\n^3n\u0013\u0012Dq!!\u0003\n\u0001\u0004\tY\u0001C\u0004\u0002L%\u0001\r!a\u0003\u0002\u001f\u0011,\u0007\u000f\\8zK\u0012\f\u0005\u000f\u001d(b[\u0016Dq!a\u0014\n\u0001\u0004\t\t&\u0001\u0004qC\u001eLgn\u001a\t\u0005\u0003o\t\u0019&\u0003\u0003\u0002V\u0005e\"A\u0002)bO&tw\rC\u0004\u0002Z%\u0001\r!a\u0017\u0002\u000b=\u0014H-\u001a:\u0011\t\u0005]\u0012QL\u0005\u0005\u0003?\nID\u0001\u0005Pe\u0012,'/\u001b8h\u0003]\u0019w.\u001e8u\u000b:4\u0018N]8o[\u0016tGo\u001d\"z\u0011>\u001cH\u000f\u0006\u0004\u0002f\u0005-\u0014Q\u000e\t\u00049\u0005\u001d\u0014bAA5;\t9\u0011J\u001c;fO\u0016\u0014\bbBA\u0005\u0015\u0001\u0007\u00111\u0002\u0005\b\u0003_R\u0001\u0019AA\u0006\u0003=)gN^5s_:lWM\u001c;OC6,\u0017!F4fi\u0016sg/\u001b:p]6,g\u000e^:Cs\"{7\u000f\u001e\u000b\u000b\u0003k\ni(a \u0002\u0002\u0006\r\u0005CBA\u0016\u0003c\t9\b\u0005\u0003\u00028\u0005e\u0014\u0002BA>\u0003s\u0011a\u0002R3qY>LX.\u001a8u\u0013:4w\u000eC\u0004\u0002\n-\u0001\r!a\u0003\t\u000f\u0005=4\u00021\u0001\u0002\f!9\u0011qJ\u0006A\u0002\u0005E\u0003bBA-\u0017\u0001\u0007\u00111\f\u0015\u0004\u0001\u0005\u001d\u0005\u0003BAE\u0003\u001fk!!a#\u000b\u0007\u00055\u0015,\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!!%\u0002\f\n91+\u001a:wS\u000e,\u0007")
public class HostServiceImpl
implements HostService {
    private final EnvironmentRepository environmentRepository;
    private final DeployedApplicationsRepository deployedApplicationsRepository;
    private final PaginationService paginationService;
    private final RepositoryResource repositoryResource;
    @Context
    private final HttpResponse response;

    public HttpResponse response() {
        return this.response;
    }

    private ConfigurationItem checkIfUserHasPermissions(String hostId) {
        return this.repositoryResource.read(hostId);
    }

    public List<ConfigurationItemId> findDeployedApplications(String hostId, String deployedAppName, Paging paging, Ordering order) {
        this.checkIfUserHasPermissions(hostId);
        Paging limited = this.paginationService.getLimitedPaging(paging);
        this.paginationService.addPagingHeaderIfNeeded(paging, limited, this.paginationService.toSetHeader(this.response()), () -> Predef$.MODULE$.int2Integer($this.deployedApplicationsRepository.countByHost(hostId, deployedAppName)));
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.deployedApplicationsRepository.findByHost(hostId, deployedAppName, paging, order)).asJava();
    }

    public Integer countEnvironmentsByHost(String hostId, String environmentName) {
        this.checkIfUserHasPermissions(hostId);
        return Predef$.MODULE$.int2Integer(this.environmentRepository.count(hostId, Option$.MODULE$.apply((Object)environmentName)));
    }

    public List<DeploymentInfo> getEnvironmentsByHost(String hostId, String environmentName, Paging paging, Ordering order) {
        this.checkIfUserHasPermissions(hostId);
        Paging limited = this.paginationService.getLimitedPaging(paging);
        this.paginationService.addPagingHeaderIfNeeded(paging, limited, this.paginationService.toSetHeader(this.response()), () -> Predef$.MODULE$.int2Integer($this.environmentRepository.count(hostId, Option$.MODULE$.apply((Object)environmentName))));
        return this.environmentRepository.listEnvironmentsByHost(hostId, Option$.MODULE$.apply((Object)environmentName), paging, order);
    }

    @Autowired
    public HostServiceImpl(EnvironmentRepository environmentRepository, DeployedApplicationsRepository deployedApplicationsRepository, PaginationService paginationService, RepositoryResource repositoryResource) {
        this.environmentRepository = environmentRepository;
        this.deployedApplicationsRepository = deployedApplicationsRepository;
        this.paginationService = paginationService;
        this.repositoryResource = repositoryResource;
        this.response = null;
    }
}

