/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.engine.api.execution.SerializableTask;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskPackageDependency;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;
import com.xebialabs.deployit.engine.tasker.Task;
import com.xebialabs.deployit.engine.tasker.log.StepLogRetriever;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class TaskWithStepsView
implements TaskWithSteps {
    private TaskWithSteps wrapped;
    private StepLogRetriever stepLogRetriever;

    public TaskWithStepsView(SerializableTask wrapped) {
        Checks.checkArgument((boolean)(wrapped instanceof TaskWithSteps), (String)"Should be a TaskWithSteps, but was a %s", (Object[])new Object[]{wrapped.getClass()});
        this.wrapped = (TaskWithSteps)wrapped;
    }

    public TaskWithStepsView(SerializableTask wrapped, StepLogRetriever stepLogRetriever) {
        this(wrapped);
        this.stepLogRetriever = stepLogRetriever;
    }

    public TaskExecutionState getState() {
        return this.wrapped.getState();
    }

    public String getId() {
        return this.wrapped.getId();
    }

    public String getDescription() {
        return this.wrapped.getDescription();
    }

    public DateTime getScheduledDate() {
        return this.wrapped.getScheduledDate();
    }

    public DateTime getStartDate() {
        return this.wrapped.getStartDate();
    }

    public DateTime getCompletionDate() {
        return this.wrapped.getCompletionDate();
    }

    public int getNrSteps() {
        return this.wrapped.getNrSteps();
    }

    public int getCurrentStepNr() {
        return this.wrapped.getCurrentStepNr();
    }

    public List<Integer> getCurrentStepNrs() {
        return this.wrapped.getCurrentStepNrs();
    }

    public Map<String, String> getMetadata() {
        return this.wrapped.getMetadata();
    }

    public int getFailureCount() {
        return this.wrapped.getFailureCount();
    }

    public String getOwner() {
        return this.wrapped.getOwner();
    }

    public List<StepState> getSteps() {
        if (this.stepLogRetriever != null && this.wrapped instanceof Task) {
            return ((Task)this.wrapped).getSteps((b, s) -> this.stepLogRetriever.retrieveLogs(this.wrapped.getId(), b, s));
        }
        return this.wrapped.getSteps();
    }

    public StepState getStep(int nr) {
        if (this.stepLogRetriever != null && this.wrapped instanceof Task) {
            return ((Task)this.wrapped).getStep(nr, (b, s) -> this.stepLogRetriever.retrieveLogs(this.wrapped.getId(), b, s));
        }
        return this.wrapped.getStep(nr);
    }

    public Integer getWorkerId() {
        return this.wrapped.getWorkerId();
    }

    public List<TaskPackageDependency> getPackageDependencies() {
        return this.wrapped.getPackageDependencies();
    }
}

