/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.rest.api.reports.ExcelStyle$;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.task.archive.StatusOverviewDataReportLine;
import com.xebialabs.deployit.task.archive.StatusOverviewReportLine;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.Locale;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class DeploymentReportsUtility$ {
    public static final DeploymentReportsUtility$ MODULE$ = new DeploymentReportsUtility$();
    private static final DateTimeFormatter DEPLOYMENT_DATE_FORMAT_FILE_REPORT = DateTimeFormat.forPattern((String)"MMMM d, yyyy HH:mm a");

    private DateTimeFormatter DEPLOYMENT_DATE_FORMAT_FILE_REPORT() {
        return DEPLOYMENT_DATE_FORMAT_FILE_REPORT;
    }

    public Workbook createDeploymentsDashboardReport(DateTime begin, DateTime end, Collection<StatusOverviewReportLine> dashboardReport, Collection<StatusOverviewDataReportLine> deploymentReport, String serverName, String versionNumber) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        this.createTemplateTab(workbook, serverName, versionNumber, begin, end);
        this.createDashboardReportTab(workbook, dashboardReport);
        this.createDeploymentReportTab(workbook, deploymentReport);
        return workbook;
    }

    private void createTemplateTab(XSSFWorkbook workbook, String serverName, String versionNumber, DateTime begin, DateTime end) {
        String userName = Permissions.getAuthenticatedUserName();
        String dateTime = String.format("%s", this.DEPLOYMENT_DATE_FORMAT_FILE_REPORT().print((ReadablePartial)LocalDateTime.now()));
        String period = String.format("%s", new StringBuilder(4).append(this.DEPLOYMENT_DATE_FORMAT_FILE_REPORT().print((ReadableInstant)begin)).append(" to ").append(this.DEPLOYMENT_DATE_FORMAT_FILE_REPORT().print((ReadableInstant)end)).toString());
        String version = String.format("%s", new StringBuilder(7).append("Deploy ").append(versionNumber).toString());
        XSSFSheet sheet = workbook.createSheet("Report Info");
        sheet.setDefaultRowHeightInPoints(19.0f);
        String[] reportInfo = (String[])((Object[])new String[]{"Instance URL", "Report Generated On", "Generated By", "Version", "Period"});
        String[] reportInfoValue = (String[])((Object[])new String[]{serverName, dateTime, userName, version, period});
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            block0: {
                XSSFRow row = sheet.createRow(i);
                row.createCell(0).setCellValue(reportInfo[i]);
                row.createCell(1).setCellValue(reportInfoValue[i]);
                if (i != 0) break block0;
                XSSFCreationHelper createHelper = workbook.getCreationHelper();
                XSSFHyperlink link = createHelper.createHyperlink(HyperlinkType.URL);
                XSSFFont hLinkFont = workbook.createFont();
                XSSFCellStyle hLinkStyle = workbook.createCellStyle();
                hLinkFont.setUnderline((byte)1);
                hLinkStyle.setFont((Font)hLinkFont);
                link.setAddress(serverName);
                XSSFCell cell = row.getCell(1);
                cell.setCellStyle(ExcelStyle$.MODULE$.getHyperlinkCellStyle((Workbook)workbook));
                cell.setHyperlink((Hyperlink)link);
            }
        });
        ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.refArrayOps((Object[])reportInfo)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> sheet.autoSizeColumn(i));
    }

    private void createDashboardReportTab(XSSFWorkbook workbook, Collection<StatusOverviewReportLine> dashboardReport) {
        XSSFSheet sheet = workbook.createSheet("Dashboard Info");
        String[] dashboardReportColumn = (String[])((Object[])new String[]{"Success", "Rollback", "Retried", "Aborted", "Total"});
        XSSFRow headerRow = sheet.createRow(0);
        headerRow.createCell(0).setCellValue("");
        ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.refArrayOps((Object[])dashboardReportColumn)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            XSSFCell cell = headerRow.createCell(i + 1);
            cell.setCellValue(dashboardReportColumn[i]);
        });
        XSSFRow countRow = sheet.createRow(1);
        countRow.createCell(0).setCellValue("Count");
        ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.refArrayOps((Object[])dashboardReportColumn)).foreach((Function1 & Serializable)i -> countRow.createCell(BoxesRunTime.unboxToInt((Object)i) + 1));
        XSSFRow percentageRow = sheet.createRow(2);
        percentageRow.createCell(0).setCellValue("Percentage");
        IntRef total = IntRef.create((int)0);
        ((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(dashboardReport).asScala().zipWithIndex()).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)DeploymentReportsUtility$.$anonfun$createDashboardReportTab$3(check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> {
            DeploymentReportsUtility$.$anonfun$createDashboardReportTab$4(countRow, total, x$1);
            return BoxedUnit.UNIT;
        });
        ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.refArrayOps((Object[])dashboardReportColumn)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            XSSFCell cell = percentageRow.createCell(i + 1);
            double amount = countRow.getCell(i + 1).getNumericCellValue();
            cell.setCellValue(MODULE$.getFormattedPercentage(amount, total$1.elem));
        });
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> sheet.autoSizeColumn(i));
    }

    public double getPercentage(double numOfTasksInAState, double totalTasks) {
        Checks.checkArgument((numOfTasksInAState <= totalTasks ? 1 : 0) != 0, (String)new StringBuilder(151).append("Number of deplyments in a state passed to the percentage function cannot be greater than total number of deployments! numOfDeployment :").append(numOfTasksInAState).append("totalDeployment:").append(totalTasks).toString(), (Object[])new Object[0]);
        return totalTasks == 0.0 ? 0.0 : numOfTasksInAState / totalTasks * (double)100;
    }

    public String getFormattedPercentage(double numOfTasksInAState, double totalTasks) {
        DecimalFormat df = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        return new StringBuilder(1).append(df.format(this.getPercentage(numOfTasksInAState, totalTasks))).append("%").toString();
    }

    private void createDeploymentReportTab(XSSFWorkbook workbook, Collection<StatusOverviewDataReportLine> deploymentReport) {
        XSSFSheet sheet = workbook.createSheet("Deployment Info");
        sheet.setDefaultColumnWidth(30);
        String[] deploymentReportColumn = (String[])((Object[])new String[]{"Deployment Start DateTime", "Deployment End DateTime", "Deployment Status", "Task ID"});
        XSSFRow headerRow = sheet.createRow(0);
        ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.refArrayOps((Object[])deploymentReportColumn)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            XSSFCell cell = headerRow.createCell(i);
            cell.setCellValue(deploymentReportColumn[i]);
        });
        ((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(deploymentReport).asScala().zipWithIndex()).withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)DeploymentReportsUtility$.$anonfun$createDeploymentReportTab$2(check$ifrefutable$2))).foreach((Function1 & Serializable)x$2 -> {
            DeploymentReportsUtility$.$anonfun$createDeploymentReportTab$3(sheet, x$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$createDashboardReportTab$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$createDashboardReportTab$4(XSSFRow countRow$1, IntRef total$1, Tuple2 x$1) {
        BoxedUnit boxedUnit;
        block8: {
            Tuple2 tuple2;
            block7: {
                tuple2 = x$1;
                if (tuple2 == null) break block7;
                StatusOverviewReportLine p = (StatusOverviewReportLine)tuple2._1();
                String string = p.executionState();
                switch (string == null ? 0 : string.hashCode()) {
                    case -1149187101: {
                        if (!"SUCCESS".equals(string)) break;
                        countRow$1.getCell(1).setCellValue((double)p.amount());
                        boxedUnit = BoxedUnit.UNIT;
                        break block8;
                    }
                    case -476794961: {
                        if (!"ABORTED".equals(string)) break;
                        countRow$1.getCell(4).setCellValue((double)p.amount());
                        boxedUnit = BoxedUnit.UNIT;
                        break block8;
                    }
                    case 80012068: {
                        if (!"TOTAL".equals(string)) break;
                        countRow$1.getCell(5).setCellValue((double)p.amount());
                        total$1.elem = p.amount();
                        boxedUnit = BoxedUnit.UNIT;
                        break block8;
                    }
                    case 522907364: {
                        if (!"ROLLBACK".equals(string)) break;
                        countRow$1.getCell(2).setCellValue((double)p.amount());
                        boxedUnit = BoxedUnit.UNIT;
                        break block8;
                    }
                    case 2066319421: {
                        if (!"FAILED".equals(string)) break;
                        countRow$1.getCell(3).setCellValue((double)p.amount());
                        boxedUnit = BoxedUnit.UNIT;
                        break block8;
                    }
                }
                throw new MatchError((Object)string);
            }
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$createDeploymentReportTab$2(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$createDeploymentReportTab$3(XSSFSheet sheet$3, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        StatusOverviewDataReportLine p = (StatusOverviewDataReportLine)tuple2._1();
        int index = tuple2._2$mcI$sp();
        XSSFRow row = sheet$3.createRow(index + 1);
        row.createCell(0).setCellValue(String.format("%s", MODULE$.DEPLOYMENT_DATE_FORMAT_FILE_REPORT().print((ReadableInstant)p.startDate())));
        row.createCell(1).setCellValue(String.format("%s", MODULE$.DEPLOYMENT_DATE_FORMAT_FILE_REPORT().print((ReadableInstant)p.endDate())));
        row.createCell(2).setCellValue(p.status());
        row.createCell(3).setCellValue(p.taskId());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private DeploymentReportsUtility$() {
    }
}

