package com.xebialabs.deployit.core.rest.converters

import com.xebialabs.deployit.core.events.CiRef

import java.util
import javax.ws.rs.ext.MessageBodyWriter
import scala.jdk.CollectionConverters._

class CiIdsMessageConverter(messageBodyWriter: MessageBodyWriter[util.Collection[CiRef]])
  extends AbstractMessageConverter[util.Collection[CiRef]](messageBodyWriter) {

  override private[converters] def canConvertTo(payload: Any): Boolean = {
    val isCollection = classOf[util.Collection[_]].isAssignableFrom(payload.getClass)
    if (!isCollection) return false
    val collection: util.Collection[_] = payload.asInstanceOf[util.Collection[_]]
    !collection.isEmpty && classOf[CiRef].isAssignableFrom(collection.asScala.toList.headOption.getOrElse("").getClass)
  }

}
