package com.xebialabs.deployit.core.converters

import ai.digital.deploy.sql.model.ActiveUserSession
import com.xebialabs.xltype.serialization.json.JsonWriter

class SessionConverter {

  def toJson(activeSessions: ActiveUserSession): String = {
    val writer = new JsonWriter
    toJson(activeSessions, writer)
    writer.toString
  }

  def toJson(activeSessions: ActiveUserSession, writer: JsonWriter): Unit = {
    writer.`object`()
    writer.key("username").value(activeSessions.getUsername)
    writer.key("internal").value(activeSessions.isInternal)
    writer.key("controlTasks").value(activeSessions.getControlTasks)
    writer.key("deploymentTasks").value(activeSessions.getDeploymentTasks)
    writer.endObject()
  }
}
