package com.xebialabs.deployit.core.rest.api

import com.xebialabs.deployit.core.api.ApplicationStatusService
import com.xebialabs.deployit.core.service.{ApplicationStatusService => AppStatusService}
import com.xebialabs.deployit.engine.api.dto.{ApplicationDeploymentPackageState, Ordering}
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.util

@Component
class ApplicationStatusResourceImpl @Autowired()(applicationStatusService: AppStatusService)
  extends ApplicationStatusService with Logging {

  override def getDeployedApplications(deployedAppName: String, path: String, exactPath: Boolean, order: Ordering): util.List[ApplicationDeploymentPackageState] = {
    applicationStatusService.getApplicationStatus(deployedAppName, path, exactPath, order)
  }
}
