package com.xebialabs.deployit.core.rest.json;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.xltype.serialization.json.StepStateJsonConverter;
import org.springframework.stereotype.Component;

import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;


@Component
@Provider
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
public class StepStateJsonWriter implements MessageBodyWriter<StepState> {

    private static final StepStateJsonConverter stepStateJsonConverter = new StepStateJsonConverter();

    @Override
    public boolean isWriteable(Class<?> type, final Type genericType, final Annotation[] annotations, final MediaType mediaType) {
        return StepState.class.isAssignableFrom(type);
    }

    @Override
    public long getSize(final StepState stepState, final Class<?> type, final Type genericType, final Annotation[] annotations, final MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(final StepState stepState, final Class<?> type, final Type genericType, final Annotation[] annotations, final MediaType mediaType, final MultivaluedMap<String, Object> httpHeaders, final OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(toJson(stepState).getBytes());
    }

    @VisibleForTesting
    String toJson(StepState stepState) {
        return stepStateJsonConverter.toJson(stepState);
    }
}
