package com.xebialabs.deployit.core.rest.websockets

import ai.digital.configuration.central.deploy.WebSocketsProperties

import java.util.concurrent.{Executors, ScheduledExecutorService}
import com.xebialabs.deployit.core.websockets.ThreadPoolTaskExecutor
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.context.annotation.{Bean, Configuration}
import org.springframework.scheduling.concurrent.{ConcurrentTaskScheduler, CustomizableThreadFactory}

@Configuration
class WebsocketsExecutorConfiguration {

  @Autowired
  var websocketsConfig: WebSocketsProperties = _

  @Bean(destroyMethod = "shutdown")
  def websocketsExecutor: ThreadPoolTaskExecutor = {
    val threadPoolTaskExecutor = new ThreadPoolTaskExecutor()
    threadPoolTaskExecutor.setCorePoolSize(websocketsConfig.threadPool.corePoolSize)
    threadPoolTaskExecutor.setMaxPoolSize(websocketsConfig.threadPool.maxPoolSize)
    threadPoolTaskExecutor.setDaemon(websocketsConfig.threadPool.daemon)
    threadPoolTaskExecutor.setKeepAliveSeconds(websocketsConfig.threadPool.keepAliveSeconds)
    threadPoolTaskExecutor.setQueueCapacity(websocketsConfig.threadPool.queueCapacity)
    threadPoolTaskExecutor.setThreadNamePrefix("Websockets-Executor-")
    threadPoolTaskExecutor
  }

  @Bean(destroyMethod = "shutdown")
  def websocketsSchedulerExecutor: ScheduledExecutorService =
    Executors.newScheduledThreadPool(websocketsConfig.getThreadPool.corePoolSize,
    new CustomizableThreadFactory("Websockets-Scheduler-"))

  @Bean
  @Autowired
  def websocketsScheduler(@Qualifier("websocketsExecutor") threadPoolTaskExecutor: ThreadPoolTaskExecutor,
                          @Qualifier("websocketsSchedulerExecutor") scheduledExecutorService: ScheduledExecutorService
                         ) = new ConcurrentTaskScheduler(threadPoolTaskExecutor, scheduledExecutorService)
}
