/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports.widgets;

import ai.digital.deploy.sql.model.Report;
import ai.digital.deploy.sql.model.ReportLine;
import com.xebialabs.deployit.core.rest.api.reports.ReportUtils;
import com.xebialabs.deployit.core.rest.api.reports.widgets.DashboardWidgetBase;
import com.xebialabs.deployit.task.archive.AverageDeploymentsDurationOverTimeReportLine;
import com.xebialabs.deployit.task.archive.TaskArchive;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class DeploymentTrendsPercentileWidget
extends DashboardWidgetBase {
    private static final String TIME_SCALE = "timeScale";
    private static final String DEPLOYMENT_TIME = "deploymentTime";

    public DeploymentTrendsPercentileWidget(TaskArchive taskArchive) {
        super(taskArchive);
    }

    @Override
    public Report getReport(DateTime begin, DateTime end) {
        return this.transformResult(this.taskArchive.averageDurationDeploymentsOverTime(begin, end), begin, end);
    }

    private Report transformResult(Collection<AverageDeploymentsDurationOverTimeReportLine> searchResult, DateTime begin, DateTime end) {
        Report report = new Report();
        if (end.isBefore((ReadableInstant)begin)) {
            return report;
        }
        Map<Integer, Map<Integer, Double>> searchResultGroupedByYearMonth = searchResult.stream().collect(Collectors.groupingBy(AverageDeploymentsDurationOverTimeReportLine::year, Collectors.groupingBy(AverageDeploymentsDurationOverTimeReportLine::monthno, Collectors.averagingLong(AverageDeploymentsDurationOverTimeReportLine::durationMillis))));
        ReportUtils.getMonthsOfInterval(begin, end).forEach(month -> {
            Map monthDurationResult = (Map)searchResultGroupedByYearMonth.get(month.getYear());
            DeploymentTrendsPercentileWidget.addReportLine(report, month.getMonthOfYear(), monthDurationResult);
        });
        return report;
    }

    private static ReportTimeScale findTimeScale(Map<Integer, Double> averageDurationByMonth) {
        long maxDeploymentTime;
        long l = maxDeploymentTime = averageDurationByMonth == null ? 0L : Collections.max(averageDurationByMonth.values()).longValue();
        if (TimeUnit.MILLISECONDS.toSeconds(maxDeploymentTime) < 600L) {
            return ReportTimeScale.SECS;
        }
        if (TimeUnit.MILLISECONDS.toMinutes(maxDeploymentTime) < 600L) {
            return ReportTimeScale.MINS;
        }
        return ReportTimeScale.HRS;
    }

    private static void addReportLine(Report report, int month, Map<Integer, Double> monthDurationResult) {
        ReportLine line = report.addLine();
        line.addValue("month", (Object)DeploymentTrendsPercentileWidget.getFormattedMonth(month));
        long averageDuration = monthDurationResult == null || monthDurationResult.get(month) == null ? 0L : monthDurationResult.get(month).longValue();
        ReportTimeScale timeScale = DeploymentTrendsPercentileWidget.findTimeScale(monthDurationResult);
        line.addValue(TIME_SCALE, (Object)timeScale.toString());
        switch (timeScale) {
            case SECS: {
                line.addValue(DEPLOYMENT_TIME, (Object)DeploymentTrendsPercentileWidget.formatToSecs(averageDuration));
                break;
            }
            case MINS: {
                line.addValue(DEPLOYMENT_TIME, (Object)DeploymentTrendsPercentileWidget.formatToMins(averageDuration));
                break;
            }
            default: {
                line.addValue(DEPLOYMENT_TIME, (Object)DeploymentTrendsPercentileWidget.formatToHours(averageDuration));
            }
        }
    }

    private static enum ReportTimeScale {
        SECS,
        MINS,
        HRS;

    }
}

