package com.xebialabs.deployit.core.rest.websockets

import com.xebialabs.deployit.core.events.JmsCiChangeSetEvent
import com.xebialabs.deployit.core.events.constants.JmsCiQueueName
import com.xebialabs.deployit.event.EventBusHolder
import org.springframework.jms.annotation.JmsListener
import org.springframework.stereotype.Component

@Component
class WebSocketJmsConnector {

  @JmsListener(destination = JmsCiQueueName.cisChangedQueueName, containerFactory = "xlJmsListenerContainerFactory")
  def createCisMessages(event: JmsCiChangeSetEvent): Unit = {
    EventBusHolder.publish(event)
  }
}
