package com.xebialabs.deployit.core.rest.api.reports.widgets;

import com.xebialabs.deployit.core.rest.api.reports.TaskArchiveReport;
import com.xebialabs.deployit.task.archive.TaskArchive;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Month;
import java.time.format.TextStyle;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

import static com.xebialabs.deployit.checks.Checks.checkArgument;

abstract class DashboardWidgetBase extends TaskArchiveReport implements Widget {
    protected static final int TOP_N = 10;
    protected static final String NUMBER_SUCCESSFUL_DEPLOYMENTS = "noOfSuccessfulDeployments";
    protected static final String NUMBER_ABORTED_DEPLOYMENTS = "noOfAbortedDeployments";
    protected static final String NUMBER_FAILED_DEPLOYMENTS = "noOfFailedDeployments";
    protected static final String NUMBER_ROLLBACK_DEPLOYMENTS = "noOfRollbacks";
    protected static final String MONTH = "month";

    public static final String ZERO = String.format("%.2f", 0d);

    protected DashboardWidgetBase(TaskArchive taskArchive) {
        super(taskArchive);
    }

    protected static final double getPercentage(final double numOfTasksInAState, final double totalTasks) {
        checkArgument(numOfTasksInAState <= totalTasks,
                "Number of deplyments in a state passed to the percentage function cannot be greater than total number of deployments! numOfDeployment :"
                        + numOfTasksInAState + "totalDeployment:" + totalTasks);
        return (totalTasks == 0) ? 0 : (numOfTasksInAState / totalTasks) * 100;
    }

    protected static final String getFormattedPercentage(final double numOfTasksInAState, final double totalTasks) {
        DecimalFormat df = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        return df.format(getPercentage(numOfTasksInAState, totalTasks));
    }

    protected static final String getFormattedMonth(final int monthOfYear) {
        return Month.of(monthOfYear).getDisplayName(TextStyle.SHORT, Locale.US);
    }

    static final String formatToMinsAndSecs(final long millis) {
        final long secs = TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis));
        String seconds = String.valueOf(secs);
        if (secs < 10) {
            seconds = "0" + seconds;
        }
        return String.format("%d:%s", TimeUnit.MILLISECONDS.toMinutes(millis), seconds);
    }

    protected static final String formatToSecs(final long millis) {
        final long seconds = TimeUnit.MILLISECONDS.toSeconds(millis);
        return String.format("%d", seconds);
    }

    protected static final String formatToMins(final long millis) {
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis);
        final long seconds = TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(minutes);
        if (seconds >= 30) {
            minutes++;
        }
        return String.format("%d", minutes);
    }

    protected static final String formatToHours(final long millis) {
        long hours = TimeUnit.MILLISECONDS.toHours(millis);
        final long minutes = TimeUnit.MILLISECONDS.toMinutes(millis) - TimeUnit.HOURS.toMinutes(hours);
        if (minutes >= 30) {
            hours++;
        }
        return String.format("%d", hours);
    }

}
