package com.xebialabs.deployit.core.rest.json;

import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.repository.RepositoryAdapterFactory;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

@Component
public class ReaderPostProcessor {
    private final RepositoryAdapterFactory factory;

    @Autowired
    public ReaderPostProcessor(RepositoryAdapterFactory factory) {
        this.factory = factory;
    }

    <T> T apply(Function<CiConverterContext, T> convertCallback, Boolean skipNotExistingCis, Integer referenceDepth) {
        CiConverterContext context = new CiConverterContext();
        T result = convertCallback.apply(context);

        Repository repository = factory.create();
        context.converters.forEach(ciConverter -> ciConverter.resolveReferences(repository, skipNotExistingCis, referenceDepth));
        return result;
    }

    <T> T apply(Function<CiConverterContext, T> convertCallback) {
        return this.apply(convertCallback, false, Integer.MAX_VALUE);
    }

    <T> T apply(Function<CiConverterContext, T> convertCallback, Integer depth) {
        return this.apply(convertCallback, false, depth);
    }

    static class CiConverterContext {
        private final List<ConfigurationItemConverter> converters = new ArrayList<>();

        public void register(ConfigurationItemConverter converter) {
            converters.add(converter);
        }
    }
}
