/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.xml;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.xebialabs.deployit.core.xml.PasswordEncryptingXStreamCiConverter;
import com.xebialabs.deployit.engine.api.dto.ValidatedConfigurationItem;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryAdapterFactory;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.CiReference;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import com.xebialabs.xltype.serialization.util.ReferenceUtils;
import com.xebialabs.xltype.serialization.xstream.CiXstreamReader;
import com.xebialabs.xltype.serialization.xstream.XStreamProvider;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@XStreamProvider(tagName="configuration-item", readable=ConfigurationItem.class)
public class XStreamCiConverterWithRepository
extends PasswordEncryptingXStreamCiConverter {
    static final ThreadLocal<Map<String, ConfigurationItem>> DESERIALIZATION_CONTEXT = ThreadLocal.withInitial(Maps::newHashMap);
    static final ThreadLocal<List<CiReference>> DESERIALIZATION_REFERENCES = ThreadLocal.withInitial(Lists::newArrayList);
    static final ThreadLocal<RepositoryAdapterFactory> REPOSITORY_ADAPTER_FACTORY = new ThreadLocal();
    private final RepositoryAdapterFactory factory;

    @Autowired
    public XStreamCiConverterWithRepository(RepositoryAdapterFactory factory) {
        this.factory = factory;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ConfigurationItemConverter converter = this.createConverter((DataHolder)context);
        ConfigurationItem ci = converter.readCi((CiReader)new CiXstreamReader(reader));
        DESERIALIZATION_REFERENCES.get().addAll(converter.getReferences());
        REPOSITORY_ADAPTER_FACTORY.set(this.factory);
        if (ci instanceof ValidatedConfigurationItem) {
            DESERIALIZATION_CONTEXT.get().put(ci.getId(), ((ValidatedConfigurationItem)ci).getWrapped());
        } else {
            DESERIALIZATION_CONTEXT.get().put(ci.getId(), ci);
        }
        return ci;
    }

    static void postProcess() {
        try {
            RepositoryAdapterFactory factory = REPOSITORY_ADAPTER_FACTORY.get();
            ReferenceUtils.resolveReferences(DESERIALIZATION_REFERENCES.get(), DESERIALIZATION_CONTEXT.get(), (Repository)(factory != null ? factory.create() : null));
        }
        finally {
            XStreamCiConverterWithRepository.clear();
        }
    }

    public static void clear() {
        DESERIALIZATION_REFERENCES.remove();
        DESERIALIZATION_CONTEXT.remove();
        REPOSITORY_ADAPTER_FACTORY.remove();
    }
}

