package com.xebialabs.deployit.core.rest.json

import java.io.{IOException, OutputStream, OutputStreamWriter}
import java.lang.annotation.Annotation
import java.lang.reflect.Type

import ai.digital.deploy.sql.model.Report
import com.xebialabs.xltype.serialization.json.JsonWriter
import javax.ws.rs.core.{MediaType, MultivaluedMap}
import javax.ws.rs.ext.{MessageBodyWriter, Provider}
import javax.ws.rs.{Produces, WebApplicationException}
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
@Provider
@Produces(Array(MediaType.APPLICATION_JSON))
class ReportJsonWriter extends MessageBodyWriter[Report] {

  override def isWriteable(`type`: Class[_], genericType: Type, annotations: Array[Annotation],
                           mediaType: MediaType): Boolean = classOf[Report].isAssignableFrom(`type`)

  override def getSize(report: Report, `type`: Class[_], genericType: Type, annotations: Array[Annotation],
                       mediaType: MediaType): Long = -1

  @throws[IOException]
  @throws[WebApplicationException]
  override def writeTo(report: Report, `type`: Class[_], genericType: Type, annotations: Array[Annotation],
                       mediaType: MediaType, httpHeaders: MultivaluedMap[String, AnyRef],
                       entityStream: OutputStream): Unit = {
    val reportStreamWriter: OutputStreamWriter = new OutputStreamWriter(entityStream)
    writeJson(report, new JsonWriter(reportStreamWriter))
    reportStreamWriter.flush()
  }

  private def writeJson(report: Report, writer: JsonWriter): Unit = {
    writer.array
    report.getLines.asScala.foreach(reportLine => {
      writer.`object`()
      reportLine.getValues.asScala.foreach({
        case (reportColumn, rowValue) => writer.key(reportColumn).value(rowValue)
      })
      writer.endObject()
    })
    writer.endArray
  }
}
