package com.xebialabs.deployit.core.rest.api.reports

import java.awt.Color

import org.apache.poi.ss.usermodel._
import org.apache.poi.xssf.usermodel.{XSSFCellStyle, XSSFColor, XSSFWorkbook}

object ExcelStyle {

  val XL_GREEN: XSSFColor = new XSSFColor(new Color(73, 133, 0))

  def getCellStyle(workbook: XSSFWorkbook): CellStyle = {
    val cellStyle: XSSFCellStyle = workbook.createCellStyle()
    cellStyle.setFont(getFont(workbook))
    cellStyle.setFillForegroundColor(ExcelStyle.XL_GREEN)
    cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND)
    cellStyle
  }

  def getFont(workbook: Workbook): Font = {
    val font = workbook.createFont
    font.setFontHeightInPoints(14.toShort)
    font.setColor(IndexedColors.WHITE.getIndex)
    font
  }

  def getBoldCellStyle(workbook: Workbook): CellStyle = {
    val cellStyle = workbook.createCellStyle
    cellStyle.setFont(getBoldFont(workbook))
    cellStyle.setFillForegroundColor(IndexedColors.WHITE.getIndex)
    cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND)
    cellStyle
  }

  def getBoldFont(workbook: Workbook): Font = {
    val font = workbook.createFont
    font.setBold(true)
    font
  }

  def cellBorderStyle(workbook: XSSFWorkbook): XSSFCellStyle = {
    val cellStyle: XSSFCellStyle = workbook.createCellStyle()
    cellStyle.setBorderLeft(BorderStyle.THIN)
    cellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex())
    cellStyle.setBorderRight(BorderStyle.THIN)
    cellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex())
    cellStyle.setBorderTop(BorderStyle.THIN)
    cellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex())
    cellStyle.setBorderBottom(BorderStyle.THIN)
    cellStyle
  }

  def getHyperlinkCellStyle(workbook: Workbook): CellStyle = {
    val style = workbook.createCellStyle
    val font = workbook.createFont
    font.setUnderline(Font.U_SINGLE)
    font.setColor(IndexedColors.BLUE.getIndex)
    style.setFont(font)
    style
  }

}
