package com.xebialabs.deployit.core.rest.json;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.engine.api.dto.ServerInfo;
import com.xebialabs.xltype.serialization.json.ServerInfoJsonConverter;
import org.springframework.stereotype.Component;

import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

@Component
@Provider
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
public class ServerInfoJsonWriter implements MessageBodyWriter<ServerInfo> {

    @Override
    public boolean isWriteable(Class<?> type, final Type genericType, final Annotation[] annotations, final MediaType mediaType) {
        return ServerInfo.class.isAssignableFrom(type);
    }

    @Override
    public long getSize(final ServerInfo serverInfo, final Class<?> type, final Type genericType, final Annotation[] annotations, final MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(final ServerInfo serverInfo, final Class<?> type, final Type genericType, final Annotation[] annotations, final MediaType mediaType, final MultivaluedMap<String, Object> httpHeaders, final OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(toJson(serverInfo).getBytes());
    }

    @VisibleForTesting
    String toJson(final ServerInfo serverInfo) {
        return new ServerInfoJsonConverter().toJson(serverInfo);
    }
}
