package com.xebialabs.deployit.core.rest.json;

import com.xebialabs.deployit.core.xml.PasswordEncryptingCiConverter;
import com.xebialabs.deployit.engine.api.dto.Control;
import com.xebialabs.xltype.serialization.json.ControlJsonConverter;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;

@Component
@Provider
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
public class ControlJsonMessageBodyReaderWriter implements MessageBodyReader<Control>, MessageBodyWriter<Control> {
    private final ReaderPostProcessor postProcessor;

    @Autowired
    public ControlJsonMessageBodyReaderWriter(ReaderPostProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    @Override
    public boolean isReadable(final Class<?> type, final Type genericType, final Annotation[] annotations, final MediaType mediaType) {
        return Control.class.isAssignableFrom(type);
    }

    @Override
    public Control readFrom(final Class<Control> type, final Type genericType, final Annotation[] annotations, final MediaType mediaType, final MultivaluedMap<String, String> httpHeaders, final InputStream entityStream) throws IOException, WebApplicationException {
        String json = IOUtils.toString(entityStream, StandardCharsets.UTF_8);
        return postProcessor.apply(context -> {
            PasswordEncryptingCiConverter converter = new PasswordEncryptingCiConverter();
            context.register(converter);
            return new ControlJsonConverter(converter).toControl(json);
        });
    }

    @Override
    public boolean isWriteable(final Class<?> type, final Type genericType, final Annotation[] annotations, final MediaType mediaType) {
        return Control.class.isAssignableFrom(type);
    }

    @Override
    public long getSize(final Control control, final Class<?> type, final Type genericType, final Annotation[] annotations, final MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(final Control control, final Class<?> type, final Type genericType, final Annotation[] annotations, final MediaType mediaType, final MultivaluedMap<String, Object> httpHeaders, final OutputStream entityStream) throws IOException, WebApplicationException {
        String json = new ControlJsonConverter(new PasswordEncryptingCiConverter()).toJson(control);
        entityStream.write(json.getBytes(StandardCharsets.UTF_8));
    }

}
