/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.core.rest.json;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

import org.springframework.stereotype.Component;

import com.google.common.annotations.VisibleForTesting;

import com.xebialabs.deployit.engine.api.dto.SatelliteInfo;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import com.xebialabs.xltype.serialization.json.SatelliteInfoJsonConverter;
import com.xebialabs.xltype.serialization.rest.TypeMatcher;

@Component
@Provider
@Produces({MediaType.APPLICATION_JSON})
public class SatelliteInfoListJsonWriter implements MessageBodyWriter<Collection<SatelliteInfo>> {

    private final TypeMatcher matcher = new TypeMatcher(Collection.class, SatelliteInfo.class);
    private final SatelliteInfoJsonConverter satelliteInfoJsonConverter = new SatelliteInfoJsonConverter();

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return matcher.matches(type, genericType);
    }

    @Override
    public long getSize(Collection<SatelliteInfo> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(Collection<SatelliteInfo> satelliteInfos, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders,
                        OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(toJson(satelliteInfos).getBytes());
    }

    @VisibleForTesting
    String toJson(Collection<SatelliteInfo> satelliteInfos) {
        JsonWriter writer = new JsonWriter();
        writer.array();
        for (SatelliteInfo satelliteInfo : satelliteInfos) {
            satelliteInfoJsonConverter.toJson(satelliteInfo, writer);
        }
        writer.endArray();
        return writer.toString();
    }
}
