package com.xebialabs.deployit.core.rest.api

import java.util.{List => JList}

import ai.digital.deploy.sql.model.settings.{FeatureSettings, GeneralSettings}
import com.xebialabs.deployit.core.api.SettingsResource
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource
import com.xebialabs.deployit.core.service.{FeatureSettingsService, GeneralSettingsService}
import com.xebialabs.deployit.core.util.GeneralSettingsUtils
import com.xebialabs.deployit.security.permission.PlatformPermissions.ADMIN
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Controller

@Controller
class SettingsResourceImpl(@Autowired generalSettingService: GeneralSettingsService,
                           @Autowired featureSettingsService: FeatureSettingsService)
  extends AbstractSecuredResource with SettingsResource {

  override def getGeneralSettings: GeneralSettings = {
    generalSettingService.getGeneralSettings
  }

  override def updateGeneralSettings(generalSettings: GeneralSettings): GeneralSettings = {
    checkPermission(ADMIN)
    GeneralSettingsUtils.validate(generalSettings)
    generalSettingService.updateGeneralSettings(generalSettings)
  }

  override def getFeatureSettings: JList[FeatureSettings] = {
    featureSettingsService.getFeatureSettings()
  }

  override def saveFeatureSettings(features: JList[FeatureSettings]): JList[FeatureSettings] = {
    checkPermission(ADMIN)
    featureSettingsService.updateFeatureSettings(features)
    featureSettingsService.getFeatureSettings()
  }
}
