/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports.widgets;

import com.xebialabs.deployit.core.rest.api.reports.widgets.DeploymentTrendsPercentileWidget;
import com.xebialabs.deployit.core.rest.api.reports.widgets.DeploymentTrendsWidget;
import com.xebialabs.deployit.core.rest.api.reports.widgets.DeploymentsDurationFrequencyWidget;
import com.xebialabs.deployit.core.rest.api.reports.widgets.DeploymentsPercentageWidgetData;
import com.xebialabs.deployit.core.rest.api.reports.widgets.Top10LongestRunningDeployments;
import com.xebialabs.deployit.core.rest.api.reports.widgets.Top10RetriedDeployments;
import com.xebialabs.deployit.core.rest.api.reports.widgets.Top10SuccessfulDeployments;
import com.xebialabs.deployit.core.rest.api.reports.widgets.Widget;
import com.xebialabs.deployit.task.archive.TaskArchive;

public enum WidgetRegistry {
    DEPLOYMENTSUCCESS("deploymentSuccess"){

        @Override
        public final Widget getWidget(TaskArchive taskArchive) {
            return new DeploymentsPercentageWidgetData(taskArchive);
        }
    }
    ,
    DEPLOYMENTDURATION("deploymentDuration"){

        @Override
        public final Widget getWidget(TaskArchive taskArchive) {
            return new DeploymentsDurationFrequencyWidget(taskArchive);
        }
    }
    ,
    DEPLOYMENTTREND("deploymentTrend"){

        @Override
        public Widget getWidget(TaskArchive taskArchive) {
            return new DeploymentTrendsWidget(taskArchive);
        }
    }
    ,
    DEPLOYMENTTRENDPERCENTILE("deploymentTrendPercentile"){

        @Override
        public Widget getWidget(TaskArchive taskArchive) {
            return new DeploymentTrendsPercentileWidget(taskArchive);
        }
    }
    ,
    TOP10SUCCESSFULDEPLOYMENTS("top10SuccessfulDeployments"){

        @Override
        public Widget getWidget(TaskArchive taskArchive) {
            return new Top10SuccessfulDeployments(taskArchive);
        }
    }
    ,
    TOP10RETRIEDDEPLOYMENTS("top10RetriedDeployments"){

        @Override
        public Widget getWidget(TaskArchive taskArchive) {
            return new Top10RetriedDeployments(taskArchive);
        }
    }
    ,
    TOP10LONGESTRUNNINGDEPLOYMENTS("top10LongestRunningDeployments"){

        @Override
        public Widget getWidget(TaskArchive taskArchive) {
            return new Top10LongestRunningDeployments(taskArchive);
        }
    };

    private String widgetName;

    private WidgetRegistry(String widgetName) {
        this.widgetName = widgetName;
    }

    public final String getWidgetType() {
        return this.widgetName;
    }

    public abstract Widget getWidget(TaskArchive var1);
}

