/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.support;

import com.xebialabs.deployit.engine.api.execution.SerializableTask;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.task.TaskMetadata;
import com.xebialabs.deployit.task.TaskType;
import java.util.Arrays;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskPermissionFilter
implements Predicate<SerializableTask> {
    private static final Logger logger = LoggerFactory.getLogger(TaskPermissionFilter.class);

    @Override
    public boolean test(SerializableTask taskState) {
        String envId = TaskMetadata.getMetadata((SerializableTask)taskState, (String)"environment_id");
        TaskType taskType = this.getTaskType(taskState);
        String taskId = taskState.getId();
        if (envId == null || taskType == null) {
            logger.debug("including non deployment task {}", (Object)taskId);
            return true;
        }
        switch (taskType) {
            case INITIAL: {
                return this.checkPermissionAndLog(taskId, envId, "initial deploy", DeployitPermissions.DEPLOY_INITIAL);
            }
            case UPGRADE: {
                return this.checkPermissionAndLog(taskId, envId, "upgrade", DeployitPermissions.DEPLOY_UPGRADE);
            }
            case INSPECTION: {
                return this.checkPermissionAndLog(taskId, "discovery", DeployitPermissions.DISCOVERY);
            }
            case CONTROL: {
                return this.checkPermissionAndLog(taskId, envId, "controltask", DeployitPermissions.CONTROLTASK_EXECUTE);
            }
            case UNDEPLOY: {
                return this.checkPermissionAndLog(taskId, envId, "undeploy", DeployitPermissions.UNDEPLOY);
            }
            case ROLLBACK: {
                return this.checkPermissionAndLog(taskId, envId, "undeploy", DeployitPermissions.DEPLOY_UPGRADE, DeployitPermissions.DEPLOY_INITIAL);
            }
        }
        return false;
    }

    private boolean checkPermissionAndLog(String taskId, String envId, String right, Permission permission) {
        if (TaskPermissionFilter.hasPermission(permission, envId)) {
            logger.debug("including task {} user has {} rights on {}", new Object[]{taskId, right, envId});
            return true;
        }
        return false;
    }

    private boolean checkPermissionAndLog(String taskId, String envId, String right, Permission ... permissions) {
        if (Arrays.stream(permissions).anyMatch(p -> TaskPermissionFilter.hasPermission(p, envId))) {
            logger.debug("including task {} user has {} rights on {}", new Object[]{taskId, right, envId});
            return true;
        }
        return false;
    }

    private boolean checkPermissionAndLog(String taskId, String right, Permission permission) {
        if (TaskPermissionFilter.hasPermission(permission)) {
            logger.debug("including task {} user has {} rights", (Object)taskId, (Object)right);
            return true;
        }
        return false;
    }

    private TaskType getTaskType(SerializableTask taskState) {
        try {
            String taskType = TaskMetadata.getMetadata((SerializableTask)taskState, (String)"taskType");
            if (taskType != null) {
                return TaskType.valueOf((String)taskType);
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    protected static boolean hasPermission(Permission permission) {
        return TaskPermissionFilter.hasPermission(permission, null);
    }

    protected static boolean hasPermission(Permission permission, String id) {
        return permission.getPermissionHandler().hasPermission(id);
    }
}

