/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.websockets;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.core.config.WebSocketsConfiguration;
import com.xebialabs.deployit.core.rest.converters.CiIdsMessageConverter;
import com.xebialabs.deployit.core.rest.json.CiRefsJsonWriter;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodReturnValueHandler;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketTransportRegistration;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.RequestUpgradeStrategy;
import org.springframework.web.socket.server.jetty.JettyRequestUpgradeStrategy;
import org.springframework.web.socket.server.support.DefaultHandshakeHandler;
import scala.reflect.ScalaSignature;

@Configuration
@EnableWebSocketMessageBroker
@ScalaSignature(bytes="\u0006\u0005\u0005%e\u0001B\u0007\u000f\u0001mA\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\"AA\u000b\u0001B\u0001B\u0003%Q\u000b\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003b\u0011\u00159\u0007\u0001\"\u0001i\u0011\u001d)\bA1A\u0005\nYDa! \u0001!\u0002\u00139\b\"\u0002@\u0001\t\u0003z\bbBA\r\u0001\u0011\u0005\u00111\u0004\u0005\b\u0003w\u0001A\u0011IA\u001f\u0011\u001d\t9\u0005\u0001C!\u0003\u0013Bq!a\u0015\u0001\t\u0003\n)F\u0001\u000fXK\n\u001cvnY6fi6+7o]1hK\n\u0013xn[3s\u0007>tg-[4\u000b\u0005=\u0001\u0012AC<fEN|7m[3ug*\u0011\u0011CE\u0001\u0005e\u0016\u001cHO\u0003\u0002\u0014)\u0005!1m\u001c:f\u0015\t)b#\u0001\u0005eKBdw._5u\u0015\t9\u0002$A\u0005yK\nL\u0017\r\\1cg*\t\u0011$A\u0002d_6\u001c\u0001aE\u0002\u00019\u0011\u0002\"!\b\u0012\u000e\u0003yQ!a\b\u0011\u0002\t1\fgn\u001a\u0006\u0002C\u0005!!.\u0019<b\u0013\t\u0019cD\u0001\u0004PE*,7\r\u001e\t\u0003KIj\u0011A\n\u0006\u0003O!\n!\"\u00198o_R\fG/[8o\u0015\tI#&\u0001\u0004d_:4\u0017n\u001a\u0006\u0003W1\naa]8dW\u0016$(BA\u0017/\u0003\r9XM\u0019\u0006\u0003_A\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002c\u0005\u0019qN]4\n\u0005M2#\u0001I,fEN{7m[3u\u001b\u0016\u001c8/Y4f\u0005J|7.\u001a:D_:4\u0017nZ;sKJ\f\u0001cY5SK\u001a\u001c(j]8o/JLG/\u001a:\u0011\u0005YJT\"A\u001c\u000b\u0005a\u0002\u0012\u0001\u00026t_:L!AO\u001c\u0003!\rK'+\u001a4t\u0015N|gn\u0016:ji\u0016\u0014\bFA\u0001=!\ti4)D\u0001?\u0015\t9sH\u0003\u0002A\u0003\u00069a-Y2u_JL(B\u0001\"/\u0003\u0015\u0011W-\u00198t\u0013\t!eHA\u0005BkR|w/\u001b:fI\u0006iA/Y:l'\u000eDW\rZ;mKJ\u0004\"a\u0012&\u000e\u0003!S!!\u0013\u0018\u0002\u0015M\u001c\u0007.\u001a3vY&tw-\u0003\u0002L\u0011\niA+Y:l'\u000eDW\rZ;mKJDCAA'Q#B\u0011QHT\u0005\u0003\u001fz\u0012\u0011\"U;bY&4\u0017.\u001a:\u0002\u000bY\fG.^3\"\u0003I\u000b1c^3cg>\u001c7.\u001a;t'\u000eDW\rZ;mKJD#A\u0001\u001f\u0002\u001fU\u001cXM]%oi\u0016\u00148-\u001a9u_J\u0004\"AV.\u000e\u0003]S!\u0001W-\u0002\u000fM,\b\u000f]8si*\u0011!LL\u0001\n[\u0016\u001c8/Y4j]\u001eL!\u0001X,\u0003%\rC\u0017M\u001c8fY&sG/\u001a:dKB$xN\u001d\u0015\u0005\u00075\u0003f,I\u0001UQ\t\u0019A(A\fxK\n\u001cvnY6fiN\u001cuN\u001c4jOV\u0014\u0018\r^5p]B\u0011!\rZ\u0007\u0002G*\u0011\u0011FE\u0005\u0003K\u000e\u0014qcV3c'>\u001c7.\u001a;t\u0007>tg-[4ve\u0006$\u0018n\u001c8)\u0005\u0011a\u0014A\u0002\u001fj]&$h\bF\u0003jW6\u00048\u000f\u0005\u0002k\u00015\ta\u0002C\u00035\u000b\u0001\u0007Q\u0007\u000b\u0002ly!)Q)\u0002a\u0001\r\"\"Q.\u0014)RQ\tiG\bC\u0003U\u000b\u0001\u0007Q\u000b\u000b\u0003q\u001bBs\u0006F\u00019=\u0011\u0015\u0001W\u00011\u0001bQ\t\u0019H(A\bj]B,HOQ;gM\u0016\u00148+\u001b>f+\u00059\bC\u0001=|\u001b\u0005I(\"\u0001>\u0002\u000bM\u001c\u0017\r\\1\n\u0005qL(aA%oi\u0006\u0001\u0012N\u001c9vi\n+hMZ3s'&TX\rI\u0001\u0017G>tg-[4ve\u0016lUm]:bO\u0016\u0014%o\\6feR!\u0011\u0011AA\u0004!\rA\u00181A\u0005\u0004\u0003\u000bI(\u0001B+oSRDq!!\u0003\t\u0001\u0004\tY!\u0001\u0005sK\u001eL7\u000f\u001e:z!\u0011\ti!!\u0006\u000e\u0005\u0005=!bA\u0015\u0002\u0012)\u0019\u00111C-\u0002\tMLW\u000e]\u0005\u0005\u0003/\tyAA\u000bNKN\u001c\u0018mZ3Ce>\\WM\u001d*fO&\u001cHO]=\u0002!!\fg\u000eZ:iC.,\u0007*\u00198eY\u0016\u0014HCAA\u000f!\u0011\ty\"a\n\u000e\u0005\u0005\u0005\"b\u0001-\u0002$)\u0019\u0011Q\u0005\u0016\u0002\rM,'O^3s\u0013\u0011\tI#!\t\u0003/\u0011+g-Y;mi\"\u000bg\u000eZ:iC.,\u0007*\u00198eY\u0016\u0014\bfA\u0005\u0002.A!\u0011qFA\u001c\u001b\t\t\tDC\u0002(\u0003gQ1!!\u000e/\u0003\u001d\u0019wN\u001c;fqRLA!!\u000f\u00022\t!!)Z1o\u0003Y\u0011XmZ5ti\u0016\u00148\u000b^8na\u0016sG\r]8j]R\u001cH\u0003BA\u0001\u0003\u007fAq!!\u0003\u000b\u0001\u0004\t\t\u0005E\u0002&\u0003\u0007J1!!\u0012'\u0005U\u0019Fo\\7q\u000b:$\u0007o\\5oiJ+w-[:uef\fQdY8oM&<WO]3DY&,g\u000e^%oE>,h\u000eZ\"iC:tW\r\u001c\u000b\u0005\u0003\u0003\tY\u0005C\u0004\u0002\n-\u0001\r!!\u0014\u0011\t\u00055\u0011qJ\u0005\u0005\u0003#\nyAA\nDQ\u0006tg.\u001a7SK\u001eL7\u000f\u001e:bi&|g.\u0001\u000ed_:4\u0017nZ;sK6+7o]1hK\u000e{gN^3si\u0016\u00148\u000f\u0006\u0003\u0002X\u0005u\u0003c\u0001=\u0002Z%\u0019\u00111L=\u0003\u000f\t{w\u000e\\3b]\"9\u0011q\f\u0007A\u0002\u0005\u0005\u0014!E7fgN\fw-Z\"p]Z,'\u000f^3sgB1\u00111MA5\u0003[j!!!\u001a\u000b\u0007\u0005\u001d\u0004%\u0001\u0003vi&d\u0017\u0002BA6\u0003K\u0012A\u0001T5tiB!\u0011qNA;\u001b\t\t\tHC\u0002\u0002te\u000b\u0011bY8om\u0016\u0014H/\u001a:\n\t\u0005]\u0014\u0011\u000f\u0002\u0011\u001b\u0016\u001c8/Y4f\u0007>tg/\u001a:uKJD3\u0001AA>!\r)\u0013QP\u0005\u0004\u0003\u007f2#\u0001H#oC\ndWmV3c'>\u001c7.\u001a;NKN\u001c\u0018mZ3Ce>\\WM\u001d\u0015\u0004\u0001\u0005\r\u0005\u0003BA\u0018\u0003\u000bKA!a\"\u00022\ti1i\u001c8gS\u001e,(/\u0019;j_:\u0004")
public class WebSocketMessageBrokerConfig
implements WebSocketMessageBrokerConfigurer {
    @Autowired
    private final CiRefsJsonWriter ciRefsJsonWriter;
    @Autowired
    @Qualifier(value="websocketsScheduler")
    private final TaskScheduler taskScheduler;
    @Autowired
    @Qualifier(value="userInterceptor")
    private final ChannelInterceptor userInterceptor;
    private final int inputBufferSize;

    public void configureWebSocketTransport(WebSocketTransportRegistration x$1) {
        super.configureWebSocketTransport(x$1);
    }

    public void configureClientOutboundChannel(ChannelRegistration x$1) {
        super.configureClientOutboundChannel(x$1);
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> x$1) {
        super.addArgumentResolvers(x$1);
    }

    public void addReturnValueHandlers(List<HandlerMethodReturnValueHandler> x$1) {
        super.addReturnValueHandlers(x$1);
    }

    private int inputBufferSize() {
        return this.inputBufferSize;
    }

    public void configureMessageBroker(MessageBrokerRegistry registry) {
        registry.setApplicationDestinationPrefixes(new String[]{"/app"});
        registry.enableSimpleBroker(new String[]{"/topic"}).setTaskScheduler(this.taskScheduler);
    }

    @Bean
    public DefaultHandshakeHandler handshakeHandler() {
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
        policy.setInputBufferSize(this.inputBufferSize());
        long idleTimeout = TimeUnit.MINUTES.toMillis(ServerConfiguration.getInstance().getClientSessionTimeoutMinutes());
        policy.setIdleTimeout(idleTimeout);
        return new DefaultHandshakeHandler((RequestUpgradeStrategy)new JettyRequestUpgradeStrategy(policy));
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{"/ws"}).setAllowedOriginPatterns(new String[]{"*"}).setHandshakeHandler((HandshakeHandler)this.handshakeHandler()).withSockJS();
    }

    public void configureClientInboundChannel(ChannelRegistration registry) {
        registry.interceptors(new ChannelInterceptor[]{this.userInterceptor});
    }

    public boolean configureMessageConverters(List<MessageConverter> messageConverters) {
        messageConverters.add((MessageConverter)new CiIdsMessageConverter(this.ciRefsJsonWriter));
        return true;
    }

    public WebSocketMessageBrokerConfig(@Autowired CiRefsJsonWriter ciRefsJsonWriter, @Autowired @Qualifier(value="websocketsScheduler") TaskScheduler taskScheduler, @Autowired @Qualifier(value="userInterceptor") ChannelInterceptor userInterceptor, @Autowired WebSocketsConfiguration webSocketsConfiguration) {
        this.ciRefsJsonWriter = ciRefsJsonWriter;
        this.taskScheduler = taskScheduler;
        this.userInterceptor = userInterceptor;
        this.inputBufferSize = webSocketsConfiguration.messageBroker().inputBufferSize();
    }
}

