/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.core.rest.api.DeploymentWriter;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.deployment.ChangeSetBuilder;
import com.xebialabs.deployit.deployment.planner.ContainersToEnvironmentContributor;
import com.xebialabs.deployit.deployment.planner.MultiDeltaSpecification;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecificationWithDependencies;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirFactory;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.service.dependency.DependencyService;
import com.xebialabs.deployit.service.deployment.DeploymentService;
import com.xebialabs.deployit.service.deployment.TaskSpecificationService;
import com.xebialabs.xlplatform.utils.Implicits;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.collection.immutable.List;

@Component(value="taskSpecificationService")
public class TaskSpecificationServiceImpl
extends AbstractSecuredResource
implements TaskSpecificationService {
    protected static final Logger logger = LoggerFactory.getLogger(TaskSpecificationServiceImpl.class);
    private final RepositoryService repositoryService;
    private final DeploymentService deploymentService;
    private final DependencyService dependencyService;
    private final WorkDirFactory workDirFactory;

    @Autowired
    public TaskSpecificationServiceImpl(RepositoryService repositoryService, DeploymentService deploymentService, DependencyService dependencyService, WorkDirFactory workDirFactory) {
        this.repositoryService = repositoryService;
        this.deploymentService = deploymentService;
        this.dependencyService = dependencyService;
        this.workDirFactory = workDirFactory;
    }

    public TaskSpecification createDeploymentTask(Deployment deployment, boolean previewMode) {
        switch (deployment.getDeploymentType()) {
            case INITIAL: 
            case UPDATE: {
                return this.createTask(deployment, previewMode);
            }
            case UNDEPLOYMENT: {
                return this.createUndeploymentTask(deployment, previewMode);
            }
        }
        throw new IllegalArgumentException("Unknown deployment type: " + deployment.getDeploymentType());
    }

    private TaskSpecification createTask(Deployment deployment, boolean previewMode) {
        WorkDir workDirForExistingDeployment = this.workDirFactory.newWorkDir("previous");
        logger.trace("Got workdir [{}] for reading existing deployment", (Object)workDirForExistingDeployment);
        try {
            MultiDeltaSpecification deltaSpecification = this.createDeltaSpecification(deployment, this.readExistingDeployedApplication(deployment, workDirForExistingDeployment));
            if (!previewMode) {
                this.repositoryService.checkReferentialIntegrity(ChangeSetBuilder.determineChanges((DeltaSpecificationWithDependencies)deltaSpecification));
            }
            TaskSpecification taskSpecification = this.deploymentService.getTaskFullSpecification(deployment.getId(), deltaSpecification, WorkdirHolder.get(), new WorkDir[]{workDirForExistingDeployment});
            return taskSpecification;
        }
        catch (RuntimeException e) {
            workDirForExistingDeployment.delete();
            WorkdirHolder.get().delete();
            throw e;
        }
        finally {
            if (previewMode) {
                workDirForExistingDeployment.delete();
            }
        }
    }

    private MultiDeltaSpecification createDeltaSpecification(Deployment deployment, Map<String, DeployedApplication> existingDeployedApplications) {
        switch (deployment.getDeploymentType()) {
            case INITIAL: {
                return this.deploymentService.prepareInitialSpecification(deployment, existingDeployedApplications);
            }
            case UPDATE: {
                return this.deploymentService.prepareUpgradeSpecification(deployment, existingDeployedApplications);
            }
        }
        throw new IllegalArgumentException("Deployment " + deployment.getId() + " has invalid type " + deployment.getDeploymentType());
    }

    private TaskSpecification createUndeploymentTask(Deployment deployment, boolean previewMode) {
        DeployedApplication deployedApplication = (DeployedApplication)deployment.getDeployedApplication();
        this.checkPermission(DeployitPermissions.UNDEPLOY, deployedApplication.getEnvironment().getId());
        if (deployedApplication.isUndeployDependencies() && deployment.getGroupedRequiredDeployments().isEmpty()) {
            this.applyUnDeploymentGroups(deployedApplication, deployment);
        }
        MultiDeltaSpecification deltaSpecification = this.deploymentService.prepareUndeploymentWithDependencies(deployment);
        if (!previewMode) {
            ChangeSet changeSet = ChangeSetBuilder.determineChanges((DeltaSpecificationWithDependencies)deltaSpecification);
            new ContainersToEnvironmentContributor().contribute((DeltaSpecificationWithDependencies)deltaSpecification, changeSet, null);
            this.repositoryService.checkReferentialIntegrity(changeSet);
        }
        return this.deploymentService.getTaskFullSpecification(deployment.getId(), deltaSpecification, WorkdirHolder.get(), new WorkDir[0]);
    }

    private Map<String, DeployedApplication> readExistingDeployedApplication(Deployment deployment, WorkDir workDir) {
        return Maps.uniqueIndex((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)Iterables.concat(Collections.singleton(deployment), (Iterable)deployment.getRequiredDeployments()), input -> input.isOfType(Deployment.DeploymentType.UPDATE)), input -> (DeployedApplication)this.repositoryService.read(input.getDeployedApplication().getId(), workDir)), BaseConfigurationItem::getId);
    }

    public void applyUnDeploymentGroups(DeployedApplication deployedApplication, Deployment unDeployment) {
        if (ServerConfiguration.getInstance().isServerResolveApplicationDependencies()) {
            java.util.List dependenciesToDelete = Implicits.listOfListToJavaListOfList((List)this.dependencyService.findDependencyGroupsToDeleteAndValidate(deployedApplication));
            java.util.List unDeploymentGroups = dependenciesToDelete.stream().map(group -> group.stream().map(app -> DeploymentWriter.createDeployment(app, Deployment.DeploymentType.UNDEPLOYMENT)).collect(Collectors.toList())).collect(Collectors.toList());
            unDeployment.setGroupedRequiredDeployments(unDeploymentGroups);
        }
    }
}

