/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import akka.actor.ActorRef;
import akka.actor.AddressFromURIString$;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import com.xebialabs.deployit.converter.HoconDurationConverter$;
import com.xebialabs.deployit.core.api.WorkersService;
import com.xebialabs.deployit.core.api.dto.WorkerInfo;
import com.xebialabs.deployit.core.rest.api.WorkerState$;
import com.xebialabs.deployit.core.rest.api.WorkersSorting$;
import com.xebialabs.deployit.core.rest.api.support.PaginationSupport$;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.distribution.TaskExecutionWorkerRepository;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.dto.Worker;
import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine;
import com.xebialabs.deployit.engine.tasker.distribution.WorkerManager;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import scala.Enumeration;
import scala.Function$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@Controller
@ScalaSignature(bytes="\u0006\u0005\u0005}g\u0001B\t\u0013\u0001}A\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\t#\u0002\u0011\t\u0011)A\u0005%\"AA\f\u0001B\u0001B\u0003%Q\f\u0003\u0005e\u0001\t\u0005\t\u0015!\u0003f\u0011\u0015A\b\u0001\"\u0001z\u0011%\tY\u0001\u0001b\u0001\n\u0017\ti\u0001\u0003\u0005\u0002\u001c\u0001\u0001\u000b\u0011BA\b\u0011%\ti\u0002\u0001b\u0001\n\u0003\ty\u0002\u0003\u0005\u00026\u0001\u0001\u000b\u0011BA\u0011\u0011\u001d\ty\u0005\u0001C!\u0003#Bq!!\u001c\u0001\t\u0003\ny\u0007C\u0004\u0002\u0002\u0002!I!a!\t\u000f\u0005=\u0005\u0001\"\u0003\u0002\u0012\"9\u0011Q\u0014\u0001\u0005B\u0005}\u0005bBAR\u0001\u0011\u0005\u0013Q\u0015\u0005\b\u0003O\u0003A\u0011IAU\u0005=9vN]6feN\u0014Vm]8ve\u000e,'BA\n\u0015\u0003\r\t\u0007/\u001b\u0006\u0003+Y\tAA]3ti*\u0011q\u0003G\u0001\u0005G>\u0014XM\u0003\u0002\u001a5\u0005AA-\u001a9m_fLGO\u0003\u0002\u001c9\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002;\u0005\u00191m\\7\u0004\u0001M!\u0001\u0001\t\u0014,!\t\tC%D\u0001#\u0015\t\u0019C#A\u0004tK\u000e,(/\u001a3\n\u0005\u0015\u0012#aF!cgR\u0014\u0018m\u0019;TK\u000e,(/\u001a3SKN|WO]2f!\t9\u0013&D\u0001)\u0015\t\u0019b#\u0003\u0002+Q\tqqk\u001c:lKJ\u001c8+\u001a:wS\u000e,\u0007C\u0001\u00172\u001b\u0005i#B\u0001\u00180\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005\u0001\u0014\u0001C4sSjTH.\u001a3\n\u0005Ij#a\u0002'pO\u001eLgnZ\u0001\u000eo>\u00148.\u001a:NC:\fw-\u001a:\u0011\u0005URT\"\u0001\u001c\u000b\u0005]B\u0014!B1di>\u0014(\"A\u001d\u0002\t\u0005\\7.Y\u0005\u0003wY\u0012\u0001\"Q2u_J\u0014VM\u001a\u0015\u0005\u0003uZE\n\u0005\u0002?\u00136\tqH\u0003\u0002A\u0003\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005\t\u001b\u0015a\u00024bGR|'/\u001f\u0006\u0003\t\u0016\u000bQAY3b]NT!AR$\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011\u0001S\u0001\u0004_J<\u0017B\u0001&@\u0005%\tV/\u00197jM&,'/A\u0003wC2,X-I\u00014Q\t\ta\n\u0005\u0002?\u001f&\u0011\u0001k\u0010\u0002\n\u0003V$xn^5sK\u0012\f\u0001c^8sW\u0016\u0014(+\u001a9pg&$xN]=\u0011\u0005MKV\"\u0001+\u000b\u0005U3\u0016\u0001\u00043jgR\u0014\u0018NY;uS>t'BA\nX\u0015\tA\u0006$\u0001\u0004f]\u001eLg.Z\u0005\u00035R\u0013Q\u0004V1tW\u0016CXmY;uS>twk\u001c:lKJ\u0014V\r]8tSR|'/\u001f\u0015\u0003\u00059\u000b1\u0003^1tW\u0016CXmY;uS>tWI\\4j]\u0016\u0004\"AX1\u000e\u0003}S!\u0001Y,\u0002\rQ\f7o[3s\u0013\t\u0011wLA\nUCN\\W\t_3dkRLwN\\#oO&tW\r\u000b\u0002\u0004\u001d\u0006Q\u0011m]6US6,w.\u001e;\u0011\u0005\u0019|gBA4n!\tA7.D\u0001j\u0015\tQg$\u0001\u0004=e>|GO\u0010\u0006\u0002Y\u0006)1oY1mC&\u0011an[\u0001\u0007!J,G-\u001a4\n\u0005A\f(AB*ue&twM\u0003\u0002oW\"\"Aa]&w!\tqD/\u0003\u0002v\u007f\t)a+\u00197vK\u0006\nq/\u0001\u0012%wbdg\u0006^1tW\u0016\u0014h&Y:l)&lWm\\;uuE\u0002\u0004e]3d_:$7/`\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000fidx0a\u0001\u0002\bA\u00111\u0010A\u0007\u0002%!)1'\u0002a\u0001i!\"A0P&MQ\tah\nC\u0003R\u000b\u0001\u0007!\u000b\u000b\u0002\u0000\u001d\")A,\u0002a\u0001;\"\u001a\u00111\u0001(\t\u000b\u0011,\u0001\u0019A3)\u000b\u0005\u001d1o\u0013<\u0002\u000fQLW.Z8viV\u0011\u0011q\u0002\t\u0005\u0003#\t9\"\u0004\u0002\u0002\u0014)\u0019\u0011Q\u0003\u001d\u0002\tU$\u0018\u000e\\\u0005\u0005\u00033\t\u0019BA\u0004US6,w.\u001e;\u0002\u0011QLW.Z8vi\u0002\nA\u0002\u001b;uaJ+7\u000f]8og\u0016,\"!!\t\u0011\t\u0005\r\u0012\u0011G\u0007\u0003\u0003KQA!a\n\u0002*\u0005\u00191\u000f]5\u000b\t\u0005-\u0012QF\u0001\te\u0016\u001cH/Z1ts*\u0019\u0011qF$\u0002\u000b)\u0014wn]:\n\t\u0005M\u0012Q\u0005\u0002\r\u0011R$\bOU3ta>t7/Z\u0001\u000eQR$\bOU3ta>t7/\u001a\u0011)\u0007%\tI\u0004\u0005\u0003\u0002<\u0005-SBAA\u001f\u0015\r9\u0012q\b\u0006\u0005\u0003\u0003\n\u0019%\u0001\u0002sg*!\u0011QIA$\u0003\t98O\u0003\u0002\u0002J\u0005)!.\u0019<bq&!\u0011QJA\u001f\u0005\u001d\u0019uN\u001c;fqR\fqb\u001d5vi\u0012|wO\\,pe.,'o\u001d\u000b\u0005\u0003'\nY\u0006\u0005\u0003\u0002V\u0005]S\"A6\n\u0007\u0005e3N\u0001\u0003V]&$\bbBA/\u0015\u0001\u0007\u0011qL\u0001\bo>\u00148.\u001a:t!\u0015\t\t'!\u001bf\u001b\t\t\u0019G\u0003\u0003\u0002\u0016\u0005\u0015$BAA4\u0003\u0011Q\u0017M^1\n\t\u0005-\u00141\r\u0002\u0005\u0019&\u001cH/\u0001\btQV$Hm\\<o/>\u00148.\u001a:\u0015\t\u0005M\u0013\u0011\u000f\u0005\b\u0003gZ\u0001\u0019AA;\u0003!9xN]6fe&#\u0007\u0003BA<\u0003{j!!!\u001f\u000b\t\u0005m\u0014QM\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u0000\u0005e$aB%oi\u0016<WM]\u0001\u000eSNdunY1m/>\u00148.\u001a:\u0015\t\u0005\u0015\u00151\u0012\t\u0005\u0003+\n9)C\u0002\u0002\n.\u0014qAQ8pY\u0016\fg\u000e\u0003\u0004\u0002\u000e2\u0001\r!Z\u0001\bC\u0012$'/Z:t\u0003U!\bN]8x\u0019>\u001c\u0017\r\\,pe.,'/\u0012:s_J$B!a%\u0002\u001aB!\u0011QKAK\u0013\r\t9j\u001b\u0002\b\u001d>$\b.\u001b8h\u0011\u0019\tY*\u0004a\u0001K\u0006\t1/\u0001\u0007sK6|g/Z,pe.,'\u000f\u0006\u0003\u0002T\u0005\u0005\u0006bBA:\u001d\u0001\u0007\u0011QO\u0001\u0015e\u0016\u0014XmZ5ti\u0016\u0014x\t[8tiR\u000b7o[:\u0015\u0005\u0005}\u0013a\u00037jgR<vN]6feN$b!a+\u0002:\u0006\u001d\u0007CBA1\u0003S\ni\u000b\u0005\u0003\u00020\u0006UVBAAY\u0015\r\t\u0019\fK\u0001\u0004IR|\u0017\u0002BA\\\u0003c\u0013!bV8sW\u0016\u0014\u0018J\u001c4p\u0011\u001d\tY\f\u0005a\u0001\u0003{\u000ba\u0001]1hS:<\u0007\u0003BA`\u0003\u0007l!!!1\u000b\u0007\u0005Mf+\u0003\u0003\u0002F\u0006\u0005'A\u0002)bO&tw\rC\u0004\u0002JB\u0001\r!a3\u0002\u000b=\u0014H-\u001a:\u0011\t\u0005}\u0016QZ\u0005\u0005\u0003\u001f\f\tM\u0001\u0005Pe\u0012,'/\u001b8hQ\r\u0001\u00111\u001b\t\u0005\u0003+\fY.\u0004\u0002\u0002X*\u0019\u0011\u0011\\#\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002^\u0006]'AC\"p]R\u0014x\u000e\u001c7fe\u0002")
public class WorkersResource
extends AbstractSecuredResource
implements WorkersService,
Logging {
    @Autowired
    @Qualifier(value="workerManager")
    private final ActorRef workerManager;
    @Autowired
    private final TaskExecutionWorkerRepository workerRepository;
    @Autowired
    private final TaskExecutionEngine taskExecutionEngine;
    private final Timeout timeout;
    @Context
    private final HttpResponse httpResponse;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        WorkersResource workersResource = this;
        synchronized (workersResource) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private Timeout timeout() {
        return this.timeout;
    }

    public HttpResponse httpResponse() {
        return this.httpResponse;
    }

    public void shutdownWorkers(java.util.List<String> workers) {
        this.checkPermission(PlatformPermissions.ADMIN);
        if (workers.isEmpty()) {
            this.logger().info((Function0 & Serializable)() -> "Shutting down all workers.");
        } else {
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(23).append("Shutting down workers ").append(workers).append(".").toString());
        }
        CollectionConverters$.MODULE$.ListHasAsScala(workers).asScala().find((Function1 & Serializable)address -> BoxesRunTime.boxToBoolean((boolean)this.isLocalWorker(address))).foreach((Function1 & Serializable)s -> this.throwLocalWorkerError((String)s));
        this.workerRepository.listWorkers().map((Function1 & Serializable)x$1 -> (Worker)x$1._1()).foreach((Function1 & Serializable)worker -> {
            WorkersResource.$anonfun$shutdownWorkers$6(this, workers, worker);
            return BoxedUnit.UNIT;
        });
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(this.workerManager);
        WorkerManager.messages$.ShutdownWorker x$12 = new WorkerManager.messages$.ShutdownWorker(CollectionConverters$.MODULE$.ListHasAsScala(workers).asScala().toList(), true);
        Timeout x$2 = this.timeout();
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$12);
        WorkerManager.messages$.WorkerShutdownStarted response = (WorkerManager.messages$.WorkerShutdownStarted)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$12, x$2, x$3), (Duration)this.timeout().duration());
        if (!workers.isEmpty()) {
            List shutdownWorkers = response.workers();
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(18).append("Workers ").append(shutdownWorkers.mkString("[", ", ", "]")).append(" shutdown.").toString());
            ArrayList<String> notFound = new ArrayList<String>(workers);
            notFound.removeAll(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)shutdownWorkers).asJava());
            if (!notFound.isEmpty()) {
                throw new NotFoundException(new StringBuilder(40).append("Workers ").append(CollectionConverters$.MODULE$.ListHasAsScala(notFound).asScala().mkString("[", ", ", "]")).append(" not found. (Workers ").append(shutdownWorkers.mkString("[", ", ", "]")).append(" shutdown.)").toString());
            }
        }
    }

    public void shutdownWorker(Integer workerId) {
        this.checkPermission(PlatformPermissions.ADMIN);
        this.workerRepository.getWorker(workerId).orElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(25).append("Worker for id ").append(workerId).append(" not found.").toString());
        }).foreach((Function1 & Serializable)worker -> {
            WorkersResource.$anonfun$shutdownWorker$2(this, worker);
            return BoxedUnit.UNIT;
        });
    }

    private boolean isLocalWorker(String address) {
        return AddressFromURIString$.MODULE$.apply(address).hasLocalScope();
    }

    private Nothing$ throwLocalWorkerError(String s) {
        throw new IllegalArgumentException(new StringBuilder(35).append("Local worker (").append(s).append(") cannot be shutdown.").toString());
    }

    public void removeWorker(Integer workerId) {
        this.checkPermission(PlatformPermissions.ADMIN);
        this.workerRepository.getWorker(workerId).orElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(25).append("Worker for id ").append(workerId).append(" not found.").toString());
        }).foreach((Function1 & Serializable)worker -> {
            WorkersResource.$anonfun$removeWorker$2(this, workerId, worker);
            return BoxedUnit.UNIT;
        });
    }

    public java.util.List<String> reregisterGhostTasks() {
        this.checkPermission(PlatformPermissions.ADMIN);
        return this.taskExecutionEngine.reregisterGhostTasks();
    }

    public java.util.List<WorkerInfo> listWorkers(Paging paging, com.xebialabs.deployit.engine.api.dto.Ordering order) {
        java.util.List list;
        this.checkPermission(PlatformPermissions.ADMIN);
        Timeout timeout = new Timeout(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds());
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(this.workerManager);
        WorkerManager.messages$.FetchWorkers x$1 = new WorkerManager.messages$.FetchWorkers();
        Timeout x$22 = timeout;
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        WorkerManager.messages.WorkersFetched response = (WorkerManager.messages.WorkersFetched)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$22, x$3), (Duration)timeout.duration());
        List workers = this.workerRepository.listWorkers().map(Function$.MODULE$.tupled((Function3 & Serializable)(w, deploymentTasks, controlTasks) -> new WorkerInfo(Predef$.MODULE$.Integer2int(w.id()), w.name(), w.address(), WorkersResource.calculateState$1(w, response.healthy(), response.incompatible(), response.draining()).toString(), Predef$.MODULE$.Integer2int(deploymentTasks), Predef$.MODULE$.Integer2int(controlTasks))));
        if ((paging == null || paging.resultsPerPage() == -1) && order == null) {
            list = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)workers.sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.getId()), (Ordering)Ordering.Int$.MODULE$)).asJava().stream().collect(Collectors.toList());
        } else {
            PaginationSupport$.MODULE$.addTotalCountHeader((long)workers.size(), this.httpResponse());
            int from = (paging.page() - 1) * paging.resultsPerPage();
            int to = from + paging.resultsPerPage() <= CollectionConverters$.MODULE$.SeqHasAsJava((Seq)workers).asJava().size() ? from + paging.resultsPerPage() : CollectionConverters$.MODULE$.SeqHasAsJava((Seq)workers).asJava().size();
            list = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)WorkersSorting$.MODULE$.sort((List<WorkerInfo>)workers, order).slice(from, to)).asJava();
        }
        return list;
    }

    public static final /* synthetic */ void $anonfun$shutdownWorkers$6(WorkersResource $this, java.util.List workers$1, Worker worker) {
        block0: {
            if (!workers$1.isEmpty() && !workers$1.contains(worker.address())) break block0;
            $this.workerRepository.removeTasks(worker.id());
        }
    }

    public static final /* synthetic */ void $anonfun$shutdownWorker$2(WorkersResource $this, Worker worker) {
        String address = worker.address();
        if ($this.isLocalWorker(address)) {
            throw $this.throwLocalWorkerError(address);
        }
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask($this.workerManager);
        WorkerManager.messages$.ShutdownWorker x$1 = new WorkerManager.messages$.ShutdownWorker((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{address})), false);
        Timeout x$2 = $this.timeout();
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        WorkerManager.messages$.WorkerShutdownStarted response = (WorkerManager.messages$.WorkerShutdownStarted)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$2, x$3), (Duration)$this.timeout().duration());
        List shutdownWorkers = response.workers();
        $this.logger().info((Function0 & Serializable)() -> new StringBuilder(18).append("Workers ").append(shutdownWorkers.mkString("[", ", ", "]")).append(" shutdown.").toString());
        if (!response.workers().contains((Object)address)) {
            throw new NotFoundException(new StringBuilder(18).append("Worker ").append(address).append(" not found.").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$removeWorker$2(WorkersResource $this, Integer workerId$2, Worker worker) {
        ActorRef x$3;
        Timeout x$2;
        WorkerManager.messages$.FetchWorkers x$1;
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask($this.workerManager);
        WorkerManager.messages.WorkersFetched response = (WorkerManager.messages.WorkersFetched)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)(x$1 = new WorkerManager.messages$.FetchWorkers()), x$2 = $this.timeout(), x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1)), (Duration)$this.timeout().duration());
        List active = (List)response.draining().$plus$plus((IterableOnce)response.healthy());
        if (active.contains((Object)worker.address())) {
            throw new IllegalArgumentException(new StringBuilder(50).append("Worker for id ").append(workerId$2).append(" is still active, cannot be removed.").toString());
        }
        $this.workerRepository.removeTasks(workerId$2);
        $this.workerRepository.removeWorker(workerId$2);
    }

    private static final Enumeration.Value calculateState$1(Worker w, List healthy, List incompatible, List draining) {
        return healthy.contains((Object)w.address()) ? WorkerState$.MODULE$.CONNECTED() : (incompatible.contains((Object)w.address()) ? WorkerState$.MODULE$.INCOMPATIBLE() : (draining.contains((Object)w.address()) ? WorkerState$.MODULE$.DRAINING() : WorkerState$.MODULE$.DISCONNECTED()));
    }

    public WorkersResource(@Autowired @Qualifier(value="workerManager") ActorRef workerManager, @Autowired TaskExecutionWorkerRepository workerRepository, @Autowired TaskExecutionEngine taskExecutionEngine, @Value(value="${xl.tasker.askTimeout:10 seconds}") String askTimeout) {
        this.workerManager = workerManager;
        this.workerRepository = workerRepository;
        this.taskExecutionEngine = taskExecutionEngine;
        Logging.$init$((Logging)this);
        this.timeout = new Timeout(HoconDurationConverter$.MODULE$.convert(askTimeout));
        this.httpResponse = null;
    }
}

