/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.core.api.dto.ReportLine;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.converters.ControlTaskReportLineConverter$;
import com.xebialabs.deployit.core.converters.ControlTaskReportLineField$;
import com.xebialabs.deployit.core.converters.DeploymentReportLineField$;
import com.xebialabs.deployit.core.converters.DeploymentTaskReportLineConverter$;
import com.xebialabs.deployit.core.rest.api.DownloadResource;
import com.xebialabs.deployit.core.rest.api.SearchParametersFactory;
import com.xebialabs.deployit.core.rest.api.reports.ReportUtils;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.core.service.PaginationService;
import com.xebialabs.deployit.core.service.ReportGenerator;
import com.xebialabs.deployit.core.util.TaskFilterUtils$;
import com.xebialabs.deployit.engine.api.ReportService;
import com.xebialabs.deployit.engine.api.dto.AuditPreviewRow;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.ControlTaskReportLine;
import com.xebialabs.deployit.engine.api.dto.DeploymentTaskReportLine;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.execution.FetchMode;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.report.audit.AuditPreviewReport;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.sql.CiRepository;
import com.xebialabs.deployit.repository.sql.ConfigurationItemDataWithInternalId;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.archive.TaskArchive;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.stream.Stream;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.joda.time.ReadableInstant;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StrictOptimizedSeqOps;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Controller
@Autowired
@ScalaSignature(bytes="\u0006\u0005\r5e\u0001\u0002\u000e\u001c\u0001!B\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\"A\u0011\n\u0001B\u0001B\u0003%!\n\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003T\u0011!Y\u0006A!A!\u0002\u0013a\u0006\"\u00021\u0001\t\u0003\t\u0007\"\u00035\u0001\u0001\u0004\u0005\r\u0011\"\u0003j\u0011%1\b\u00011AA\u0002\u0013%q\u000f\u0003\u0006\u0002\u0002\u0001\u0001\r\u0011!Q!\n)Dq!a\u0007\u0001\t\u0003\ti\u0002C\u0004\u0002\"\u0001!I!a\t\t\u000f\u0005E\u0003\u0001\"\u0003\u0002T!9\u0011q\u0013\u0001\u0005\n\u0005e\u0005b\u0002B\b\u0001\u0011\u0005#\u0011\u0003\u0005\b\u0005W\u0001A\u0011\tB\u0017\u0011\u001d\u0011)\t\u0001C\u0005\u0005\u000fCqAa-\u0001\t\u0003\u0012)\fC\u0004\u0003N\u0002!\tEa4\t\u000f\t\u001d\b\u0001\"\u0003\u0003j\"91\u0011\u0006\u0001\u0005\n\r-\u0002bBB\u001d\u0001\u0011\u000531\b\u0005\b\u0007{\u0001A\u0011IB\u001e\u0011\u001d\u0019y\u0004\u0001C!\u0007\u0003Bqaa\u0010\u0001\t\u0003\u001a9\u0005C\u0004\u0004R\u0001!\tea\u0015\u0003#I+\u0007o\u001c:u'\u0016\u0014h/[2f\u00136\u0004HN\u0003\u0002\u001d;\u0005\u0019\u0011\r]5\u000b\u0005yy\u0012\u0001\u0002:fgRT!\u0001I\u0011\u0002\t\r|'/\u001a\u0006\u0003E\r\n\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003I\u0015\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\u0019\n1aY8n\u0007\u0001\u0019B\u0001A\u00150mA\u0011!&L\u0007\u0002W)\u0011A&H\u0001\bg\u0016\u001cWO]3e\u0013\tq3FA\fBEN$(/Y2u'\u0016\u001cWO]3e%\u0016\u001cx.\u001e:dKB\u0011\u0001\u0007N\u0007\u0002c)\u0011AD\r\u0006\u0003g\u0005\na!\u001a8hS:,\u0017BA\u001b2\u00055\u0011V\r]8siN+'O^5dKB\u0011q\u0007P\u0007\u0002q)\u0011\u0011HO\u0001\u0006g24GG\u001b\u0006\u0002w\u0005AqM]5{u2,G-\u0003\u0002>q\t9Aj\\4hS:<\u0017a\u0004:fa>\u0014HoR3oKJ\fGo\u001c:\u0011\u0005\u0001\u001bU\"A!\u000b\u0005\t{\u0012aB:feZL7-Z\u0005\u0003\t\u0006\u0013qBU3q_J$x)\u001a8fe\u0006$xN]\u0001\u0012a\u0006<\u0017N\\1uS>t7+\u001a:wS\u000e,\u0007C\u0001!H\u0013\tA\u0015IA\tQC\u001eLg.\u0019;j_:\u001cVM\u001d<jG\u0016\fAbY5SKB|7/\u001b;pef\u0004\"a\u0013)\u000e\u00031S!!\u0014(\u0002\u0007M\fHN\u0003\u0002PC\u0005Q!/\u001a9pg&$xN]=\n\u0005Ec%\u0001D\"j%\u0016\u0004xn]5u_JL\u0018a\u0003;bg.\f%o\u00195jm\u0016\u0004\"\u0001V-\u000e\u0003US!AV,\u0002\u000f\u0005\u00148\r[5wK*\u0011\u0001,I\u0001\u0005i\u0006\u001c8.\u0003\u0002[+\nYA+Y:l\u0003J\u001c\u0007.\u001b<f\u0003A!wn\u001e8m_\u0006$'+Z:pkJ\u001cW\r\u0005\u0002^=6\t1$\u0003\u0002`7\t\u0001Bi\\<oY>\fGMU3t_V\u00148-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\t\u001cG-\u001a4h!\ti\u0006\u0001C\u0003?\r\u0001\u0007q\bC\u0003F\r\u0001\u0007a\tC\u0003J\r\u0001\u0007!\nC\u0003S\r\u0001\u00071\u000bC\u0003\\\r\u0001\u0007A,\u0001\u0005sKN\u0004xN\\:f+\u0005Q\u0007CA6u\u001b\u0005a'BA7o\u0003\r\u0019\b/\u001b\u0006\u0003_B\f\u0001B]3ti\u0016\f7/\u001f\u0006\u0003cJ\fQA\u001b2pgNT\u0011a]\u0001\u0004_J<\u0017BA;m\u00051AE\u000f\u001e9SKN\u0004xN\\:f\u00031\u0011Xm\u001d9p]N,w\fJ3r)\tAh\u0010\u0005\u0002zy6\t!PC\u0001|\u0003\u0015\u00198-\u00197b\u0013\ti(P\u0001\u0003V]&$\bbB@\t\u0003\u0003\u0005\rA[\u0001\u0004q\u0012\n\u0014!\u0003:fgB|gn]3!Q\rI\u0011Q\u0001\t\u0005\u0003\u000f\t9\"\u0004\u0002\u0002\n)\u0019\u0001%a\u0003\u000b\t\u00055\u0011qB\u0001\u0003eNTA!!\u0005\u0002\u0014\u0005\u0011qo\u001d\u0006\u0003\u0003+\tQA[1wCbLA!!\u0007\u0002\n\t91i\u001c8uKb$\u0018aC:fiJ+7\u000f]8og\u0016$2\u0001_A\u0010\u0011\u0015A'\u00021\u0001k\u00031\u0019X\r^\"j\r&dG/\u001a:t)\u0015A\u0018QEA\u0019\u0011\u001d\t9c\u0003a\u0001\u0003S\t\u0001c]3be\u000eD\u0007+\u0019:b[\u0016$XM]:\u0011\t\u0005-\u0012QF\u0007\u0002/&\u0019\u0011qF,\u00039\u0005\u00138\r[5wK\u0012$\u0016m]6TK\u0006\u00148\r\u001b)be\u0006lW\r^3sg\"9\u00111G\u0006A\u0002\u0005U\u0012\u0001F2p]\u001aLw-\u001e:bi&|g.\u0013;f[&#7\u000f\u0005\u0004\u00028\u0005\u0005\u0013QI\u0007\u0003\u0003sQA!a\u000f\u0002>\u0005!Q\u000f^5m\u0015\t\ty$\u0001\u0003kCZ\f\u0017\u0002BA\"\u0003s\u0011A\u0001T5tiB!\u0011qIA'\u001b\t\tIEC\u0002\u0002LE\n1\u0001\u001a;p\u0013\u0011\ty%!\u0013\u0003'\r{gNZ5hkJ\fG/[8o\u0013R,W.\u00133\u0002\u0019M$(/Z1n%\u0016\u0004xN\u001d;\u0016\t\u0005U\u0013q\r\u000b\t\u0003/\nI(!#\u0002\u0014B1\u0011\u0011LA0\u0003Gj!!a\u0017\u000b\t\u0005u\u0013\u0011H\u0001\u0007gR\u0014X-Y7\n\t\u0005\u0005\u00141\f\u0002\u0007'R\u0014X-Y7\u0011\t\u0005\u0015\u0014q\r\u0007\u0001\t\u001d\tI\u0007\u0004b\u0001\u0003W\u0012\u0011\u0001V\t\u0005\u0003[\n\u0019\bE\u0002z\u0003_J1!!\u001d{\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!_A;\u0013\r\t9H\u001f\u0002\u0004\u0003:L\bbBA>\u0019\u0001\u0007\u0011QP\u0001\fa\u0006<\u0017N\\4NCf\u0014W\rE\u0003z\u0003\u007f\n\u0019)C\u0002\u0002\u0002j\u0014aa\u00149uS>t\u0007\u0003BA$\u0003\u000bKA!a\"\u0002J\t1\u0001+Y4j]\u001eDq!a#\r\u0001\u0004\ti)A\u0006ck&dG\rU1sC6\u001c\bcB=\u0002\u0010\u0006\r\u0015\u0011F\u0005\u0004\u0003#S(!\u0003$v]\u000e$\u0018n\u001c82\u0011\u001d\ti\u0006\u0004a\u0001\u0003+\u0003r!_AH\u0003S\t9&\u0001\u000etiJ,\u0017-\u001c#fa2|\u00170\\3oiR\u000b7o\u001b*fa>\u0014H\u000f\u0006\u000e\u0002\u001c\u0006\r\u00161WA\\\u0003w\u000b9-a9\u0002h\u0006-\u00181`A\u0000\u0005\u0013\u0011i\u0001\u0005\u0004\u0002Z\u0005}\u0013Q\u0014\t\u0005\u0003\u000f\ny*\u0003\u0003\u0002\"\u0006%#\u0001\u0007#fa2|\u00170\\3oiR\u000b7o\u001b*fa>\u0014H\u000fT5oK\"9\u0011QU\u0007A\u0002\u0005\u001d\u0016!\u00022fO&t\u0007\u0003BAU\u0003_k!!a+\u000b\u0007=\fiK\u0003\u0002\u001d?%!\u0011\u0011WAV\u0005\u0011!\u0015\r^3\t\u000f\u0005UV\u00021\u0001\u0002(\u0006\u0019QM\u001c3\t\u000f\u0005eV\u00021\u0001\u0002~\u00051\u0001/Y4j]\u001eDq!!0\u000e\u0001\u0004\ty,A\u0003pe\u0012,'\u000f\u0005\u0004\u00028\u0005\u0005\u0013\u0011\u0019\t\u0005\u0003\u000f\n\u0019-\u0003\u0003\u0002F\u0006%#\u0001C(sI\u0016\u0014\u0018N\\4\t\u000f\u0005%W\u00021\u0001\u0002L\u0006)Qo]3sgB1\u0011qGA!\u0003\u001b\u0004B!a4\u0002^:!\u0011\u0011[Am!\r\t\u0019N_\u0007\u0003\u0003+T1!a6(\u0003\u0019a$o\\8u}%\u0019\u00111\u001c>\u0002\rA\u0013X\rZ3g\u0013\u0011\ty.!9\u0003\rM#(/\u001b8h\u0015\r\tYN\u001f\u0005\b\u0003Kl\u0001\u0019AAf\u0003)!\u0018m]6Ti\u0006$Xm\u001d\u0005\b\u0003Sl\u0001\u0019AAf\u0003%!\u0018m]6UsB,7\u000fC\u0004\u0002n6\u0001\r!a<\u0002\u0013\u0019,Go\u00195N_\u0012,\u0007\u0003BAy\u0003ol!!a=\u000b\u0007\u0005U\u0018'A\u0005fq\u0016\u001cW\u000f^5p]&!\u0011\u0011`Az\u0005%1U\r^2i\u001b>$W\rC\u0004\u0002~6\u0001\r!!4\u0002\rQ\f7o[%e\u0011\u001d\u0011\t!\u0004a\u0001\u0005\u0007\tab\u001c8msN+8mY3tg\u001a,H\u000eE\u0002z\u0005\u000bI1Aa\u0002{\u0005\u001d\u0011un\u001c7fC:DqAa\u0003\u000e\u0001\u0004\ti-\u0001\u0006x_J\\WM\u001d(b[\u0016Dq!a\r\u000e\u0001\u0004\t)$A\u0007hKR$\u0016m]6SKB|'\u000f\u001e\u000b\u001b\u00037\u0013\u0019B!\u0006\u0003\u0018\te!1\u0004B\u000f\u0005?\u0011\tCa\t\u0003&\t\u001d\"\u0011\u0006\u0005\b\u0003Ks\u0001\u0019AAT\u0011\u001d\t)L\u0004a\u0001\u0003OCq!!/\u000f\u0001\u0004\t\u0019\tC\u0004\u0002>:\u0001\r!a0\t\u000f\u0005%g\u00021\u0001\u0002L\"9\u0011Q\u001d\bA\u0002\u0005-\u0007bBAu\u001d\u0001\u0007\u00111\u001a\u0005\b\u0003[t\u0001\u0019AAx\u0011\u001d\tiP\u0004a\u0001\u0003\u001bDqA!\u0001\u000f\u0001\u0004\u0011\u0019\u0001C\u0004\u0003\f9\u0001\r!!4\t\u000f\u0005Mb\u00021\u0001\u00026\u0005\u0011Bm\\<oY>\fG\rV1tWJ+\u0007o\u001c:u)Y\tiMa\f\u00032\tM\"Q\u0007B\u001c\u0005s\u0011YD!\u0010\u0003@\t\u0005\u0003bBAS\u001f\u0001\u0007\u0011q\u0015\u0005\b\u0003k{\u0001\u0019AAT\u0011\u001d\til\u0004a\u0001\u0003\u007fCq!!3\u0010\u0001\u0004\tY\rC\u0004\u0002f>\u0001\r!a3\t\u000f\u0005%x\u00021\u0001\u0002L\"9\u0011Q`\bA\u0002\u00055\u0007b\u0002B\u0001\u001f\u0001\u0007!1\u0001\u0005\b\u0005\u0017y\u0001\u0019AAg\u0011\u001d\t\u0019d\u0004a\u0001\u0003kA3b\u0004B#\u00053\u0012YFa\u0018\u0003bA!!q\tB+\u001b\t\u0011IE\u0003\u0003\u0003L\t5\u0013AC1o]>$\u0018\r^5p]*!!q\nB)\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0007\tM#/A\btaJLgn\u001a4sC6,wo\u001c:l\u0013\u0011\u00119F!\u0013\u0003\u001bQ\u0013\u0018M\\:bGRLwN\\1m\u0003\u00151\u0018\r\\;fC\t\u0011i&A\u000esKB|'\u000f^5oOR\u0013\u0018M\\:bGRLwN\\'b]\u0006<WM]\u0001\te\u0016\fGm\u00148msf\t\u0011\u0001K\u0006\u0010\u0005K\u0012yG!\u001d\u0003v\t]\u0004\u0003\u0002B4\u0005Wj!A!\u001b\u000b\u0005=l\u0012\u0002\u0002B7\u0005S\u0012qaV8sW\u0012L'/\u0001\u0004qe\u00164\u0017\u000e_\u0011\u0003\u0005g\n\u0001\u0002Z8x]2|\u0017\rZ\u0001\u0006G2,\u0017M\u001c\u0013\u0003\u0005sJAAa\u001f\u0003~\u00051\u0011\tT,B3NSAAa \u0003\u0002\u0006)1\t\\3b]*!!1\u0011B5\u0003\u001d9vN]6eSJ\fqc\u001d;sK\u0006l7i\u001c8ue>dG+Y:l%\u0016\u0004xN\u001d;\u00151\t%%\u0011\u0013BJ\u0005+\u0013IJ!(\u0003 \n\u0005&1\u0015BS\u0005O\u0013I\u000b\u0005\u0004\u0002Z\u0005}#1\u0012\t\u0005\u0003\u000f\u0012i)\u0003\u0003\u0003\u0010\u0006%#!F\"p]R\u0014x\u000e\u001c+bg.\u0014V\r]8si2Kg.\u001a\u0005\b\u0003K\u0003\u0002\u0019AAT\u0011\u001d\t)\f\u0005a\u0001\u0003OCqAa&\u0011\u0001\u0004\tY-\u0001\u0004ti\u0006$Xm\u001d\u0005\b\u00057\u0003\u0002\u0019AAg\u0003!!\u0018m]6OC6,\u0007bBAw!\u0001\u0007\u0011q\u001e\u0005\b\u0003\u0013\u0004\u0002\u0019AAf\u0011\u001d\ti\f\u0005a\u0001\u0003\u007fCqAa\u0003\u0011\u0001\u0004\ti\rC\u0004\u0002~B\u0001\r!!4\t\u000f\u0005e\u0006\u00031\u0001\u0002~!9!1\u0016\tA\u0002\t5\u0016a\u0002;be\u001e,Go\u001d\t\u0007\u0003o\u0011y+!4\n\t\tE\u0016\u0011\b\u0002\u0004'\u0016$\u0018!F4fi\u000e{g\u000e\u001e:pYR\u000b7o[:SKB|'\u000f\u001e\u000b\u0019\u0005\u0013\u00139L!/\u0003<\nu&q\u0018Ba\u0005\u0007\u0014)Ma2\u0003J\n-\u0007bBAS#\u0001\u0007\u0011q\u0015\u0005\b\u0003k\u000b\u0002\u0019AAT\u0011\u001d\u00119*\u0005a\u0001\u0003\u0017DqAa'\u0012\u0001\u0004\ti\rC\u0004\u0002nF\u0001\r!a<\t\u000f\u0005%\u0017\u00031\u0001\u0002L\"9\u0011QX\tA\u0002\u0005}\u0006b\u0002B\u0006#\u0001\u0007\u0011Q\u001a\u0005\b\u0003{\f\u0002\u0019AAg\u0011\u001d\tI,\u0005a\u0001\u0003\u0007CqAa+\u0012\u0001\u0004\u0011i+\u0001\u000ee_^tGn\\1e\u0007>tGO]8m)\u0006\u001c8n\u001d*fa>\u0014H\u000f\u0006\u000b\u0002N\nE'1\u001bBk\u0005/\u0014INa7\u0003^\n}'\u0011\u001d\u0005\b\u0003K\u0013\u0002\u0019AAT\u0011\u001d\t)L\u0005a\u0001\u0003OCqAa&\u0013\u0001\u0004\tY\rC\u0004\u0003\u001cJ\u0001\r!!4\t\u000f\u0005%'\u00031\u0001\u0002L\"9\u0011Q\u0018\nA\u0002\u0005}\u0006b\u0002B\u0006%\u0001\u0007\u0011Q\u001a\u0005\b\u0003{\u0014\u0002\u0019AAg\u0011\u001d\u0011YK\u0005a\u0001\u0005[C3B\u0005B#\u00053\u0012YFa\u0018\u0003b!Z!C!\u001a\u0003p\tE$Q\u000fB<\u0003]a\u0017n\u001d;BY2\u001c\u0015n](g)f\u0004Xm\u0012:pkB,G\r\u0006\u0004\u0003l\u000e\u001d1Q\u0004\t\t\u0005[\u00149Pa?\u0002N6\u0011!q\u001e\u0006\u0005\u0005c\u0014\u00190A\u0005j[6,H/\u00192mK*\u0019!Q\u001f>\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003z\n=(aA'baB!!Q`B\u0002\u001b\t\u0011yP\u0003\u0003\u0004\u0002\u0005u\u0012\u0001\u00027b]\u001eLAa!\u0002\u0003\u0000\n9\u0011J\u001c;fO\u0016\u0014\bbBB\u0005'\u0001\u000711B\u0001\u0007G&$\u0016\u0010]3\u0011\t\r51\u0011D\u0007\u0003\u0007\u001fQAa!\u0005\u0004\u0014\u00059!/\u001a4mK\u000e$(b\u0001\u000f\u0004\u0016)\u00191qC\u0011\u0002\rAdWoZ5o\u0013\u0011\u0019Yba\u0004\u0003\tQK\b/\u001a\u0005\b\u0007?\u0019\u0002\u0019AB\u0011\u0003!9W\r\u001e'bE\u0016d\u0007cB=\u0002\u0010\u000e\r\u0012Q\u001a\t\u0004\u0017\u000e\u0015\u0012bAB\u0014\u0019\n\u00193i\u001c8gS\u001e,(/\u0019;j_:LE/Z7ECR\fw+\u001b;i\u0013:$XM\u001d8bY&#\u0017!\u00047jgR$\u0016\u0010]3QCRD7\u000f\u0006\u0005\u00026\r52QGB\u001c\u0011\u001d\u0019y\u0003\u0006a\u0001\u0007c\t1\"\u0019:dQ&4X\rZ\"jgBA\u0011qZB\u001a\u0005w\fY-\u0003\u0003\u0003z\u0006\u0005\bbBB\u0010)\u0001\u00071\u0011\u0005\u0005\b\u0007\u0013!\u0002\u0019AB\u0006\u0003Aa\u0017n\u001d;F]ZL'o\u001c8nK:$8\u000f\u0006\u0002\u00026\u0005\u0001B.[:u\u0003B\u0004H.[2bi&|gn]\u0001\u0014I><h\u000e\\8bI\u0006+H-\u001b;SKB|'\u000f\u001e\u000b\u0003\u0003\u001bD3b\u0006B#\u00053\u0012YFa\u0018\u0003b!ZqC!\u001a\u0003p\tE$Q\u000fB<)\u0011\tim!\u0013\t\u000f\r-\u0003\u00041\u0001\u0002L\u00069am\u001c7eKJ\u001c\bf\u0003\r\u0003F\te#1\fB0\u0005CB3\u0002\u0007B3\u0005_\u0012\tH!\u001e\u0003x\u0005\u0011\u0002O]3wS\u0016<\u0018)\u001e3jiJ+\u0007o\u001c:u)!\u0019)f!\u0018\u0004`\r\u0005\u0004CBA-\u0003?\u001a9\u0006\u0005\u0003\u0002H\re\u0013\u0002BB.\u0003\u0013\u0012q\"Q;eSR\u0004&/\u001a<jK^\u0014vn\u001e\u0005\b\u0007\u0017J\u0002\u0019AAf\u0011\u001d\ti,\u0007a\u0001\u0003\u007fCq!!/\u001a\u0001\u0004\t\u0019\tK\u0006\u001a\u0005\u000b\u0012IFa\u0017\u0003`\t\u0005\u0004fB\r\u0003f\t=4qM\u0011\u0003\u0007S\nq\u0001\u001d:fm&,w\u000fK\u0002\u0001\u0007[\u0002Baa\u001c\u0004|5\u00111\u0011\u000f\u0006\u0005\u0005\u0017\u001a\u0019H\u0003\u0003\u0004v\r]\u0014a\u00024bGR|'/\u001f\u0006\u0005\u0007s\u0012\t&A\u0003cK\u0006t7/\u0003\u0003\u0004~\rE$!C!vi><\u0018N]3eQ\r\u00011\u0011\u0011\t\u0005\u0007\u0007\u001bI)\u0004\u0002\u0004\u0006*!1q\u0011B)\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0007\u0017\u001b)I\u0001\u0006D_:$(o\u001c7mKJ\u0004")
public class ReportServiceImpl
extends AbstractSecuredResource
implements ReportService,
Logging {
    private final ReportGenerator reportGenerator;
    private final PaginationService paginationService;
    private final CiRepository ciRepository;
    private final TaskArchive taskArchive;
    private final DownloadResource downloadResource;
    @Context
    private HttpResponse response;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReportServiceImpl reportServiceImpl = this;
        synchronized (reportServiceImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private HttpResponse response() {
        return this.response;
    }

    private void response_$eq(HttpResponse x$1) {
        this.response = x$1;
    }

    public void setResponse(HttpResponse response) {
        this.response_$eq(response);
    }

    private void setCiFilters(ArchivedTaskSearchParameters searchParameters, java.util.List<ConfigurationItemId> configurationItemIds) {
        Tuple2<List<String>, List<String>> tuple2 = TaskFilterUtils$.MODULE$.parseCiFilters((List<ConfigurationItemId>)((List)Option$.MODULE$.apply((Object)CollectionConverters$.MODULE$.ListHasAsScala(configurationItemIds).asScala()).toList().flatten(Predef$.MODULE$.$conforms())));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List applications = (List)tuple2._1();
        List environments = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)applications, (Object)environments);
        Tuple2 tuple23 = tuple22;
        List applications2 = (List)tuple23._1();
        List environments2 = (List)tuple23._2();
        applications2.foreach((Function1 & Serializable)x$1 -> searchParameters.forApplication(x$1));
        environments2.foreach((Function1 & Serializable)x$1 -> searchParameters.forEnvironment(x$1));
    }

    private <T> Stream<T> streamReport(Option<Paging> pagingMaybe, Function1<Paging, ArchivedTaskSearchParameters> buildParams, Function1<ArchivedTaskSearchParameters, Stream<T>> stream) {
        Option limitedMaybe = pagingMaybe.map((Function1 & Serializable)paging -> new Tuple2(paging, (Object)$this.paginationService.getLimitedPaging((Paging)paging)));
        ArchivedTaskSearchParameters searchParameters = (ArchivedTaskSearchParameters)buildParams.apply(limitedMaybe.map((Function1 & Serializable)x$3 -> (Paging)x$3._2()).getOrElse((Function0 & Serializable)() -> new Paging()));
        limitedMaybe.foreach((Function1 & Serializable)limitedPaging -> {
            this.paginationService.addPagingHeaderIfNeeded((Paging)limitedPaging._1(), (Paging)limitedPaging._2(), this.paginationService.toSetHeader(this.response()), () -> Predef$.MODULE$.int2Integer($this.taskArchive.countTotalResults(searchParameters$2)));
            return BoxedUnit.UNIT;
        });
        return (Stream)stream.apply((Object)searchParameters);
    }

    private Stream<DeploymentTaskReportLine> streamDeploymentTaskReport(Date begin, Date end, Option<Paging> paging, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, java.util.List<String> users, java.util.List<String> taskStates, java.util.List<String> taskTypes, FetchMode fetchMode, String taskId, boolean onlySuccessful, String workerName, java.util.List<ConfigurationItemId> configurationItemIds) {
        return this.streamReport(paging, (Function1<Paging, ArchivedTaskSearchParameters>)(Function1 & Serializable)limited -> {
            ArchivedTaskSearchParameters params = $this.reportGenerator.buildFilteredTaskSearchParameters(begin, end, (Paging)limited, order, null, users, taskStates, taskTypes, fetchMode, taskId, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Nil()).asJava(), ReportGenerator.DEPLOYMENT_ALLOWED_SORT_FIELDS, onlySuccessful, workerName);
            this.setCiFilters(params, configurationItemIds);
            return params;
        }, (Function1 & Serializable)searchParameters -> $this.reportGenerator.streamTaskReport((ArchivedTaskSearchParameters)searchParameters));
    }

    public Stream<DeploymentTaskReportLine> getTaskReport(Date begin, Date end, Paging paging, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, java.util.List<String> users, java.util.List<String> taskStates, java.util.List<String> taskTypes, FetchMode fetchMode, String taskId, boolean onlySuccessful, String workerName, java.util.List<ConfigurationItemId> configurationItemIds) {
        return this.streamDeploymentTaskReport(begin, end, (Option<Paging>)Option$.MODULE$.apply((Object)paging), order, users, taskStates, taskTypes, fetchMode, taskId, onlySuccessful, workerName, configurationItemIds);
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadTaskReport(Date begin, Date end, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, java.util.List<String> users, java.util.List<String> taskStates, java.util.List<String> taskTypes, String taskId, boolean onlySuccessful, String workerName, java.util.List<ConfigurationItemId> configurationItemIds) {
        Stream<ReportLine> stream = this.streamDeploymentTaskReport(begin, end, (Option<Paging>)None$.MODULE$, order, users, taskStates, taskTypes, FetchMode.SUMMARY, taskId, onlySuccessful, workerName, configurationItemIds).map(line -> DeploymentTaskReportLineConverter$.MODULE$.toReportLine((DeploymentTaskReportLine)line));
        String fileName = String.format("tasks-%s-%s.csv", ReportUtils.DATE_FORMAT.print((ReadableInstant)begin.asDateTime()), ReportUtils.DATE_FORMAT.print((ReadableInstant)end.asDateTime()));
        return ReportUtils.createDownloadToken(this.downloadResource, CollectionConverters$.MODULE$.SetHasAsJava(DeploymentReportLineField$.MODULE$.allFields()).asJava(), stream, fileName);
    }

    private Stream<ControlTaskReportLine> streamControlTaskReport(Date begin, Date end, java.util.List<String> states, String taskName, FetchMode fetchMode, java.util.List<String> users, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, String workerName, String taskId, Option<Paging> paging, java.util.Set<String> targets) {
        return this.streamReport(paging, (Function1<Paging, ArchivedTaskSearchParameters>)(Function1 & Serializable)limited -> {
            ArchivedTaskSearchParameters params = $this.reportGenerator.buildTaskSearchParameters((Paging)limited, order, EnumSet.of(TaskType.CONTROL), ReportGenerator.CONTROL_ALLOWED_SORT_FIELDS);
            params.withTargets(targets);
            params.withTaskStates(states);
            params.withTaskName(taskName);
            params.withFetchMode(fetchMode);
            params.withWorkerName(workerName);
            params.inDateTimeRange($this.reportGenerator.safeDateTime(begin, null), $this.reportGenerator.safeDateTime(end, null));
            params.withUniqueId(taskId);
            Object object = users != null && !users.isEmpty() ? params.forUsers((java.util.Set)Sets.newHashSet((Iterable)users)) : BoxedUnit.UNIT;
            return params;
        }, (Function1 & Serializable)searchParameters -> $this.reportGenerator.streamControlTasksReport((ArchivedTaskSearchParameters)searchParameters));
    }

    public Stream<ControlTaskReportLine> getControlTasksReport(Date begin, Date end, java.util.List<String> states, String taskName, FetchMode fetchMode, java.util.List<String> users, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, String workerName, String taskId, Paging paging, java.util.Set<String> targets) {
        return this.streamControlTaskReport(begin, end, states, taskName, fetchMode, users, order, workerName, taskId, (Option<Paging>)Option$.MODULE$.apply((Object)paging), targets);
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadControlTasksReport(Date begin, Date end, java.util.List<String> states, String taskName, java.util.List<String> users, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, String workerName, String taskId, java.util.Set<String> targets) {
        Stream<ReportLine> report = this.streamControlTaskReport(begin, end, states, taskName, FetchMode.SUMMARY, users, order, workerName, taskId, (Option<Paging>)None$.MODULE$, targets).map(line -> ControlTaskReportLineConverter$.MODULE$.toReportLine((ControlTaskReportLine)line));
        return ReportUtils.createDownloadToken(this.downloadResource, CollectionConverters$.MODULE$.SetHasAsJava(ControlTaskReportLineField$.MODULE$.allFields()).asJava(), report, this.reportGenerator.buildControlTaskReportFileName(begin, end));
    }

    private Map<Integer, String> listAllCisOfTypeGrouped(Type ciType, Function1<ConfigurationItemDataWithInternalId, String> getLabel) {
        SearchParameters params = SearchParametersFactory.createSearchParams((Type)ciType, (long)0L, (long)-1L);
        PlatformPermissions.READ.getPermissionHandler().applyPermission(params);
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.ciRepository.listInternal(params)).asScala().map((Function1 & Serializable)item -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)item.internalId()), getLabel.apply(item)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private java.util.List<ConfigurationItemId> listTypePaths(Map<Integer, java.util.List<String>> archivedCis, Function1<ConfigurationItemDataWithInternalId, String> getLabel, Type ciType) {
        List list;
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        Map<Integer, String> cisInRepository = this.listAllCisOfTypeGrouped(ciType, getLabel);
        scala.collection.immutable.Set matchedIds = (scala.collection.immutable.Set)archivedCis.keySet().intersect((Set)cisInRepository.keySet());
        List onlyInArchive = ((IterableOnceOps)archivedCis.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Integer id = (Integer)tuple2._1();
            java.util.List paths = (java.util.List)tuple2._2();
            Nil$ nil$ = matchedIds.contains((Object)id) ? (Seq)CollectionConverters$.MODULE$.ListHasAsScala(paths).asScala().filter((Function1 & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)ReportServiceImpl.$anonfun$listTypePaths$2(cisInRepository, id, path))) : package$.MODULE$.Nil();
            return nil$;
        })).toList();
        List list2 = cisInRepository.values().toList();
        List inArchiveAndRepository = onlyInArchive.$colon$colon$colon(list2);
        if (this.hasPermission(PlatformPermissions.REPORT_VIEW)) {
            List list3 = inArchiveAndRepository;
            list = ((IterableOnceOps)archivedCis.view().filterKeys((Function1 & Serializable)id -> BoxesRunTime.boxToBoolean((boolean)ReportServiceImpl.$anonfun$listTypePaths$3(cisInRepository, id))).values().flatMap((Function1 & Serializable)x$4 -> CollectionConverters$.MODULE$.ListHasAsScala(x$4).asScala())).toList().$colon$colon$colon(list3);
        } else {
            list = inArchiveAndRepository;
        }
        List result = list;
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)((StrictOptimizedSeqOps)result.distinct()).sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)x$5 -> new ConfigurationItemId(x$5, ciType))).asJava();
    }

    public java.util.List<ConfigurationItemId> listEnvironments() {
        return this.listTypePaths((Map<Integer, java.util.List<String>>)CollectionConverters$.MODULE$.MapHasAsScala(this.reportGenerator.getEnvironments()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Function1<ConfigurationItemDataWithInternalId, String>)(Function1 & Serializable)x$6 -> x$6.id(), Type.valueOf(Environment.class));
    }

    public java.util.List<ConfigurationItemId> listApplications() {
        return this.listTypePaths((Map<Integer, java.util.List<String>>)CollectionConverters$.MODULE$.MapHasAsScala(this.reportGenerator.getApplications()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Function1<ConfigurationItemDataWithInternalId, String>)(Function1 & Serializable)x$7 -> x$7.name(), Type.valueOf(Application.class));
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadAuditReport() {
        return this.reportGenerator.generateAuditReport(Collections.emptyList(), this.downloadResource);
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadAuditReport(java.util.List<String> folders) {
        return this.reportGenerator.generateAuditReport(folders, this.downloadResource);
    }

    @Workdir(prefix="preview")
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public Stream<AuditPreviewRow> previewAuditReport(java.util.List<String> folders, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, Paging paging) {
        AuditPreviewReport previewReport = this.reportGenerator.previewAuditReport(folders, order, paging);
        Paging limited = this.paginationService.getLimitedPaging(paging);
        this.paginationService.addPagingHeaderIfNeeded(paging, limited, this.paginationService.toSetHeader(this.response()), () -> previewReport.total());
        return previewReport.currentPageData().stream();
    }

    public static final /* synthetic */ boolean $anonfun$listTypePaths$2(Map cisInRepository$1, Integer id$1, String path) {
        Object object = cisInRepository$1.apply((Object)id$1);
        String string = path;
        return object == null ? string != null : !object.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$listTypePaths$3(Map cisInRepository$1, Integer id) {
        return !cisInRepository$1.keySet().contains((Object)id);
    }

    public ReportServiceImpl(ReportGenerator reportGenerator, PaginationService paginationService, CiRepository ciRepository, TaskArchive taskArchive, DownloadResource downloadResource) {
        this.reportGenerator = reportGenerator;
        this.paginationService = paginationService;
        this.ciRepository = ciRepository;
        this.taskArchive = taskArchive;
        this.downloadResource = downloadResource;
        Logging.$init$((Logging)this);
    }
}

