/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import com.xebialabs.deployit.converter.HoconDurationConverter$;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.core.service.PaginationService;
import com.xebialabs.deployit.engine.api.SatelliteService;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.dto.SatelliteInfo;
import com.xebialabs.deployit.engine.tasker.satellite.ActorLocator;
import com.xebialabs.deployit.engine.tasker.satellite.ActorLocator$;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.satellite.ExtensionsDelta$;
import com.xebialabs.deployit.plugin.satellite.InstalledExtensionsDelta;
import com.xebialabs.deployit.plugin.satellite.SatelliteInfoChecker;
import com.xebialabs.deployit.plugin.satellite.SatelliteInfoChecker$;
import com.xebialabs.deployit.plugin.satellite.extension.ExtensionsLocator;
import com.xebialabs.deployit.plugin.satellite.extension.FileSystemExtensionsLocator$;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SatelliteRepository;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.tasksystem.TaskActorSystem$;
import com.xebialabs.satellite.protocol.Paths$;
import com.xebialabs.xlplatform.satellite.Satellite;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@Service
@ScalaSignature(bytes="\u0006\u0005\tEa\u0001\u0002\u000b\u0016\u0001\tB\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"Aa\t\u0001B\u0001B\u0003%q\tC\u0003K\u0001\u0011\u00051\nC\u0004a\u0001\t\u0007I\u0011A1\t\r1\u0004\u0001\u0015!\u0003c\u0011%I\b\u00011AA\u0002\u0013\u0005!\u0010C\u0006\u0002\u0012\u0001\u0001\r\u00111A\u0005\u0002\u0005M\u0001BCA\u0011\u0001\u0001\u0007\t\u0011)Q\u0005w\"9\u0011\u0011\u0007\u0001\u0005\n\u0005M\u0002\"CA#\u0001\t\u0007I1AA$\u0011!\tI\u0006\u0001Q\u0001\n\u0005%\u0003\"CA.\u0001\t\u0007I1AA/\u0011!\t9\u0007\u0001Q\u0001\n\u0005}\u0003bBA5\u0001\u0011\u0005\u00131\u000e\u0005\b\u0003{\u0002A\u0011IA@\u0011\u001d\tI\u000b\u0001C\u0005\u0003WCq!a/\u0001\t\u0003\ni\fC\u0004\u0002p\u0002!\t%!=\u0003)M\u000bG/\u001a7mSR,7+\u001a:wS\u000e,\u0017*\u001c9m\u0015\t1r#A\u0002ba&T!\u0001G\r\u0002\tI,7\u000f\u001e\u0006\u00035m\tAaY8sK*\u0011A$H\u0001\tI\u0016\u0004Hn\\=ji*\u0011adH\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001I\u0001\u0004G>l7\u0001A\n\u0005\u0001\rJ\u0003\u0007\u0005\u0002%O5\tQE\u0003\u0002'/\u000591/Z2ve\u0016$\u0017B\u0001\u0015&\u0005]\t%m\u001d;sC\u000e$8+Z2ve\u0016$'+Z:pkJ\u001cW\r\u0005\u0002+]5\t1F\u0003\u0002\u0017Y)\u0011QfG\u0001\u0007K:<\u0017N\\3\n\u0005=Z#\u0001E*bi\u0016dG.\u001b;f'\u0016\u0014h/[2f!\t\td'D\u00013\u0015\t\u0019D'A\u0003tY\u001a$$NC\u00016\u0003!9'/\u001b>{Y\u0016$\u0017BA\u001c3\u0005\u001daunZ4j]\u001e\f1c]1uK2d\u0017\u000e^3SKB|7/\u001b;pef\u0004\"AO\u001f\u000e\u0003mR!\u0001P\u000e\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002?w\t\u00192+\u0019;fY2LG/\u001a*fa>\u001c\u0018\u000e^8ss\u0006\t\u0002/Y4j]\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\rK\u0012aB:feZL7-Z\u0005\u0003\u000b\n\u0013\u0011\u0003U1hS:\fG/[8o'\u0016\u0014h/[2f\u0003E\u0011X\r]8tSR|'/_*feZL7-\u001a\t\u0003u!K!!S\u001e\u0003#I+\u0007o\\:ji>\u0014\u0018pU3sm&\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0005\u0019:{\u0005\u000b\u0005\u0002N\u00015\tQ\u0003C\u00039\t\u0001\u0007\u0011\bC\u0003@\t\u0001\u0007\u0001\tC\u0003G\t\u0001\u0007q\t\u000b\u0002\u0005%B\u00111KX\u0007\u0002)*\u0011QKV\u0001\u000bC:tw\u000e^1uS>t'BA,Y\u0003\u001d1\u0017m\u0019;pefT!!\u0017.\u0002\u000b\t,\u0017M\\:\u000b\u0005mc\u0016aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003u\u000b1a\u001c:h\u0013\tyFKA\u0005BkR|w/\u001b:fI\u0006A!/Z:q_:\u001cX-F\u0001c!\t\u0019'.D\u0001e\u0015\t)g-A\u0002ta&T!a\u001a5\u0002\u0011I,7\u000f^3bgfT!!\u001b/\u0002\u000b)\u0014wn]:\n\u0005-$'\u0001\u0004%uiB\u0014Vm\u001d9p]N,\u0017!\u0003:fgB|gn]3!Q\t1a\u000e\u0005\u0002po6\t\u0001O\u0003\u0002\u001bc*\u0011!o]\u0001\u0003eNT!\u0001^;\u0002\u0005]\u001c(\"\u0001<\u0002\u000b)\fg/\u0019=\n\u0005a\u0004(aB\"p]R,\u0007\u0010^\u0001\u0017I\u00164\u0017-\u001e7u!&tw\rV5nK>,H\u000f\u0015:paV\t1\u0010E\u0002}\u0003\u0017q1!`A\u0004!\rq\u00181A\u0007\u0002\u007f*\u0019\u0011\u0011A\u0011\u0002\rq\u0012xn\u001c;?\u0015\t\t)!A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\n\u0005\r\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002\u000e\u0005=!AB*ue&twM\u0003\u0003\u0002\n\u0005\r\u0011A\u00073fM\u0006,H\u000e\u001e)j]\u001e$\u0016.\\3pkR\u0004&o\u001c9`I\u0015\fH\u0003BA\u000b\u0003;\u0001B!a\u0006\u0002\u001a5\u0011\u00111A\u0005\u0005\u00037\t\u0019A\u0001\u0003V]&$\b\u0002CA\u0010\u0011\u0005\u0005\t\u0019A>\u0002\u0007a$\u0013'A\feK\u001a\fW\u000f\u001c;QS:<G+[7f_V$\bK]8qA!:\u0011\"!\n\u0002,\u00055\u0002cA*\u0002(%\u0019\u0011\u0011\u0006+\u0003\u000bY\u000bG.^3\u0002\u000bY\fG.^3\"\u0005\u0005=\u0012a\n\u0013|q2t3/\u0019;fY2LG/\u001a\u0018uS6,w.\u001e;/S:4wNO\u00191AM,7m\u001c8egv\f!\u0003Z3gCVdG\u000fU5oORKW.Z8viV\u0011\u0011Q\u0007\t\u0005\u0003o\t\t%\u0004\u0002\u0002:)!\u00111HA\u001f\u0003!!WO]1uS>t'\u0002BA \u0003\u0007\t!bY8oGV\u0014(/\u001a8u\u0013\u0011\t\u0019%!\u000f\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u0006Y\u0011m\u0019;peNK8\u000f^3n+\t\tI\u0005\u0005\u0003\u0002L\u0005USBAA'\u0015\u0011\ty%!\u0015\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0005\u0005M\u0013\u0001B1lW\u0006LA!a\u0016\u0002N\tY\u0011i\u0019;peNK8\u000f^3n\u00031\t7\r^8s'f\u001cH/Z7!\u0003)!\u0017n\u001d9bi\u000eDWM]\u000b\u0003\u0003?\u0002B!!\u0019\u0002d5\u0011\u0011QH\u0005\u0005\u0003K\niD\u0001\rFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0016CXmY;u_J\f1\u0002Z5ta\u0006$8\r[3sA\u00059q-\u001a;J]\u001a|G\u0003BA7\u0003s\u0002B!a\u001c\u0002v5\u0011\u0011\u0011\u000f\u0006\u0004\u0003gZ\u0013a\u00013u_&!\u0011qOA9\u00055\u0019\u0016\r^3mY&$X-\u00138g_\"1\u00111P\bA\u0002m\fAaY5JI\u0006Aq-\u001a;J]\u001a|7\u000f\u0006\u0003\u0002\u0002\u0006\r\u0006CBAB\u0003;\u000biG\u0004\u0003\u0002\u0006\u0006]e\u0002BAD\u0003'sA!!#\u0002\u0012:!\u00111RAH\u001d\rq\u0018QR\u0005\u0002A%\u0011adH\u0005\u00039uI1!!&\u001c\u0003%\u0001(o\u001c<jg&|g.\u0003\u0003\u0002\u001a\u0006m\u0015a\u00029bG.\fw-\u001a\u0006\u0004\u0003+[\u0012\u0002BAP\u0003C\u0013QA\u0013'jgRTA!!'\u0002\u001c\"9\u0011Q\u0015\tA\u0002\u0005\u001d\u0016aA5egB)\u00111QAOw\u0006\u0001\u0012M]3QYV<\u0017N\\:Ts:\u001cW\r\u001a\u000b\u0005\u0003[\u000bI\f\u0005\u0004\u0002\u0018\u0005=\u00161W\u0005\u0005\u0003c\u000b\u0019A\u0001\u0004PaRLwN\u001c\t\u0005\u0003/\t),\u0003\u0003\u00028\u0006\r!a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003w\n\u0002\u0019A>\u0002\u00131L7\u000f\u001e%pgR\u001cHCCA`\u0003+\f9.a7\u0002fB1\u0011\u0011YAf\u0003\u001fl!!a1\u000b\t\u0005\u0015\u0017qY\u0001\u0005kRLGN\u0003\u0002\u0002J\u0006!!.\u0019<b\u0013\u0011\ti-a1\u0003\t1K7\u000f\u001e\t\u0005\u0003_\n\t.\u0003\u0003\u0002T\u0006E$aE\"p]\u001aLw-\u001e:bi&|g.\u0013;f[&#\u0007BBA>%\u0001\u00071\u0010\u0003\u0004\u0002ZJ\u0001\ra_\u0001\u0005]\u0006lW\rC\u0004\u0002^J\u0001\r!a8\u0002\rA\fw-\u001b8h!\u0011\ty'!9\n\t\u0005\r\u0018\u0011\u000f\u0002\u0007!\u0006<\u0017N\\4\t\u000f\u0005\u001d(\u00031\u0001\u0002j\u0006)qN\u001d3feB!\u0011qNAv\u0013\u0011\ti/!\u001d\u0003\u0011=\u0013H-\u001a:j]\u001e\f!bY8v]RDun\u001d;t)\u0019\t\u00190a@\u0003\u0002A!\u0011Q_A~\u001b\t\t9P\u0003\u0003\u0002z\u0006\u001d\u0017\u0001\u00027b]\u001eLA!!@\u0002x\n9\u0011J\u001c;fO\u0016\u0014\bBBA>'\u0001\u00071\u0010\u0003\u0004\u0002ZN\u0001\ra\u001f\u0015\u0004\u0001\t\u0015\u0001\u0003\u0002B\u0004\u0005\u001bi!A!\u0003\u000b\u0007\t-!,\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAAa\u0004\u0003\n\t91+\u001a:wS\u000e,\u0007")
public class SatelliteServiceImpl
extends AbstractSecuredResource
implements SatelliteService,
Logging {
    private final SatelliteRepository satelliteRepository;
    private final PaginationService paginationService;
    private final RepositoryService repositoryService;
    @Context
    private final HttpResponse response;
    @Value(value="${xl.satellite.timeout.info:10 seconds}")
    private String defaultPingTimeoutProp;
    private final ActorSystem actorSystem;
    private final ExecutionContextExecutor dispatcher;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SatelliteServiceImpl satelliteServiceImpl = this;
        synchronized (satelliteServiceImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public HttpResponse response() {
        return this.response;
    }

    public String defaultPingTimeoutProp() {
        return this.defaultPingTimeoutProp;
    }

    public void defaultPingTimeoutProp_$eq(String x$1) {
        this.defaultPingTimeoutProp = x$1;
    }

    private FiniteDuration defaultPingTimeout() {
        return HoconDurationConverter$.MODULE$.convert(this.defaultPingTimeoutProp());
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public ExecutionContextExecutor dispatcher() {
        return this.dispatcher;
    }

    public SatelliteInfo getInfo(String ciId) {
        ActorRef x$3;
        Timeout x$2;
        SatelliteInfoChecker.Get x$1;
        Timeout timeout = new Timeout(this.defaultPingTimeout());
        ConfigurationItem ci = this.repositoryService.read(ciId);
        if (!ci.getType().instanceOf(Type.valueOf((String)"xl.Satellite"))) {
            return null;
        }
        Satellite satellite = (Satellite)ci;
        ActorLocator actorLocator = ActorLocator$.MODULE$.apply(satellite);
        ActorRef checker = TaskActorSystem$.MODULE$.actorSystem().actorOf(SatelliteInfoChecker$.MODULE$.props(satellite.getAddress()));
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(checker);
        Future future = AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)(x$1 = new SatelliteInfoChecker.Get(actorLocator.locate(Paths$.MODULE$.info(), this.actorSystem()))), x$2 = timeout, x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1)).recover((PartialFunction)new Serializable(this, satellite){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ SatelliteServiceImpl $outer;
            private final Satellite satellite$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                this.$outer.logger().debug((Function0 & Serializable)() -> new StringBuilder(33).append("Operation failed on satellite ").append($this.satellite$1.getAddress()).append(" (").append(A1.getMessage()).append(")").toString());
                SatelliteInfo satelliteInfo = new SatelliteInfo();
                return (B1)satelliteInfo;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.satellite$1 = satellite$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.xebialabs.deployit.core.rest.api.SatelliteServiceImpl$$anonfun$1 java.lang.Throwable )}, serializedLambda);
            }
        }, (ExecutionContext)this.dispatcher());
        SatelliteInfo satelliteInfo = (SatelliteInfo)Await$.MODULE$.result((Awaitable)future, package.DoubleMult$.MODULE$.$times$extension(package$.MODULE$.DoubleMult(1.5), (Duration)this.defaultPingTimeout()));
        if (Predef$.MODULE$.Boolean2boolean(satelliteInfo.isAvailable())) {
            Option<Object> option = this.arePluginsSynced(ci.getId());
            if (option instanceof Some) {
                Some some = (Some)option;
                boolean pluginSync = BoxesRunTime.unboxToBoolean((Object)some.value());
                satelliteInfo.setPluginsSynced(Predef$.MODULE$.boolean2Boolean(pluginSync));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
        }
        satelliteInfo.setSatelliteId(ciId);
        return satelliteInfo;
    }

    public List<SatelliteInfo> getInfos(List<String> ids) {
        Buffer getInfoFutures = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(ids).asScala().map((Function1 & Serializable)ciId -> Future$.MODULE$.apply((Function0 & Serializable)() -> this.getInfo((String)ciId), (ExecutionContext)this.dispatcher()));
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)Await$.MODULE$.result((Awaitable)Future$.MODULE$.sequence((IterableOnce)getInfoFutures, BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)this.dispatcher()), (Duration)package.IntMult$.MODULE$.$times$extension(package$.MODULE$.IntMult(3), this.defaultPingTimeout()))).toList()).asJava();
    }

    private Option<Object> arePluginsSynced(String ciId) {
        Some some;
        Timeout timeout = new Timeout(this.defaultPingTimeout());
        ConfigurationItem ci = this.repositoryService.read(ciId);
        if (!ci.getType().instanceOf(Type.valueOf((String)"xl.Satellite"))) {
            return None$.MODULE$;
        }
        Satellite satellite = (Satellite)ci;
        ActorLocator actorLocator = ActorLocator$.MODULE$.apply(satellite);
        try {
            InstalledExtensionsDelta deltas = ExtensionsDelta$.MODULE$.calculateExtensionsDelta((ExtensionsLocator)FileSystemExtensionsLocator$.MODULE$, actorLocator, this.actorSystem());
            some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)deltas.empty()));
        }
        catch (Exception error) {
            this.logger().error((Function0 & Serializable)() -> new StringBuilder(51).append("Plugin sync check operation failed on satellite ").append(satellite.getAddress()).append(" (").append(error.getMessage()).append(")").toString());
            some = Option$.MODULE$.empty();
        }
        return some;
    }

    public List<ConfigurationItemId> listHosts(String ciId, String name, Paging paging, Ordering order) {
        this.checkPermission(PlatformPermissions.READ, ciId);
        this.paginationService.addPagingHeaderIfNeeded(this.paginationService.toSetHeader(this.response()), () -> this.countHosts(ciId, name), paging);
        return this.satelliteRepository.listHosts(ciId, name, paging, order);
    }

    public Integer countHosts(String ciId, String name) {
        this.checkPermission(PlatformPermissions.READ, ciId);
        return Predef$.MODULE$.int2Integer(this.satelliteRepository.countHosts(ciId, name));
    }

    @Autowired
    public SatelliteServiceImpl(SatelliteRepository satelliteRepository, PaginationService paginationService, RepositoryService repositoryService) {
        this.satelliteRepository = satelliteRepository;
        this.paginationService = paginationService;
        this.repositoryService = repositoryService;
        Logging.$init$((Logging)this);
        this.response = null;
        this.actorSystem = TaskActorSystem$.MODULE$.actorSystem();
        this.dispatcher = this.actorSystem().dispatcher();
    }
}

