/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.core.api.dto.ReportLine;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.converters.ControlTaskReportLineConverter$;
import com.xebialabs.deployit.core.converters.ControlTaskReportLineField$;
import com.xebialabs.deployit.core.converters.DeploymentReportLineField$;
import com.xebialabs.deployit.core.converters.DeploymentTaskReportLineConverter$;
import com.xebialabs.deployit.core.rest.api.DownloadResource;
import com.xebialabs.deployit.core.rest.api.SearchParametersFactory;
import com.xebialabs.deployit.core.rest.api.reports.ReportUtils;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.core.service.PaginationService;
import com.xebialabs.deployit.core.service.ReportGenerator;
import com.xebialabs.deployit.core.util.TaskFilterUtils$;
import com.xebialabs.deployit.engine.api.ReportService;
import com.xebialabs.deployit.engine.api.dto.AuditPreviewRow;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.ControlTaskReportLine;
import com.xebialabs.deployit.engine.api.dto.DeploymentTaskReportLine;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.execution.FetchMode;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.report.audit.AuditPreviewReport;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.sql.CiRepository;
import com.xebialabs.deployit.repository.sql.ConfigurationItemDataWithInternalId;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.archive.TaskArchive;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Stream;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.joda.time.ReadableInstant;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Controller
@Autowired
@ScalaSignature(bytes="\u0006\u0001\ree\u0001\u0002\u000e\u001c\u0001!B\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\"A\u0011\n\u0001B\u0001B\u0003%!\n\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003T\u0011!Y\u0006A!A!\u0002\u0013a\u0006\"\u00021\u0001\t\u0003\t\u0007\"\u00035\u0001\u0001\u0004\u0005\r\u0011\"\u0003j\u0011%1\b\u00011AA\u0002\u0013%q\u000f\u0003\u0006\u0002\u0002\u0001\u0001\r\u0011!Q!\n)Dq!a\u0007\u0001\t\u0003\ti\u0002C\u0004\u0002\"\u0001!I!a\t\t\u000f\u0005E\u0003\u0001\"\u0003\u0002T!9\u0011Q\u0016\u0001\u0005\n\u0005=\u0006b\u0002B\u0012\u0001\u0011\u0005#Q\u0005\u0005\b\u0005\u007f\u0001A\u0011\tB!\u0011\u001d\u00119\n\u0001C\u0005\u00053CqA!2\u0001\t\u0003\u00129\rC\u0004\u0003`\u0002!\tE!9\t\u000f\te\b\u0001\"\u0003\u0003|\"91Q\u0007\u0001\u0005\n\r]\u0002bBB#\u0001\u0011\u00053q\t\u0005\b\u0007\u0013\u0002A\u0011IB$\u0011\u001d\u0019Y\u0005\u0001C!\u0007\u001bBqaa\u0013\u0001\t\u0003\u001a\u0019\u0006C\u0004\u0004^\u0001!\tea\u0018\u0003#I+\u0007o\u001c:u'\u0016\u0014h/[2f\u00136\u0004HN\u0003\u0002\u001d;\u0005\u0019\u0011\r]5\u000b\u0005yy\u0012\u0001\u0002:fgRT!\u0001I\u0011\u0002\t\r|'/\u001a\u0006\u0003E\r\n\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003I\u0015\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\u0019\n1aY8n\u0007\u0001\u0019B\u0001A\u00150mA\u0011!&L\u0007\u0002W)\u0011A&H\u0001\bg\u0016\u001cWO]3e\u0013\tq3FA\fBEN$(/Y2u'\u0016\u001cWO]3e%\u0016\u001cx.\u001e:dKB\u0011\u0001\u0007N\u0007\u0002c)\u0011AD\r\u0006\u0003g\u0005\na!\u001a8hS:,\u0017BA\u001b2\u00055\u0011V\r]8siN+'O^5dKB\u0011q\u0007P\u0007\u0002q)\u0011\u0011HO\u0001\u0006g24GG\u001b\u0006\u0002w\u0005AqM]5{u2,G-\u0003\u0002>q\t9Aj\\4hS:<\u0017a\u0004:fa>\u0014HoR3oKJ\fGo\u001c:\u0011\u0005\u0001\u001bU\"A!\u000b\u0005\t{\u0012aB:feZL7-Z\u0005\u0003\t\u0006\u0013qBU3q_J$x)\u001a8fe\u0006$xN]\u0001\u0012a\u0006<\u0017N\\1uS>t7+\u001a:wS\u000e,\u0007C\u0001!H\u0013\tA\u0015IA\tQC\u001eLg.\u0019;j_:\u001cVM\u001d<jG\u0016\fAbY5SKB|7/\u001b;pef\u0004\"a\u0013)\u000e\u00031S!!\u0014(\u0002\u0007M\fHN\u0003\u0002PC\u0005Q!/\u001a9pg&$xN]=\n\u0005Ec%\u0001D\"j%\u0016\u0004xn]5u_JL\u0018a\u0003;bg.\f%o\u00195jm\u0016\u0004\"\u0001V-\u000e\u0003US!AV,\u0002\u000f\u0005\u00148\r[5wK*\u0011\u0001,I\u0001\u0005i\u0006\u001c8.\u0003\u0002[+\nYA+Y:l\u0003J\u001c\u0007.\u001b<f\u0003A!wn\u001e8m_\u0006$'+Z:pkJ\u001cW\r\u0005\u0002^=6\t1$\u0003\u0002`7\t\u0001Bi\\<oY>\fGMU3t_V\u00148-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\t\u001cG-\u001a4h!\ti\u0006\u0001C\u0003?\r\u0001\u0007q\bC\u0003F\r\u0001\u0007a\tC\u0003J\r\u0001\u0007!\nC\u0003S\r\u0001\u00071\u000bC\u0003\\\r\u0001\u0007A,\u0001\u0005sKN\u0004xN\\:f+\u0005Q\u0007CA6u\u001b\u0005a'BA7o\u0003\r\u0019\b/\u001b\u0006\u0003_B\f\u0001B]3ti\u0016\f7/\u001f\u0006\u0003cJ\fQA\u001b2pgNT\u0011a]\u0001\u0004_J<\u0017BA;m\u00051AE\u000f\u001e9SKN\u0004xN\\:f\u00031\u0011Xm\u001d9p]N,w\fJ3r)\tAh\u0010\u0005\u0002zy6\t!PC\u0001|\u0003\u0015\u00198-\u00197b\u0013\ti(P\u0001\u0003V]&$\bbB@\t\u0003\u0003\u0005\rA[\u0001\u0004q\u0012\n\u0014!\u0003:fgB|gn]3!Q\rI\u0011Q\u0001\t\u0005\u0003\u000f\t9\"\u0004\u0002\u0002\n)\u0019\u0001%a\u0003\u000b\t\u00055\u0011qB\u0001\u0003eNTA!!\u0005\u0002\u0014\u0005\u0011qo\u001d\u0006\u0003\u0003+\tQA[1wCbLA!!\u0007\u0002\n\t91i\u001c8uKb$\u0018aC:fiJ+7\u000f]8og\u0016$2\u0001_A\u0010\u0011\u0015A'\u00021\u0001k\u00031\u0019X\r^\"j\r&dG/\u001a:t)\u0015A\u0018QEA\u0019\u0011\u001d\t9c\u0003a\u0001\u0003S\t\u0001c]3be\u000eD\u0007+\u0019:b[\u0016$XM]:\u0011\t\u0005-\u0012QF\u0007\u0002/&\u0019\u0011qF,\u00039\u0005\u00138\r[5wK\u0012$\u0016m]6TK\u0006\u00148\r\u001b)be\u0006lW\r^3sg\"9\u00111G\u0006A\u0002\u0005U\u0012\u0001F2p]\u001aLw-\u001e:bi&|g.\u0013;f[&#7\u000f\u0005\u0004\u00028\u0005\u0005\u0013QI\u0007\u0003\u0003sQA!a\u000f\u0002>\u0005!Q\u000f^5m\u0015\t\ty$\u0001\u0003kCZ\f\u0017\u0002BA\"\u0003s\u0011A\u0001T5tiB!\u0011qIA'\u001b\t\tIEC\u0002\u0002LE\n1\u0001\u001a;p\u0013\u0011\ty%!\u0013\u0003'\r{gNZ5hkJ\fG/[8o\u0013R,W.\u00133\u0002\u0019M$(/Z1n%\u0016\u0004xN\u001d;\u0016\t\u0005U\u0013q\r\u000b\t\u0003/\nI(!#\u0002\u0014B1\u0011\u0011LA0\u0003Gj!!a\u0017\u000b\t\u0005u\u0013\u0011H\u0001\u0007gR\u0014X-Y7\n\t\u0005\u0005\u00141\f\u0002\u0007'R\u0014X-Y7\u0011\t\u0005\u0015\u0014q\r\u0007\u0001\t\u001d\tI\u0007\u0004b\u0001\u0003W\u0012\u0011\u0001V\t\u0005\u0003[\n\u0019\bE\u0002z\u0003_J1!!\u001d{\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!_A;\u0013\r\t9H\u001f\u0002\u0004\u0003:L\bbBA>\u0019\u0001\u0007\u0011QP\u0001\u0007a\u0006<\u0017N\\4\u0011\u000be\fy(a!\n\u0007\u0005\u0005%P\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u000f\n))\u0003\u0003\u0002\b\u0006%#A\u0002)bO&tw\rC\u0004\u0002\f2\u0001\r!!$\u0002\u0017\t,\u0018\u000e\u001c3QCJ\fWn\u001d\t\bs\u0006=\u00151QA\u0015\u0013\r\t\tJ\u001f\u0002\n\rVt7\r^5p]FBq!!\u0018\r\u0001\u0004\t)\nE\u0004z\u0003\u001f\u000bI#a\u0016)\u000f1\tI*!*\u0002(B!\u00111TAQ\u001b\t\tiJ\u0003\u0003\u0002 \u0006u\u0012\u0001\u00027b]\u001eLA!a)\u0002\u001e\n\u00012+\u001e9qe\u0016\u001c8oV1s]&twm]\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0003S\u000b#!a+\u0002\u0007\u0005dG.\u0001\u000etiJ,\u0017-\u001c#fa2|\u00170\\3oiR\u000b7o\u001b*fa>\u0014H\u000f\u0006\u000e\u00022\u0006e\u0016\u0011ZAg\u0003\u001f\fY.a>\u0002|\u0006}(q\u0002B\n\u0005;\u0011\t\u0003\u0005\u0004\u0002Z\u0005}\u00131\u0017\t\u0005\u0003\u000f\n),\u0003\u0003\u00028\u0006%#\u0001\u0007#fa2|\u00170\\3oiR\u000b7o\u001b*fa>\u0014H\u000fT5oK\"9\u00111X\u0007A\u0002\u0005u\u0016!\u00022fO&t\u0007\u0003BA`\u0003\u000bl!!!1\u000b\u0007=\f\u0019M\u0003\u0002\u001d?%!\u0011qYAa\u0005\u0011!\u0015\r^3\t\u000f\u0005-W\u00021\u0001\u0002>\u0006\u0019QM\u001c3\t\u000f\u0005mT\u00021\u0001\u0002~!9\u0011\u0011[\u0007A\u0002\u0005M\u0017!B8sI\u0016\u0014\bCBA\u001c\u0003\u0003\n)\u000e\u0005\u0003\u0002H\u0005]\u0017\u0002BAm\u0003\u0013\u0012\u0001b\u0014:eKJLgn\u001a\u0005\b\u0003;l\u0001\u0019AAp\u0003\u0015)8/\u001a:t!\u0019\t9$!\u0011\u0002bB!\u00111]Ay\u001d\u0011\t)/!<\u0011\u0007\u0005\u001d(0\u0004\u0002\u0002j*\u0019\u00111^\u0014\u0002\rq\u0012xn\u001c;?\u0013\r\tyO_\u0001\u0007!J,G-\u001a4\n\t\u0005M\u0018Q\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005=(\u0010C\u0004\u0002z6\u0001\r!a8\u0002\u0015Q\f7o[*uCR,7\u000fC\u0004\u0002~6\u0001\r!a8\u0002\u0013Q\f7o\u001b+za\u0016\u001c\bb\u0002B\u0001\u001b\u0001\u0007!1A\u0001\nM\u0016$8\r['pI\u0016\u0004BA!\u0002\u0003\f5\u0011!q\u0001\u0006\u0004\u0005\u0013\t\u0014!C3yK\u000e,H/[8o\u0013\u0011\u0011iAa\u0002\u0003\u0013\u0019+Go\u00195N_\u0012,\u0007b\u0002B\t\u001b\u0001\u0007\u0011\u0011]\u0001\u0007i\u0006\u001c8.\u00133\t\u000f\tUQ\u00021\u0001\u0003\u0018\u0005qqN\u001c7z'V\u001c7-Z:tMVd\u0007cA=\u0003\u001a%\u0019!1\u0004>\u0003\u000f\t{w\u000e\\3b]\"9!qD\u0007A\u0002\u0005\u0005\u0018AC<pe.,'OT1nK\"9\u00111G\u0007A\u0002\u0005U\u0012!D4fiR\u000b7o\u001b*fa>\u0014H\u000f\u0006\u000e\u00022\n\u001d\"\u0011\u0006B\u0016\u0005[\u0011yC!\r\u00034\tU\"q\u0007B\u001d\u0005w\u0011i\u0004C\u0004\u0002<:\u0001\r!!0\t\u000f\u0005-g\u00021\u0001\u0002>\"9\u00111\u0010\bA\u0002\u0005\r\u0005bBAi\u001d\u0001\u0007\u00111\u001b\u0005\b\u0003;t\u0001\u0019AAp\u0011\u001d\tIP\u0004a\u0001\u0003?Dq!!@\u000f\u0001\u0004\ty\u000eC\u0004\u0003\u00029\u0001\rAa\u0001\t\u000f\tEa\u00021\u0001\u0002b\"9!Q\u0003\bA\u0002\t]\u0001b\u0002B\u0010\u001d\u0001\u0007\u0011\u0011\u001d\u0005\b\u0003gq\u0001\u0019AA\u001b\u0003I!wn\u001e8m_\u0006$G+Y:l%\u0016\u0004xN\u001d;\u0015-\u0005\u0005(1\tB#\u0005\u000f\u0012IEa\u0013\u0003N\t=#\u0011\u000bB*\u0005+Bq!a/\u0010\u0001\u0004\ti\fC\u0004\u0002L>\u0001\r!!0\t\u000f\u0005Ew\u00021\u0001\u0002T\"9\u0011Q\\\bA\u0002\u0005}\u0007bBA}\u001f\u0001\u0007\u0011q\u001c\u0005\b\u0003{|\u0001\u0019AAp\u0011\u001d\u0011\tb\u0004a\u0001\u0003CDqA!\u0006\u0010\u0001\u0004\u00119\u0002C\u0004\u0003 =\u0001\r!!9\t\u000f\u0005Mr\u00021\u0001\u00026!ZqB!\u0017\u0002&\n5$\u0011\u000fB:!\u0011\u0011YF!\u001b\u000e\u0005\tu#\u0002\u0002B0\u0005C\n!\"\u00198o_R\fG/[8o\u0015\u0011\u0011\u0019G!\u001a\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0004\u0005O\u0012\u0018aD:qe&twM\u001a:b[\u0016<xN]6\n\t\t-$Q\f\u0002\u000e)J\fgn]1di&|g.\u00197\"\u0005\t=\u0014a\u0007:fa>\u0014H/\u001b8h)J\fgn]1di&|g.T1oC\u001e,'/\u0001\u0005sK\u0006$wJ\u001c7z3\u0005\t\u0001fC\b\u0003x\t\u0005%1\u0011BD\u0005\u0013\u0003BA!\u001f\u0003~5\u0011!1\u0010\u0006\u0003_vIAAa \u0003|\t9qk\u001c:lI&\u0014\u0018A\u00029sK\u001aL\u00070\t\u0002\u0003\u0006\u0006AAm\\<oY>\fG-A\u0003dY\u0016\fg\u000e\n\u0002\u0003\f&!!Q\u0012BH\u0003\u0019\tEjV!Z'*!!\u0011\u0013BJ\u0003\u0015\u0019E.Z1o\u0015\u0011\u0011)Ja\u001f\u0002\u000f]{'o\u001b3je\u000692\u000f\u001e:fC6\u001cuN\u001c;s_2$\u0016m]6SKB|'\u000f\u001e\u000b\u0019\u00057\u0013\u0019K!*\u0003(\n-&q\u0016BY\u0005g\u0013)La.\u0003:\nm\u0006CBA-\u0003?\u0012i\n\u0005\u0003\u0002H\t}\u0015\u0002\u0002BQ\u0003\u0013\u0012QcQ8oiJ|G\u000eV1tWJ+\u0007o\u001c:u\u0019&tW\rC\u0004\u0002<B\u0001\r!!0\t\u000f\u0005-\u0007\u00031\u0001\u0002>\"9!\u0011\u0016\tA\u0002\u0005}\u0017AB:uCR,7\u000fC\u0004\u0003.B\u0001\r!!9\u0002\u0011Q\f7o\u001b(b[\u0016DqA!\u0001\u0011\u0001\u0004\u0011\u0019\u0001C\u0004\u0002^B\u0001\r!a8\t\u000f\u0005E\u0007\u00031\u0001\u0002T\"9!q\u0004\tA\u0002\u0005\u0005\bb\u0002B\t!\u0001\u0007\u0011\u0011\u001d\u0005\b\u0003w\u0002\u0002\u0019AA?\u0011\u001d\u0011i\f\u0005a\u0001\u0005\u007f\u000bq\u0001^1sO\u0016$8\u000f\u0005\u0004\u00028\t\u0005\u0017\u0011]\u0005\u0005\u0005\u0007\fIDA\u0002TKR\fQcZ3u\u0007>tGO]8m)\u0006\u001c8n\u001d*fa>\u0014H\u000f\u0006\r\u0003\u001c\n%'1\u001aBg\u0005\u001f\u0014\tNa5\u0003V\n]'\u0011\u001cBn\u0005;Dq!a/\u0012\u0001\u0004\ti\fC\u0004\u0002LF\u0001\r!!0\t\u000f\t%\u0016\u00031\u0001\u0002`\"9!QV\tA\u0002\u0005\u0005\bb\u0002B\u0001#\u0001\u0007!1\u0001\u0005\b\u0003;\f\u0002\u0019AAp\u0011\u001d\t\t.\u0005a\u0001\u0003'DqAa\b\u0012\u0001\u0004\t\t\u000fC\u0004\u0003\u0012E\u0001\r!!9\t\u000f\u0005m\u0014\u00031\u0001\u0002\u0004\"9!QX\tA\u0002\t}\u0016A\u00073po:dw.\u00193D_:$(o\u001c7UCN\\7OU3q_J$H\u0003FAq\u0005G\u0014)Oa:\u0003j\n-(Q\u001eBx\u0005c\u0014\u0019\u0010C\u0004\u0002<J\u0001\r!!0\t\u000f\u0005-'\u00031\u0001\u0002>\"9!\u0011\u0016\nA\u0002\u0005}\u0007b\u0002BW%\u0001\u0007\u0011\u0011\u001d\u0005\b\u0003;\u0014\u0002\u0019AAp\u0011\u001d\t\tN\u0005a\u0001\u0003'DqAa\b\u0013\u0001\u0004\t\t\u000fC\u0004\u0003\u0012I\u0001\r!!9\t\u000f\tu&\u00031\u0001\u0003@\"Z!C!\u0017\u0002&\n5$\u0011\u000fB:Q-\u0011\"q\u000fBA\u0005\u0007\u00139I!#\u0002/1L7\u000f^!mY\u000eK7o\u00144UsB,wI]8va\u0016$GC\u0002B\u007f\u0007'\u0019I\u0003\u0005\u0005\u0003\u0000\u000e%1QBAq\u001b\t\u0019\tA\u0003\u0003\u0004\u0004\r\u0015\u0011!C5n[V$\u0018M\u00197f\u0015\r\u00199A_\u0001\u000bG>dG.Z2uS>t\u0017\u0002BB\u0006\u0007\u0003\u00111!T1q!\u0011\tYja\u0004\n\t\rE\u0011Q\u0014\u0002\b\u0013:$XmZ3s\u0011\u001d\u0019)b\u0005a\u0001\u0007/\taaY5UsB,\u0007\u0003BB\r\u0007Ki!aa\u0007\u000b\t\ru1qD\u0001\be\u00164G.Z2u\u0015\ra2\u0011\u0005\u0006\u0004\u0007G\t\u0013A\u00029mk\u001eLg.\u0003\u0003\u0004(\rm!\u0001\u0002+za\u0016Dqaa\u000b\u0014\u0001\u0004\u0019i#\u0001\u0005hKRd\u0015MY3m!\u001dI\u0018qRB\u0018\u0003C\u00042aSB\u0019\u0013\r\u0019\u0019\u0004\u0014\u0002$\u0007>tg-[4ve\u0006$\u0018n\u001c8Ji\u0016lG)\u0019;b/&$\b.\u00138uKJt\u0017\r\\%e\u00035a\u0017n\u001d;UsB,\u0007+\u0019;igRA\u0011QGB\u001d\u0007\u0003\u001a\u0019\u0005C\u0004\u0004<Q\u0001\ra!\u0010\u0002\u0017\u0005\u00148\r[5wK\u0012\u001c\u0015n\u001d\t\t\u0003G\u001cyd!\u0004\u0002`&!11BA{\u0011\u001d\u0019Y\u0003\u0006a\u0001\u0007[Aqa!\u0006\u0015\u0001\u0004\u00199\"\u0001\tmSN$XI\u001c<je>tW.\u001a8ugR\u0011\u0011QG\u0001\u0011Y&\u001cH/\u00119qY&\u001c\u0017\r^5p]N\f1\u0003Z8x]2|\u0017\rZ!vI&$(+\u001a9peR$\"!!9)\u0017]\u0011I&!*\u0003n\tE$1\u000f\u0015\f/\t]$\u0011\u0011BB\u0005\u000f\u0013I\t\u0006\u0003\u0002b\u000eU\u0003bBB,1\u0001\u0007\u0011q\\\u0001\bM>dG-\u001a:tQ-A\"\u0011LAS\u0005[\u0012\tHa\u001d)\u0017a\u00119H!!\u0003\u0004\n\u001d%\u0011R\u0001\u0013aJ,g/[3x\u0003V$\u0017\u000e\u001e*fa>\u0014H\u000f\u0006\u0005\u0004b\r%41NB7!\u0019\tI&a\u0018\u0004dA!\u0011qIB3\u0013\u0011\u00199'!\u0013\u0003\u001f\u0005+H-\u001b;Qe\u00164\u0018.Z<S_^Dqaa\u0016\u001a\u0001\u0004\ty\u000eC\u0004\u0002Rf\u0001\r!a5\t\u000f\u0005m\u0014\u00041\u0001\u0002\u0004\"Z\u0011D!\u0017\u0002&\n5$\u0011\u000fB:Q\u001dI\"q\u000fBA\u0007g\n#a!\u001e\u0002\u000fA\u0014XM^5fo\"\u001a\u0001a!\u001f\u0011\t\rm4qQ\u0007\u0003\u0007{RAAa\u0018\u0004\u0000)!1\u0011QBB\u0003\u001d1\u0017m\u0019;pefTAa!\"\u0003f\u0005)!-Z1og&!1\u0011RB?\u0005%\tU\u000f^8xSJ,G\rK\u0002\u0001\u0007\u001b\u0003Baa$\u0004\u00166\u00111\u0011\u0013\u0006\u0005\u0007'\u0013)'\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAaa&\u0004\u0012\nQ1i\u001c8ue>dG.\u001a:")
public class ReportServiceImpl
extends AbstractSecuredResource
implements ReportService,
Logging {
    private final ReportGenerator reportGenerator;
    private final PaginationService paginationService;
    private final CiRepository ciRepository;
    private final TaskArchive taskArchive;
    private final DownloadResource downloadResource;
    @Context
    private HttpResponse response;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReportServiceImpl reportServiceImpl = this;
        synchronized (reportServiceImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private HttpResponse response() {
        return this.response;
    }

    private void response_$eq(HttpResponse x$1) {
        this.response = x$1;
    }

    public void setResponse(HttpResponse response) {
        this.response_$eq(response);
    }

    private void setCiFilters(ArchivedTaskSearchParameters searchParameters, java.util.List<ConfigurationItemId> configurationItemIds) {
        Tuple2<List<String>, List<String>> tuple2 = TaskFilterUtils$.MODULE$.parseCiFilters((List<ConfigurationItemId>)((List)Option$.MODULE$.apply(configurationItemIds).toList().flatten((Function1 & Serializable & scala.Serializable)l -> ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(l))));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List applications = (List)tuple2._1();
        List environments = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)applications, (Object)environments);
        Tuple2 tuple23 = tuple22;
        List applications2 = (List)tuple23._1();
        List environments2 = (List)tuple23._2();
        applications2.foreach((Function1 & Serializable & scala.Serializable)x$1 -> searchParameters.forApplication(x$1));
        environments2.foreach((Function1 & Serializable & scala.Serializable)x$1 -> searchParameters.forEnvironment(x$1));
    }

    private <T> Stream<T> streamReport(Option<Paging> paging, Function1<Paging, ArchivedTaskSearchParameters> buildParams, Function1<ArchivedTaskSearchParameters, Stream<T>> stream) {
        Option limited = paging.map((Function1 & Serializable & scala.Serializable)input -> $this.paginationService.getLimitedPaging((Paging)input));
        ArchivedTaskSearchParameters searchParameters = (ArchivedTaskSearchParameters)buildParams.apply(limited.getOrElse((Function0 & Serializable & scala.Serializable)() -> new Paging()));
        limited.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            this.paginationService.addPagingHeaderIfNeeded((Paging)paging.get(), x$2, this.paginationService.toSetHeader(this.response()), () -> Predef$.MODULE$.int2Integer($this.taskArchive.countTotalResults(searchParameters$2)));
            return BoxedUnit.UNIT;
        });
        return (Stream)stream.apply((Object)searchParameters);
    }

    private Stream<DeploymentTaskReportLine> streamDeploymentTaskReport(Date begin, Date end, Option<Paging> paging, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, java.util.List<String> users, java.util.List<String> taskStates, java.util.List<String> taskTypes, FetchMode fetchMode, String taskId, boolean onlySuccessful, String workerName, java.util.List<ConfigurationItemId> configurationItemIds) {
        return this.streamReport(paging, (Function1<Paging, ArchivedTaskSearchParameters>)(Function1 & Serializable & scala.Serializable)limited -> {
            ArchivedTaskSearchParameters params = $this.reportGenerator.buildFilteredTaskSearchParameters(begin, end, (Paging)limited, order, null, users, taskStates, taskTypes, fetchMode, taskId, ImplicitConversions$.MODULE$.seq$u0020AsJavaList((Seq)Nil$.MODULE$), ReportGenerator.DEPLOYMENT_ALLOWED_SORT_FIELDS, onlySuccessful, workerName);
            this.setCiFilters(params, configurationItemIds);
            return params;
        }, (Function1 & Serializable & scala.Serializable)searchParameters -> $this.reportGenerator.streamTaskReport((ArchivedTaskSearchParameters)searchParameters));
    }

    public Stream<DeploymentTaskReportLine> getTaskReport(Date begin, Date end, Paging paging, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, java.util.List<String> users, java.util.List<String> taskStates, java.util.List<String> taskTypes, FetchMode fetchMode, String taskId, boolean onlySuccessful, String workerName, java.util.List<ConfigurationItemId> configurationItemIds) {
        return this.streamDeploymentTaskReport(begin, end, (Option<Paging>)Option$.MODULE$.apply((Object)paging), order, users, taskStates, taskTypes, fetchMode, taskId, onlySuccessful, workerName, configurationItemIds);
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadTaskReport(Date begin, Date end, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, java.util.List<String> users, java.util.List<String> taskStates, java.util.List<String> taskTypes, String taskId, boolean onlySuccessful, String workerName, java.util.List<ConfigurationItemId> configurationItemIds) {
        Stream<ReportLine> stream = this.streamDeploymentTaskReport(begin, end, (Option<Paging>)None$.MODULE$, order, users, taskStates, taskTypes, FetchMode.SUMMARY, taskId, onlySuccessful, workerName, configurationItemIds).map(line -> DeploymentTaskReportLineConverter$.MODULE$.toReportLine((DeploymentTaskReportLine)line));
        String fileName = String.format("tasks-%s-%s.csv", ReportUtils.DATE_FORMAT.print((ReadableInstant)begin.asDateTime()), ReportUtils.DATE_FORMAT.print((ReadableInstant)end.asDateTime()));
        return ReportUtils.createDownloadToken(this.downloadResource, (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(DeploymentReportLineField$.MODULE$.allFields()).asJava(), stream, fileName);
    }

    private Stream<ControlTaskReportLine> streamControlTaskReport(Date begin, Date end, java.util.List<String> states, String taskName, FetchMode fetchMode, java.util.List<String> users, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, String workerName, String taskId, Option<Paging> paging, Set<String> targets) {
        return this.streamReport(paging, (Function1<Paging, ArchivedTaskSearchParameters>)(Function1 & Serializable & scala.Serializable)limited -> {
            ArchivedTaskSearchParameters params = $this.reportGenerator.buildTaskSearchParameters((Paging)limited, order, EnumSet.of(TaskType.CONTROL), ReportGenerator.CONTROL_ALLOWED_SORT_FIELDS);
            params.withTargets(targets);
            params.withTaskStates(states);
            params.withTaskName(taskName);
            params.withFetchMode(fetchMode);
            params.withWorkerName(workerName);
            params.inDateTimeRange($this.reportGenerator.safeDateTime(begin, null), $this.reportGenerator.safeDateTime(end, null));
            params.withUniqueId(taskId);
            Object object = users != null && ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(users).nonEmpty() ? params.forUsers((Set)Sets.newHashSet((Iterable)users)) : BoxedUnit.UNIT;
            return params;
        }, (Function1 & Serializable & scala.Serializable)searchParameters -> $this.reportGenerator.streamControlTasksReport((ArchivedTaskSearchParameters)searchParameters));
    }

    public Stream<ControlTaskReportLine> getControlTasksReport(Date begin, Date end, java.util.List<String> states, String taskName, FetchMode fetchMode, java.util.List<String> users, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, String workerName, String taskId, Paging paging, Set<String> targets) {
        return this.streamControlTaskReport(begin, end, states, taskName, fetchMode, users, order, workerName, taskId, (Option<Paging>)Option$.MODULE$.apply((Object)paging), targets);
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadControlTasksReport(Date begin, Date end, java.util.List<String> states, String taskName, java.util.List<String> users, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, String workerName, String taskId, Set<String> targets) {
        Stream<ReportLine> report = this.streamControlTaskReport(begin, end, states, taskName, FetchMode.SUMMARY, users, order, workerName, taskId, (Option<Paging>)None$.MODULE$, targets).map(line -> ControlTaskReportLineConverter$.MODULE$.toReportLine((ControlTaskReportLine)line));
        return ReportUtils.createDownloadToken(this.downloadResource, ImplicitConversions$.MODULE$.set$u0020AsJavaSet(ControlTaskReportLineField$.MODULE$.allFields()), report, this.reportGenerator.buildControlTaskReportFileName(begin, end));
    }

    private Map<Integer, String> listAllCisOfTypeGrouped(Type ciType, Function1<ConfigurationItemDataWithInternalId, String> getLabel) {
        SearchParameters params = SearchParametersFactory.createSearchParams((Type)ciType, (long)0L, (long)-1L);
        PlatformPermissions.READ.getPermissionHandler().applyPermission(params);
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.ciRepository.listInternal(params)).asScala()).map((Function1 & Serializable & scala.Serializable)item -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)item.internalId()), getLabel.apply(item)), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private java.util.List<ConfigurationItemId> listTypePaths(Map<Integer, java.util.List<String>> archivedCis, Function1<ConfigurationItemDataWithInternalId, String> getLabel, Type ciType) {
        List list;
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        Map<Integer, String> cisInRepository = this.listAllCisOfTypeGrouped(ciType, getLabel);
        scala.collection.immutable.Set matchedIds = (scala.collection.immutable.Set)archivedCis.keySet().intersect((GenSet)cisInRepository.keySet());
        List onlyInArchive = ((TraversableOnce)archivedCis.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Integer id = (Integer)tuple2._1();
            java.util.List paths = (java.util.List)tuple2._2();
            Nil$ nil$ = matchedIds.contains((Object)id) ? (Seq)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(paths).filter((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)ReportServiceImpl.$anonfun$listTypePaths$2(cisInRepository, id, path))) : Nil$.MODULE$;
            return nil$;
        }, Iterable$.MODULE$.canBuildFrom())).toList();
        List list2 = cisInRepository.values().toList();
        List inArchiveAndRepository = onlyInArchive.$colon$colon$colon(list2);
        if (this.hasPermission(PlatformPermissions.REPORT_VIEW)) {
            List list3 = inArchiveAndRepository;
            list = ((TraversableOnce)archivedCis.filterKeys((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)ReportServiceImpl.$anonfun$listTypePaths$3(cisInRepository, id))).values().flatten((Function1 & Serializable & scala.Serializable)l -> ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(l))).toList().$colon$colon$colon(list3);
        } else {
            list = inArchiveAndRepository;
        }
        List result = list;
        return ImplicitConversions$.MODULE$.seq$u0020AsJavaList((Seq)((List)((SeqLike)result.distinct()).sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$5 -> new ConfigurationItemId(x$5, ciType), List$.MODULE$.canBuildFrom()));
    }

    public java.util.List<ConfigurationItemId> listEnvironments() {
        return this.listTypePaths((Map<Integer, java.util.List<String>>)ImplicitConversions$.MODULE$.map$u0020AsScala(this.reportGenerator.getEnvironments()).toMap(Predef$.MODULE$.$conforms()), (Function1<ConfigurationItemDataWithInternalId, String>)(Function1 & Serializable & scala.Serializable)x$6 -> x$6.id(), Type.valueOf(Environment.class));
    }

    public java.util.List<ConfigurationItemId> listApplications() {
        return this.listTypePaths((Map<Integer, java.util.List<String>>)ImplicitConversions$.MODULE$.map$u0020AsScala(this.reportGenerator.getApplications()).toMap(Predef$.MODULE$.$conforms()), (Function1<ConfigurationItemDataWithInternalId, String>)(Function1 & Serializable & scala.Serializable)x$7 -> x$7.name(), Type.valueOf(Application.class));
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadAuditReport() {
        return this.reportGenerator.generateAuditReport(Collections.emptyList(), this.downloadResource);
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadAuditReport(java.util.List<String> folders) {
        return this.reportGenerator.generateAuditReport(folders, this.downloadResource);
    }

    @Workdir(prefix="preview")
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public Stream<AuditPreviewRow> previewAuditReport(java.util.List<String> folders, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, Paging paging) {
        AuditPreviewReport previewReport = this.reportGenerator.previewAuditReport(folders, order, paging);
        Paging limited = this.paginationService.getLimitedPaging(paging);
        this.paginationService.addPagingHeaderIfNeeded(paging, limited, this.paginationService.toSetHeader(this.response()), () -> previewReport.total());
        return previewReport.currentPageData().stream();
    }

    public static final /* synthetic */ boolean $anonfun$listTypePaths$2(Map cisInRepository$1, Integer id$1, String path) {
        Object object = cisInRepository$1.apply((Object)id$1);
        String string = path;
        return object == null ? string != null : !object.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$listTypePaths$3(Map cisInRepository$1, Integer id) {
        return !cisInRepository$1.keySet().contains((Object)id);
    }

    public ReportServiceImpl(ReportGenerator reportGenerator, PaginationService paginationService, CiRepository ciRepository, TaskArchive taskArchive, DownloadResource downloadResource) {
        this.reportGenerator = reportGenerator;
        this.paginationService = paginationService;
        this.ciRepository = ciRepository;
        this.taskArchive = taskArchive;
        this.downloadResource = downloadResource;
        Logging.$init$((Logging)this);
    }
}

