/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.json;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.springframework.stereotype.Component;

@Component
@Provider
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class MethodDescriptorJsonWriter
implements MessageBodyWriter<MethodDescriptor> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MethodDescriptor.class.isAssignableFrom(type);
    }

    public long getSize(MethodDescriptor methodDescriptor, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(MethodDescriptor methodDescriptor, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(this.toJson(methodDescriptor).getBytes());
    }

    @VisibleForTesting
    String toJson(MethodDescriptor methodDescriptor) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter((Writer)stringWriter);
        MethodDescriptorJsonWriter.writeJson(methodDescriptor, writer);
        return stringWriter.toString();
    }

    static void writeJson(MethodDescriptor methodDescriptor, JsonWriter writer) {
        writer.object();
        writer.key("name").value((Object)methodDescriptor.getName());
        writer.key("fqn").value((Object)methodDescriptor.getFqn());
        writer.key("description").value((Object)methodDescriptor.getDescription());
        writer.key("label").value((Object)methodDescriptor.getLabel());
        writer.endObject();
    }
}

