/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.json;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.springframework.stereotype.Component;

@Component
@Provider
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class MapStringSetStringJsonWriter
implements MessageBodyWriter<Map<String, Set<String>>> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (mediaType.toString().contains("application/json") && Map.class.isAssignableFrom(type) && genericType instanceof ParameterizedType) {
            Type[] types = ((ParameterizedType)genericType).getActualTypeArguments();
            Class typeKey = (Class)types[0];
            if (types[1] instanceof ParameterizedType) {
                ParameterizedType parametrizedTypeValue = (ParameterizedType)types[1];
                Class typeValue = (Class)parametrizedTypeValue.getRawType();
                Type typeValueItem = parametrizedTypeValue.getActualTypeArguments()[0];
                return String.class.isAssignableFrom(typeKey) && Set.class.isAssignableFrom(typeValue) && typeValueItem instanceof Class && String.class.isAssignableFrom((Class)typeValueItem);
            }
        }
        return false;
    }

    public long getSize(Map<String, Set<String>> map, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Map<String, Set<String>> map, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(this.toJson(map).getBytes());
    }

    @VisibleForTesting
    String toJson(Map<String, Set<String>> map) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter((Writer)stringWriter);
        writer.object();
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            writer.key(entry.getKey());
            writer.array();
            for (String descriptor : entry.getValue()) {
                writer.value((Object)descriptor);
            }
            writer.endArray();
        }
        writer.endObject();
        return stringWriter.toString();
    }
}

