/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.SessionService;
import com.xebialabs.deployit.core.api.dto.ActiveUserSession;
import com.xebialabs.deployit.core.api.dto.UserSessionsOverview;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.core.service.PaginationService;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.tasker.IEngine;
import com.xebialabs.deployit.repository.XldSessionRepository;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import java.io.Serializable;
import java.util.List;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Option$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001B\u0005\u000b\u0001]A\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tU\u0001\u0011\t\u0011)A\u0005W!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007C\u0003:\u0001\u0011\u0005!\bC\u0004A\u0001\t\u0007I\u0011A!\t\r9\u0003\u0001\u0015!\u0003C\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u001d\ty\u0001\u0001C!\u0003#\u0011!cU3tg&|gnU3sm&\u001cW-S7qY*\u00111\u0002D\u0001\u0004CBL'BA\u0007\u000f\u0003\u0011\u0011Xm\u001d;\u000b\u0005=\u0001\u0012\u0001B2pe\u0016T!!\u0005\n\u0002\u0011\u0011,\u0007\u000f\\8zSRT!a\u0005\u000b\u0002\u0013a,'-[1mC\n\u001c(\"A\u000b\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001Ab\u0004\u0005\u0002\u001a95\t!D\u0003\u0002\u001c\u0019\u000591/Z2ve\u0016$\u0017BA\u000f\u001b\u0005]\t%m\u001d;sC\u000e$8+Z2ve\u0016$'+Z:pkJ\u001cW\r\u0005\u0002 C5\t\u0001E\u0003\u0002\f\u001d%\u0011!\u0005\t\u0002\u000f'\u0016\u001c8/[8o'\u0016\u0014h/[2f\u0003QAH\u000eZ*fgNLwN\u001c*fa>\u001c\u0018\u000e^8ssB\u0011Q\u0005K\u0007\u0002M)\u0011q\u0005E\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA\u0015'\u0005QAF\u000eZ*fgNLwN\u001c*fa>\u001c\u0018\u000e^8ss\u0006\t\u0002/Y4j]\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0011\u00051zS\"A\u0017\u000b\u00059r\u0011aB:feZL7-Z\u0005\u0003a5\u0012\u0011\u0003U1hS:\fG/[8o'\u0016\u0014h/[2f\u0003\u0019)gnZ5oKB\u00111gN\u0007\u0002i)\u0011QGN\u0001\u0007i\u0006\u001c8.\u001a:\u000b\u0005E\u0002\u0012B\u0001\u001d5\u0005\u001dIUI\\4j]\u0016\fa\u0001P5oSRtD\u0003B\u001e>}}\u0002\"\u0001\u0010\u0001\u000e\u0003)AQa\t\u0003A\u0002\u0011BQA\u000b\u0003A\u0002-BQ!\r\u0003A\u0002I\n\u0001B]3ta>t7/Z\u000b\u0002\u0005B\u00111\tT\u0007\u0002\t*\u0011QIR\u0001\u0004gBL'BA$I\u0003!\u0011Xm\u001d;fCNL(BA%K\u0003\u0015Q'm\\:t\u0015\u0005Y\u0015aA8sO&\u0011Q\n\u0012\u0002\r\u0011R$\bOU3ta>t7/Z\u0001\ne\u0016\u001c\bo\u001c8tK\u0002B#A\u0002)\u0011\u0005EKV\"\u0001*\u000b\u0005=\u0019&B\u0001+V\u0003\t\u00118O\u0003\u0002W/\u0006\u0011qo\u001d\u0006\u00021\u0006)!.\u0019<bq&\u0011!L\u0015\u0002\b\u0007>tG/\u001a=u\u0003E9W\r^!di&4XmU3tg&|gn\u001d\u000b\u0006;.T\u0018Q\u0001\t\u0004=\u000e,W\"A0\u000b\u0005\u0001\f\u0017\u0001B;uS2T\u0011AY\u0001\u0005U\u00064\u0018-\u0003\u0002e?\n!A*[:u!\t1\u0017.D\u0001h\u0015\tA\u0007%A\u0002ei>L!A[4\u0003#\u0005\u001bG/\u001b<f+N,'oU3tg&|g\u000eC\u0003m\u000f\u0001\u0007Q.\u0001\tqe&t7-\u001b9bYB\u000bG\u000f^3s]B\u0011an\u001e\b\u0003_V\u0004\"\u0001]:\u000e\u0003ET!A\u001d\f\u0002\rq\u0012xn\u001c;?\u0015\u0005!\u0018!B:dC2\f\u0017B\u0001<t\u0003\u0019\u0001&/\u001a3fM&\u0011\u00010\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Y\u001c\b\"B>\b\u0001\u0004a\u0018A\u00029bO&tw\rE\u0002~\u0003\u0003i\u0011A \u0006\u0003Q~T!a\u0003\u001c\n\u0007\u0005\raP\u0001\u0004QC\u001eLgn\u001a\u0005\b\u0003\u000f9\u0001\u0019AA\u0005\u0003\u0015y'\u000fZ3s!\ri\u00181B\u0005\u0004\u0003\u001bq(\u0001C(sI\u0016\u0014\u0018N\\4\u0002'\u001d,GoU3tg&|gn](wKJ4\u0018.Z<\u0015\u0005\u0005M\u0001c\u00014\u0002\u0016%\u0019\u0011qC4\u0003)U\u001bXM]*fgNLwN\\:Pm\u0016\u0014h/[3xQ\r\u0001\u00111\u0004\t\u0005\u0003;\t9#\u0004\u0002\u0002 )!\u0011\u0011EA\u0012\u0003)\u0019H/\u001a:f_RL\b/\u001a\u0006\u0004\u0003KQ\u0015aD:qe&twM\u001a:b[\u0016<xN]6\n\t\u0005%\u0012q\u0004\u0002\b'\u0016\u0014h/[2f\u0001")
public class SessionServiceImpl
extends AbstractSecuredResource
implements SessionService {
    private final XldSessionRepository xldSessionRepository;
    private final PaginationService paginationService;
    @Context
    private final HttpResponse response;

    public HttpResponse response() {
        return this.response;
    }

    public List<ActiveUserSession> getActiveSessions(String principalPattern, Paging paging, Ordering order) {
        this.checkPermissions(new Permission[]{PlatformPermissions.EDIT_SECURITY, PlatformPermissions.VIEW_SECURITY});
        String principalPatternOption = (String)Option$.MODULE$.apply((Object)principalPattern).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        this.paginationService.addPagingHeaderIfNeeded(this.paginationService.toSetHeader(this.response()), () -> $this.xldSessionRepository.count(principalPatternOption), paging);
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.xldSessionRepository.findAll(principalPatternOption, paging, order)).asJava();
    }

    public UserSessionsOverview getSessionsOverview() {
        this.checkPermissions(new Permission[]{PlatformPermissions.EDIT_SECURITY, PlatformPermissions.VIEW_SECURITY});
        return this.xldSessionRepository.getSessionSummary();
    }

    public SessionServiceImpl(XldSessionRepository xldSessionRepository, PaginationService paginationService, IEngine engine) {
        this.xldSessionRepository = xldSessionRepository;
        this.paginationService = paginationService;
        this.response = null;
    }
}

