/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.auth;

import com.xebialabs.deployit.core.sql.SqlDialect;
import java.util.Date;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.support.JdbcDaoSupport;
import org.springframework.security.web.authentication.rememberme.PersistentRememberMeToken;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@Component
@Transactional(value="reportingTransactionManager")
@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001B\u0001\u0003\u0001-\u0011QD\u00133cGJ+W.Z7cKJlU\rV8lK:\u0014V\r]8tSR|'/\u001f\u0006\u0003\u0007\u0011\tA!Y;uQ*\u0011QAB\u0001\tq2$W\r\u001d7ps*\u0011q\u0001C\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!C\u0001\u0004G>l7\u0001A\n\u0004\u00011Q\u0002CA\u0007\u0019\u001b\u0005q!BA\b\u0011\u0003\u001d\u0019X\u000f\u001d9peRT!!\u0005\n\u0002\t\r|'/\u001a\u0006\u0003'Q\tAA\u001b3cG*\u0011QCF\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tq#A\u0002pe\u001eL!!\u0007\b\u0003\u001d)#'m\u0019#b_N+\b\u000f]8siB\u00111\u0004J\u0007\u00029)\u0011QDH\u0001\u000be\u0016lW-\u001c2fe6,'BA\u0010!\u00039\tW\u000f\u001e5f]RL7-\u0019;j_:T!!\t\u0012\u0002\u0007],'M\u0003\u0002$)\u0005A1/Z2ve&$\u00180\u0003\u0002&9\tI\u0002+\u001a:tSN$XM\u001c;U_.,gNU3q_NLGo\u001c:z\u0011!9\u0003A!b\u0001\n\u0003A\u0013A\u00033bi\u0006\u001cv.\u001e:dKV\t\u0011\u0006\u0005\u0002+_5\t1F\u0003\u0002-[\u0005\u00191/\u001d7\u000b\u00039\nQA[1wCbL!\u0001M\u0016\u0003\u0015\u0011\u000bG/Y*pkJ\u001cW\r\u0003\u00053\u0001\t\u0005\t\u0015!\u0003*\u0003-!\u0017\r^1T_V\u00148-\u001a\u0011\t\u0011Q\u0002!Q1A\u0005\u0002U\nq\u0001Z5bY\u0016\u001cG/F\u00017!\t9D(D\u00019\u0015\ta\u0013H\u0003\u0002\u0012u)\u00111HB\u0001\tI\u0016\u0004Hn\\=ji&\u0011Q\b\u000f\u0002\u000b'FdG)[1mK\u000e$\b\u0002C \u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c\u0002\u0011\u0011L\u0017\r\\3di\u0002BQ!\u0011\u0001\u0005\u0002\t\u000ba\u0001P5oSRtDcA\"F)B\u0011A\tA\u0007\u0002\u0005!)q\u0005\u0011a\u0001S!\"QiR)S!\tAu*D\u0001J\u0015\tQ5*\u0001\u0006b]:|G/\u0019;j_:T!\u0001T'\u0002\u000f\u0019\f7\r^8ss*\u0011a\nF\u0001\u0006E\u0016\fgn]\u0005\u0003!&\u0013\u0011\"U;bY&4\u0017.\u001a:\u0002\u000bY\fG.^3\"\u0003M\u000b1C]3q_J$\u0018N\\4ECR\f7k\\;sG\u0016DQ\u0001\u000e!A\u0002YBC\u0001V$R-\u0006\nq+A\nsKB|'\u000f^5oON\u000bH\u000eR5bY\u0016\u001cG\u000f\u000b\u0002A3B\u0011\u0001JW\u0005\u00037&\u0013\u0011\"Q;u_^L'/\u001a3\t\u000bu\u0003A\u0011\t0\u0002\u0017U\u0004H-\u0019;f)>\\WM\u001c\u000b\u0005?\u0016\u0014H\u000f\u0005\u0002aG6\t\u0011MC\u0001c\u0003\u0015\u00198-\u00197b\u0013\t!\u0017M\u0001\u0003V]&$\b\"\u00024]\u0001\u00049\u0017AB:fe&,7\u000f\u0005\u0002i_:\u0011\u0011.\u001c\t\u0003U\u0006l\u0011a\u001b\u0006\u0003Y*\ta\u0001\u0010:p_Rt\u0014B\u00018b\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001/\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059\f\u0007\"B:]\u0001\u00049\u0017A\u0003;pW\u0016tg+\u00197vK\")Q\u000f\u0018a\u0001m\u0006AA.Y:u+N,G\r\u0005\u0002xy6\t\u0001P\u0003\u0002zu\u0006!Q\u000f^5m\u0015\u0005Y\u0018\u0001\u00026bm\u0006L!! =\u0003\t\u0011\u000bG/\u001a\u0005\u0007\u007f\u0002!\t%!\u0001\u0002#\u001d,G\u000fV8lK:4uN]*fe&,7\u000f\u0006\u0003\u0002\u0004\u0005%\u0001cA\u000e\u0002\u0006%\u0019\u0011q\u0001\u000f\u00033A+'o]5ti\u0016tGOU3nK6\u0014WM]'f)>\\WM\u001c\u0005\u0007\u0003\u0017q\b\u0019A4\u0002\u0011M,'/[3t\u0013\u0012Dq!a\u0004\u0001\t\u0003\n\t\"\u0001\bde\u0016\fG/\u001a(foR{7.\u001a8\u0015\u0007}\u000b\u0019\u0002\u0003\u0005\u0002\u0016\u00055\u0001\u0019AA\u0002\u0003\u0015!xn[3o\u0011\u001d\tI\u0002\u0001C!\u00037\t\u0001C]3n_Z,Wk]3s)>\\WM\\:\u0015\u0007}\u000bi\u0002C\u0004\u0002 \u0005]\u0001\u0019A4\u0002\u0011U\u001cXM\u001d8b[\u0016D\u0011\"a\t\u0001\u0005\u0004%I!!\n\u0002#A,'o]5ti\u0016tGo\u00187pO&t7/F\u0001h\u0011\u001d\tI\u0003\u0001Q\u0001\n\u001d\f!\u0003]3sg&\u001cH/\u001a8u?2|w-\u001b8tA!I\u0011Q\u0003\u0001C\u0002\u0013%\u0011Q\u0005\u0005\b\u0003_\u0001\u0001\u0015!\u0003h\u0003\u0019!xn[3oA!I\u00111\u0007\u0001C\u0002\u0013%\u0011QE\u0001\nY\u0006\u001cHoX;tK\u0012Dq!a\u000e\u0001A\u0003%q-\u0001\u0006mCN$x,^:fI\u0002B\u0001B\u001a\u0001C\u0002\u0013%\u0011Q\u0005\u0005\b\u0003{\u0001\u0001\u0015!\u0003h\u0003\u001d\u0019XM]5fg\u0002B\u0011\"a\b\u0001\u0005\u0004%I!!\n\t\u000f\u0005\r\u0003\u0001)A\u0005O\u0006IQo]3s]\u0006lW\r\t\u0005\n\u0003\u000f\u0002!\u0019!C\u0005\u0003K\tA\"\u0016)E\u0003R+u\fV(L\u000b:Cq!a\u0013\u0001A\u0003%q-A\u0007V!\u0012\u000bE+R0U\u001f.+e\n\t\u0005\n\u0003\u001f\u0002!\u0019!C\u0005\u0003K\tAb\u0011*F\u0003R+u\fV(L\u000b:Cq!a\u0015\u0001A\u0003%q-A\u0007D%\u0016\u000bE+R0U\u001f.+e\n\t\u0005\n\u0003/\u0002!\u0019!C\u0005\u0003K\tA\u0002R#M\u000bR+u\fV(L\u000b:Cq!a\u0017\u0001A\u0003%q-A\u0007E\u000b2+E+R0U\u001f.+e\n\t\u0005\n\u0003?\u0002!\u0019!C\u0005\u0003K\tq\u0002V(L\u000b:{&)W0T\u000bJKUi\u0015\u0005\b\u0003G\u0002\u0001\u0015!\u0003h\u0003A!vjS#O?\nKvlU#S\u0013\u0016\u001b\u0006\u0005\u000b\u0004\u0001\u0003O\n\u0016Q\u000f\t\u0005\u0003S\n\t(\u0004\u0002\u0002l)\u0019!*!\u001c\u000b\u0007\u0005=D#A\u0006ue\u0006t7/Y2uS>t\u0017\u0002BA:\u0003W\u0012Q\u0002\u0016:b]N\f7\r^5p]\u0006d\u0017EAA<\u0003m\u0011X\r]8si&tw\r\u0016:b]N\f7\r^5p]6\u000bg.Y4fe\"\u001a\u0001!a\u001f\u0011\t\u0005u\u00141Q\u0007\u0003\u0003\u007fR1!!!\u0015\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003\u000b\u000byHA\u0005D_6\u0004xN\\3oi\u0002")
public class JdbcRememberMeTokenRepository
extends JdbcDaoSupport
implements PersistentTokenRepository {
    private final DataSource dataSource;
    private final SqlDialect dialect;
    private final String persistent_logins;
    private final String token;
    private final String last_used;
    private final String series;
    private final String username;
    private final String UPDATE_TOKEN;
    private final String CREATE_TOKEN;
    private final String DELETE_TOKEN;
    private final String TOKEN_BY_SERIES;

    public DataSource dataSource() {
        return this.dataSource;
    }

    public SqlDialect dialect() {
        return this.dialect;
    }

    public void updateToken(String series, String tokenValue, Date lastUsed) {
        this.getJdbcTemplate().update(this.UPDATE_TOKEN(), new Object[]{tokenValue, lastUsed, series});
    }

    public PersistentRememberMeToken getTokenForSeries(String seriesId) {
        try {
            return (PersistentRememberMeToken)this.getJdbcTemplate().queryForObject(this.TOKEN_BY_SERIES(), (rs, rowNum) -> new PersistentRememberMeToken(rs.getString(1), rs.getString(2), rs.getString(3), (Date)rs.getTimestamp(4)), new Object[]{seriesId});
        }
        catch (EmptyResultDataAccessException zeroResults) {
            this.logger.debug((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Querying token for series '", "' returned no results."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{seriesId})), (Throwable)zeroResults);
        }
        catch (IncorrectResultSizeDataAccessException moreThanOne) {
            this.logger.error((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Querying token for series '", "' returned more than one value. Series should be unique"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{seriesId})));
        }
        catch (DataAccessException e) {
            this.logger.error((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to load token for series ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{seriesId})), (Throwable)e);
        }
        return null;
    }

    public void createNewToken(PersistentRememberMeToken token) {
        this.getJdbcTemplate().update(this.CREATE_TOKEN(), new Object[]{token.getUsername(), token.getSeries(), token.getTokenValue(), token.getDate()});
    }

    public void removeUserTokens(String username) {
        this.getJdbcTemplate().update(this.DELETE_TOKEN(), new Object[]{username});
    }

    private String persistent_logins() {
        return this.persistent_logins;
    }

    private String token() {
        return this.token;
    }

    private String last_used() {
        return this.last_used;
    }

    private String series() {
        return this.series;
    }

    private String username() {
        return this.username;
    }

    private String UPDATE_TOKEN() {
        return this.UPDATE_TOKEN;
    }

    private String CREATE_TOKEN() {
        return this.CREATE_TOKEN;
    }

    private String DELETE_TOKEN() {
        return this.DELETE_TOKEN;
    }

    private String TOKEN_BY_SERIES() {
        return this.TOKEN_BY_SERIES;
    }

    @Autowired
    public JdbcRememberMeTokenRepository(@Qualifier(value="reportingDataSource") DataSource dataSource, @Qualifier(value="reportingSqlDialect") SqlDialect dialect) {
        this.dataSource = dataSource;
        this.dialect = dialect;
        super.setDataSource(dataSource);
        this.persistent_logins = dialect.quote("PERSISTENT_LOGINS");
        this.token = dialect.quote("token");
        this.last_used = dialect.quote("last_used");
        this.series = dialect.quote("series");
        this.username = dialect.quote("username");
        this.UPDATE_TOKEN = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"update ", " set ", " = ?, ", " = ? where ", " = ?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.persistent_logins(), this.token(), this.last_used(), this.series()}));
        this.CREATE_TOKEN = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"insert into ", " (", ", ", ", ", ", ", ") values(?,?,?,?)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.persistent_logins(), this.username(), this.series(), this.token(), this.last_used()}));
        this.DELETE_TOKEN = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"delete from ", " where ", " = ?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.persistent_logins(), this.username()}));
        this.TOKEN_BY_SERIES = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select ", ", ", ", ", ", ", " from ", " where ", " = ?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.username(), this.series(), this.token(), this.last_used(), this.persistent_logins(), this.series()}));
    }
}

