/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.auth.config;

import ai.digital.deploy.settings.GeneralSettings;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.core.service.GeneralSettingsService;
import com.xebialabs.deployit.core.util.TokenGenerator$;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.User;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.authentication.AuthenticationFailureException;
import com.xebialabs.deployit.security.authentication.PersonalAuthenticationToken;
import com.xebialabs.deployit.security.model.Tokens;
import com.xebialabs.deployit.security.model.XldUserToken;
import com.xebialabs.deployit.security.principaldata.PrincipalDataProvider;
import com.xebialabs.deployit.security.principaldata.UserData;
import com.xebialabs.deployit.security.service.UserGroupService;
import com.xebialabs.deployit.security.service.UserTokenService;
import com.xebialabs.xldeploy.auth.TokenExpiredException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.NullAuthoritiesMapper;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component(value="xlAuthenticationProvider")
@ScalaSignature(bytes="\u0006\u0005\u0005ue\u0001B\n\u0015\u0001}A\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A1\t\u0001B\u0001B\u0003%A\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011!q\u0005A!A!\u0002\u0013y\u0005\"\u0002,\u0001\t\u00039\u0006bB0\u0001\u0005\u0004%I\u0001\u0019\u0005\u0007O\u0002\u0001\u000b\u0011B1\t\u000f!\u0004\u0001\u0019!C\u0005S\"91\u000f\u0001a\u0001\n\u0013!\bBB?\u0001A\u0003&!\u000eC\u0003\u007f\u0001\u0011\u0005s\u0010C\u0004\u0002\u000e\u0001!I!a\u0004\t\u000f\u0005%\u0002\u0001\"\u0003\u0002,!9\u0011Q\u0007\u0001\u0005B\u0005]\u0002bBA0\u0001\u0011%\u0011\u0011\r\u0005\u0007\u0003\u0003\u0003A\u0011A5\t\u000f\u0005\r\u0005\u0001\"\u0001\u0002\u0006\naB)\u001a9m_f\fU\u000f\u001e5f]RL7-\u0019;j_:\u0004&o\u001c<jI\u0016\u0014(BA\u000b\u0017\u0003\u0019\u0019wN\u001c4jO*\u0011q\u0003G\u0001\u0005CV$\bN\u0003\u0002\u001a5\u0005A\u0001\u0010\u001c3fa2|\u0017P\u0003\u0002\u001c9\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002;\u0005\u00191m\\7\u0004\u0001M\u0019\u0001\u0001\t\u0015\u0011\u0005\u00052S\"\u0001\u0012\u000b\u0005\r\"\u0013\u0001\u00027b]\u001eT\u0011!J\u0001\u0005U\u00064\u0018-\u0003\u0002(E\t1qJ\u00196fGR\u0004\"!\u000b\u001a\u000e\u0003)R!a\u000b\u0017\u0002\u001d\u0005,H\u000f[3oi&\u001c\u0017\r^5p]*\u0011QFL\u0001\tg\u0016\u001cWO]5us*\u0011q\u0006M\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0011'A\u0002pe\u001eL!a\r\u0016\u0003-\u0005+H\u000f[3oi&\u001c\u0017\r^5p]B\u0013xN^5eKJ\f1\"^:feN+'O^5dKB\u0011aGO\u0007\u0002o)\u0011Q\u0006\u000f\u0006\u0003si\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003w]\u00121\"V:feN+'O^5dK\u0006\u0001Ro]3s)>\\WM\\*feZL7-\u001a\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001^\nqa]3sm&\u001cW-\u0003\u0002C\u007f\t\u0001Rk]3s)>\\WM\\*feZL7-Z\u0001\u0016aJLgnY5qC2$\u0015\r^1Qe>4\u0018\u000eZ3s!\t)\u0005*D\u0001G\u0015\t9u'A\u0007qe&t7-\u001b9bY\u0012\fG/Y\u0005\u0003\u0013\u001a\u0013Q\u0003\u0015:j]\u000eL\u0007/\u00197ECR\f\u0007K]8wS\u0012,'/\u0001\tvg\u0016\u0014xI]8vaN+'O^5dKB\u0011a\bT\u0005\u0003\u001b~\u0012\u0001#V:fe\u001e\u0013x.\u001e9TKJ4\u0018nY3\u0002-\u001d,g.\u001a:bYN+G\u000f^5oON\u001cVM\u001d<jG\u0016\u0004\"\u0001\u0015+\u000e\u0003ES!\u0001\u0011*\u000b\u0005MC\u0014\u0001B2pe\u0016L!!V)\u0003-\u001d+g.\u001a:bYN+G\u000f^5oON\u001cVM\u001d<jG\u0016\fa\u0001P5oSRtDC\u0002-[7rkf\f\u0005\u0002Z\u00015\tA\u0003C\u00035\r\u0001\u0007Q\u0007C\u0003=\r\u0001\u0007Q\bC\u0003D\r\u0001\u0007A\tC\u0003K\r\u0001\u00071\nC\u0003O\r\u0001\u0007q*\u0001\u0004m_\u001e<WM]\u000b\u0002CB\u0011!-Z\u0007\u0002G*\u0011A\rM\u0001\u0006g24GG[\u0005\u0003M\u000e\u0014a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u0012CV$\bn\u001c:ji&,7/T1qa\u0016\u0014X#\u00016\u0011\u0005-\fX\"\u00017\u000b\u00055t\u0017aB7baBLgn\u001a\u0006\u0003_B\f\u0011\"Y;uQ>\u0014\u0018\u000e^=\u000b\u0005Mc\u0013B\u0001:m\u0005a9%/\u00198uK\u0012\fU\u000f\u001e5pe&$\u0018.Z:NCB\u0004XM]\u0001\u0016CV$\bn\u001c:ji&,7/T1qa\u0016\u0014x\fJ3r)\t)8\u0010\u0005\u0002ws6\tqOC\u0001y\u0003\u0015\u00198-\u00197b\u0013\tQxO\u0001\u0003V]&$\bb\u0002?\u000b\u0003\u0003\u0005\rA[\u0001\u0004q\u0012\n\u0014AE1vi\"|'/\u001b;jKNl\u0015\r\u001d9fe\u0002\nA\"Y;uQ\u0016tG/[2bi\u0016$B!!\u0001\u0002\nA!\u00111AA\u0003\u001b\u0005\u0001\u0018bAA\u0004a\nq\u0011)\u001e;iK:$\u0018nY1uS>t\u0007bBA\u0006\u0019\u0001\u0007\u0011\u0011A\u0001\u0006i>\\WM\\\u0001\u001aCV$\b.\u001a8uS\u000e\fG/\u001a$s_6,6/\u001a:U_.,g\u000e\u0006\u0003\u0002\u0002\u0005E\u0001bBA\u0006\u001b\u0001\u0007\u00111\u0003\t\u0005\u0003+\t\u0019C\u0004\u0003\u0002\u0018\u0005}\u0001cAA\ro6\u0011\u00111\u0004\u0006\u0004\u0003;q\u0012A\u0002\u001fs_>$h(C\u0002\u0002\"]\fa\u0001\u0015:fI\u00164\u0017\u0002BA\u0013\u0003O\u0011aa\u0015;sS:<'bAA\u0011o\u0006Y\u0012-\u001e;iK:$\u0018nY1uK\u001a\u0013x.\\\"sK\u0012,g\u000e^5bYN$b!!\u0001\u0002.\u0005E\u0002bBA\u0018\u001d\u0001\u0007\u00111C\u0001\tkN,'O\\1nK\"9\u00111\u0007\bA\u0002\u0005M\u0011\u0001\u00039bgN<xN\u001d3\u0002\u0011M,\b\u000f]8siN$B!!\u000f\u0002@A\u0019a/a\u000f\n\u0007\u0005urOA\u0004C_>dW-\u00198\t\r-z\u0001\u0019AA!a\u0011\t\u0019%!\u0014\u0011\r\u0005U\u0011QIA%\u0013\u0011\t9%a\n\u0003\u000b\rc\u0017m]:\u0011\t\u0005-\u0013Q\n\u0007\u0001\t1\ty%a\u0010\u0002\u0002\u0003\u0005)\u0011AA)\u0005\ryFeM\t\u0005\u0003'\nI\u0006E\u0002w\u0003+J1!a\u0016x\u0005\u001dqu\u000e\u001e5j]\u001e\u00042A^A.\u0013\r\tif\u001e\u0002\u0004\u0003:L\u0018aE3wC2,\u0018\r^3BkRDwN]5uS\u0016\u001cH\u0003BA2\u0003\u007f\u0002D!!\u001a\u0002tA1\u0011qMA7\u0003cj!!!\u001b\u000b\u0007\u0005-D%\u0001\u0003vi&d\u0017\u0002BA8\u0003S\u0012!bQ8mY\u0016\u001cG/[8o!\u0011\tY%a\u001d\u0005\u0017\u0005U\u0004#!A\u0001\u0002\u000b\u0005\u0011q\u000f\u0002\u0004?\u0012\"\u0014\u0003BA*\u0003s\u0002B!a\u0001\u0002|%\u0019\u0011Q\u00109\u0003!\u001d\u0013\u0018M\u001c;fI\u0006+H\u000f[8sSRL\bbBA\u0018!\u0001\u0007\u00111C\u0001\u0015O\u0016$\u0018)\u001e;i_JLG/[3t\u001b\u0006\u0004\b/\u001a:\u0002)M,G/Q;uQ>\u0014\u0018\u000e^5fg6\u000b\u0007\u000f]3s)\r)\u0018q\u0011\u0005\u0006QJ\u0001\rA\u001b\u0015\b\u0001\u0005-\u0015qSAM!\u0011\ti)a%\u000e\u0005\u0005=%bAAI]\u0005Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005U\u0015q\u0012\u0002\n\u0007>l\u0007o\u001c8f]R\fQA^1mk\u0016\f#!a'\u00021ad\u0017)\u001e;iK:$\u0018nY1uS>t\u0007K]8wS\u0012,'\u000f")
public class DeployAuthenticationProvider
implements AuthenticationProvider {
    private final UserService userService;
    private final UserTokenService userTokenService;
    private final PrincipalDataProvider principalDataProvider;
    private final UserGroupService userGroupService;
    private final GeneralSettingsService generalSettingsService;
    private final Logger logger;
    private GrantedAuthoritiesMapper authoritiesMapper;

    private Logger logger() {
        return this.logger;
    }

    private GrantedAuthoritiesMapper authoritiesMapper() {
        return this.authoritiesMapper;
    }

    private void authoritiesMapper_$eq(GrantedAuthoritiesMapper x$1) {
        this.authoritiesMapper = x$1;
    }

    public Authentication authenticate(Authentication token) {
        Authentication authentication;
        this.logger().debug("Authenticating for Digital.ai Deploy");
        try {
            Authentication authentication2 = token;
            authentication = authentication2 instanceof PersonalAuthenticationToken ? this.authenticateFromUserToken(token.getCredentials().toString()) : this.authenticateFromCredentials(token.getPrincipal().toString(), token.getCredentials().toString());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof AuthenticationFailureException ? true : throwable2 instanceof NotFoundException) {
                throw new BadCredentialsException(throwable2.getMessage(), throwable2);
            }
            throw throwable;
        }
        return authentication;
    }

    private Authentication authenticateFromUserToken(String token) {
        this.logger().trace("Authenticating using personal access token");
        String tokenHash = TokenGenerator$.MODULE$.hash(token);
        XldUserToken userToken = this.userTokenService.findByUserToken(tokenHash);
        if (userToken == null) {
            throw new AuthenticationFailureException("Cannot authenticate with supplied personal access token");
        }
        if (((Tokens)userToken.tokens().head()).isExpired()) {
            throw new TokenExpiredException("The token expired on " + new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX").format(((Tokens)userToken.tokens().head()).expiryDate()));
        }
        this.userTokenService.updateLastUsedDate(Predef$.MODULE$.Integer2int(((Tokens)userToken.tokens().head()).ciId()), new Date());
        Collection<? extends GrantedAuthority> mappedAuthorities = this.evaluateAuthorities(userToken.username());
        return new PersonalAuthenticationToken((Object)userToken.username(), token, ((Tokens)userToken.tokens().head()).expiryDate(), mappedAuthorities, Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    }

    private Authentication authenticateFromCredentials(String username, String password) {
        this.logger().trace("Authenticating [" + username + "]");
        if (Strings.isBlank((String)username)) {
            throw new BadCredentialsException("Cannot authenticate with empty username");
        }
        this.userService.authenticate(username, password);
        Collection<? extends GrantedAuthority> mappedAuthorities = this.evaluateAuthorities(username);
        return new UsernamePasswordAuthenticationToken((Object)username, (Object)password, mappedAuthorities);
    }

    public boolean supports(Class<?> authentication) {
        return authentication.isAssignableFrom(UsernamePasswordAuthenticationToken.class) || authentication.isAssignableFrom(PersonalAuthenticationToken.class);
    }

    private Collection<? extends GrantedAuthority> evaluateAuthorities(String username) {
        ArrayList<SimpleGrantedAuthority> arrayList;
        UserData userData = this.principalDataProvider.getUserData(username);
        GeneralSettings generalSettings = this.generalSettingsService.getGeneralSettings();
        if (userData.isFound()) {
            return this.authoritiesMapper().mapAuthorities(this.principalDataProvider.getAuthorities(username));
        }
        try {
            User user = this.userService.read(username);
            ArrayList<SimpleGrantedAuthority> grantedAuthorities = new ArrayList<SimpleGrantedAuthority>();
            Object object = user.isAdmin() || "admin".equals(user.getUsername()) ? BoxesRunTime.boxToBoolean((boolean)grantedAuthorities.add(new SimpleGrantedAuthority("ROLE_ADMIN"))) : BoxedUnit.UNIT;
            arrayList = grantedAuthorities;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof NotFoundException && generalSettings.patEnableForSSO()) {
                Set userGroups = this.userGroupService.findGroupsForUser(username);
                ArrayList grantedAuthorities = new ArrayList();
                userGroups.foreach((Function1 & Serializable)group -> BoxesRunTime.boxToBoolean((boolean)grantedAuthorities.add(new SimpleGrantedAuthority(group))));
                arrayList = grantedAuthorities;
            }
            throw throwable;
        }
        ArrayList<SimpleGrantedAuthority> authorities = arrayList;
        return this.authoritiesMapper().mapAuthorities(authorities);
    }

    public GrantedAuthoritiesMapper getAuthoritiesMapper() {
        return this.authoritiesMapper();
    }

    public void setAuthoritiesMapper(GrantedAuthoritiesMapper authoritiesMapper) {
        this.authoritiesMapper_$eq(authoritiesMapper);
    }

    public DeployAuthenticationProvider(UserService userService, UserTokenService userTokenService, PrincipalDataProvider principalDataProvider, UserGroupService userGroupService, GeneralSettingsService generalSettingsService) {
        this.userService = userService;
        this.userTokenService = userTokenService;
        this.principalDataProvider = principalDataProvider;
        this.userGroupService = userGroupService;
        this.generalSettingsService = generalSettingsService;
        this.logger = LoggerFactory.getLogger(DeployAuthenticationProvider.class);
        this.authoritiesMapper = new NullAuthoritiesMapper();
    }
}

