package com.xebialabs.xldeploy.auth.config

import com.xebialabs.deployit.security.SecurityServiceLocator
import com.xebialabs.deployit.security.permission.PlatformPermissions
import org.slf4j.LoggerFactory
import org.springframework.security.authorization.{AuthorizationDecision, AuthorizationManager}
import org.springframework.security.core.Authentication
import org.springframework.security.web.FilterInvocation

import java.util
import java.util.function.Supplier

class LoginAuthorizationManager[RequestAuthorizationContext] extends AuthorizationManager[RequestAuthorizationContext]  {

  private val logger = LoggerFactory.getLogger(classOf[LoginAuthorizationManager[_]])
  private var whitelistUrls: util.Set[String] = new util.HashSet[String]

   def setWhitelistUrls(whitelistUrls: util.Set[String]): Unit = {
    this.whitelistUrls = whitelistUrls
  }

  @Override
  def check(authentication: Supplier[Authentication], `object`: RequestAuthorizationContext): AuthorizationDecision = {
    if (`object`.isInstanceOf[FilterInvocation]) {
      val requestUrl = `object`.asInstanceOf[FilterInvocation].getRequestUrl
      if (whitelistUrls.contains(requestUrl)) {
        logger.debug("Endpoint [{}] is whitelisted", requestUrl)
        return new AuthorizationDecision(true)
      }
    }
    logger.debug("Checking authorization for [{}]", authentication.get())
    if (SecurityServiceLocator.getPermissionEnforcer.hasPermission(authentication.get(), PlatformPermissions.LOGIN)) {
      logger.debug("User [{}] is authorized for login", authentication.get())
      return new AuthorizationDecision(true)
    }
    logger.error("User [{}] is not allowed to login to XL Deploy.", authentication.get())
    new AuthorizationDecision(false)
  }
}
