/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.auth.config;

import ai.digital.configuration.central.deploy.ClientProperties;
import com.xebialabs.deployit.filter.CsrfHeaderFilter;
import com.xebialabs.xldeploy.auth.config.DeploySecurityConfig;
import jakarta.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.logout.CookieClearingLogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.csrf.CsrfLogoutHandler;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRequestAttributeHandler;
import org.springframework.security.web.csrf.CsrfTokenRequestHandler;
import org.springframework.security.web.csrf.HttpSessionCsrfTokenRepository;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import scala.reflect.ScalaSignature;

@ConditionalOnProperty(name={"deploy.server.security.auth.provider"}, havingValue="default", matchIfMissing=true)
@Configuration
@EnableWebSecurity
@Order(value=-2147483648)
@ScalaSignature(bytes="\u0006\u0005\u0005=g\u0001B\u0007\u000f\u0001eAQA\b\u0001\u0005\u0002}A\u0011\"\t\u0001A\u0002\u0003\u0007I\u0011\u0001\u0012\t\u0013E\u0002\u0001\u0019!a\u0001\n\u0003\u0011\u0004\"C\u001e\u0001\u0001\u0004\u0005\t\u0015)\u0003$\u0011%9\u0005\u00011AA\u0002\u0013\u0005\u0001\nC\u0005X\u0001\u0001\u0007\t\u0019!C\u00011\"I!\f\u0001a\u0001\u0002\u0003\u0006K!\u0013\u0005\b9\u0002\u0011\r\u0011\"\u0003^\u0011\u00191\u0007\u0001)A\u0005=\")q\r\u0001C\u0001Q\"9\u0011q\f\u0001\u0005\n\u0005\u0005\u0004bBA:\u0001\u0011\u0005\u0011Q\u000f\u0002\u0019\t\u0016\u0004Hn\\=DgJ47+Z2ve&$\u0018pQ8oM&<'BA\b\u0011\u0003\u0019\u0019wN\u001c4jO*\u0011\u0011CE\u0001\u0005CV$\bN\u0003\u0002\u0014)\u0005A\u0001\u0010\u001c3fa2|\u0017P\u0003\u0002\u0016-\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002/\u0005\u00191m\\7\u0004\u0001M\u0011\u0001A\u0007\t\u00037qi\u0011AD\u0005\u0003;9\u0011A\u0003R3qY>L8+Z2ve&$\u0018pQ8oM&<\u0017A\u0002\u001fj]&$h\bF\u0001!!\tY\u0002!A\bu_.,gNU3q_NLGo\u001c:z+\u0005\u0019\u0003C\u0001\u00130\u001b\u0005)#B\u0001\u0014(\u0003\u0011\u00197O\u001d4\u000b\u0005!J\u0013aA<fE*\u0011!fK\u0001\tg\u0016\u001cWO]5us*\u0011A&L\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\ta&A\u0002pe\u001eL!\u0001M\u0013\u0003=!#H\u000f]*fgNLwN\\\"te\u001a$vn[3o%\u0016\u0004xn]5u_JL\u0018a\u0005;pW\u0016t'+\u001a9pg&$xN]=`I\u0015\fHCA\u001a:!\t!t'D\u00016\u0015\u00051\u0014!B:dC2\f\u0017B\u0001\u001d6\u0005\u0011)f.\u001b;\t\u000fi\u001a\u0011\u0011!a\u0001G\u0005\u0019\u0001\u0010J\u0019\u0002!Q|7.\u001a8SKB|7/\u001b;pef\u0004\u0003F\u0001\u0003>!\tqT)D\u0001@\u0015\t\u0001\u0015)\u0001\u0006b]:|G/\u0019;j_:T!AQ\"\u0002\u000f\u0019\f7\r^8ss*\u0011AiK\u0001\u0006E\u0016\fgn]\u0005\u0003\r~\u0012\u0011\"Q;u_^L'/\u001a3\u0002'\rd\u0017.\u001a8u\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0016\u0003%\u0003\"AS+\u000e\u0003-S!\u0001T'\u0002\r\u0011,\u0007\u000f\\8z\u0015\tqu*A\u0004dK:$(/\u00197\u000b\u0005A\u000b\u0016!D2p]\u001aLw-\u001e:bi&|gN\u0003\u0002S'\u00069A-[4ji\u0006d'\"\u0001+\u0002\u0005\u0005L\u0017B\u0001,L\u0005A\u0019E.[3oiB\u0013x\u000e]3si&,7/A\fdY&,g\u000e^\"p]\u001aLw-\u001e:bi&|gn\u0018\u0013fcR\u00111'\u0017\u0005\bu\u0019\t\t\u00111\u0001J\u0003Q\u0019G.[3oi\u000e{gNZ5hkJ\fG/[8oA!\u0012q!P\u0001\u0007aJ,g-\u001b=\u0016\u0003y\u0003\"a\u00183\u000e\u0003\u0001T!!\u00192\u0002\t1\fgn\u001a\u0006\u0002G\u0006!!.\u0019<b\u0013\t)\u0007M\u0001\u0004TiJLgnZ\u0001\baJ,g-\u001b=!\u0003\u0015\u001aXmY;sSRLh)\u001b7uKJ\u001c\u0005.Y5o\u0007N\u0014hmU3dkJLG/_\"p]\u001aLw\r\u0006\u0002j[B\u0011!n[\u0007\u0002O%\u0011An\n\u0002\u0014'\u0016\u001cWO]5us\u001aKG\u000e^3s\u0007\"\f\u0017N\u001c\u0005\u0006]*\u0001\ra\\\u0001\u0005QR$\b\u000f\u0005\u0002qm6\t\u0011O\u0003\u0002sg\u0006A!-^5mI\u0016\u00148O\u0003\u0002)i*\u0011\u0001)\u001e\u0006\u0003\u001f%J!a^9\u0003\u0019!#H\u000f]*fGV\u0014\u0018\u000e^=)\u0005)I\bC\u0001>\u007f\u001b\u0005Y(B\u0001!}\u0015\ti8&A\u0004d_:$X\r\u001f;\n\u0005}\\(\u0001\u0002\"fC:DSACA\u0002\u0003C\u0001R\u0001NA\u0003\u0003\u0013I1!a\u00026\u0005\u0019!\bN]8xgB!\u00111BA\u000e\u001d\u0011\ti!a\u0006\u000f\t\u0005=\u0011QC\u0007\u0003\u0003#Q1!a\u0005\u0019\u0003\u0019a$o\\8u}%\ta'C\u0002\u0002\u001aU\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u001e\u0005}!!C#yG\u0016\u0004H/[8o\u0015\r\tI\"N\u0019\b=\u0005\r\u0012\u0011GA/!\u0011\t)#!\f\u000f\t\u0005\u001d\u0012\u0011\u0006\t\u0004\u0003\u001f)\u0014bAA\u0016k\u00051\u0001K]3eK\u001aL1!ZA\u0018\u0015\r\tY#N\u0019\nG\u0005M\u00121HA*\u0003{)B!!\u000e\u00028U\u0011\u00111\u0005\u0003\b\u0003sA\"\u0019AA\"\u0005\u0005!\u0016\u0002BA\u001f\u0003\u007f\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n$bAA!k\u00051A\u000f\u001b:poN\fB!!\u0012\u0002LA\u0019A'a\u0012\n\u0007\u0005%SGA\u0004O_RD\u0017N\\4\u0011\t\u00055\u0013q\n\b\u0004i\u0005]\u0011\u0002BA)\u0003?\u0011\u0011\u0002\u00165s_^\f'\r\\32\u0013\r\n)&a\u0016\u0002Z\u0005\u0005cb\u0001\u001b\u0002X%\u0019\u0011\u0011I\u001b2\u000b\t\"T'a\u0017\u0003\u000bM\u001c\u0017\r\\12\u0007\u0019\nI!\u0001\u0007m_\u001e|W\u000f\u001e$jYR,'/\u0006\u0002\u0002dA!\u0011QMA8\u001b\t\t9G\u0003\u0003\u0002j\u0005-\u0014A\u00027pO>,HOC\u0002\u0002n\u001d\na\"Y;uQ\u0016tG/[2bi&|g.\u0003\u0003\u0002r\u0005\u001d$\u0001\u0004'pO>,HOR5mi\u0016\u0014\u0018!G<fE\u000e\u001b(OZ*fGV\u0014\u0018\u000e^=DkN$x.\\5{KJ,\"!a\u001e\u0011\t\u0005e\u0014QP\u0007\u0003\u0003wR!\u0001U:\n\t\u0005}\u00141\u0010\u0002\u0016/\u0016\u00147+Z2ve&$\u0018pQ;ti>l\u0017N_3sQ\ta\u0011\u0010K\b\u0001\u0003\u000b\u000bI*a'\u0002\"\u0006\r\u0016qUAU!\u0011\t9)!&\u000e\u0005\u0005%%\u0002BAF\u0003\u001b\u000b\u0011bY8oI&$\u0018n\u001c8\u000b\t\u0005=\u0015\u0011S\u0001\u000eCV$xnY8oM&<WO]3\u000b\u0007\u0005M5&\u0001\u0003c_>$\u0018\u0002BAL\u0003\u0013\u0013QcQ8oI&$\u0018n\u001c8bY>s\u0007K]8qKJ$\u00180\u0001\u0003oC6,GFAAOC\t\ty*\u0001\u0013eKBdw.\u001f\u0018tKJ4XM\u001d\u0018tK\u000e,(/\u001b;z]\u0005,H\u000f\u001b\u0018qe>4\u0018\u000eZ3s\u0003-A\u0017M^5oOZ\u000bG.^3\"\u0005\u0005\u0015\u0016a\u00023fM\u0006,H\u000e^\u0001\u000f[\u0006$8\r[%g\u001b&\u001c8/\u001b8h3\u0005\t\u0001f\u0001\u0001\u0002.B\u0019!0a,\n\u0007\u0005E6PA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0015\u0004\u0001\u0005U\u0006\u0003BA=\u0003oKA!!/\u0002|\t\tRI\\1cY\u0016<VMY*fGV\u0014\u0018\u000e^=)\u000f\u0001\ti,a3\u0002NB!\u0011qXAd\u001b\t\t\tMC\u0002A\u0003\u0007T1!!2,\u0003\u0011\u0019wN]3\n\t\u0005%\u0017\u0011\u0019\u0002\u0006\u001fJ$WM]\u0001\u0006m\u0006dW/Z\u000f\u0005\u0001\u0003\u0001\u0001\u0001")
public class DeployCsrfSecurityConfig
extends DeploySecurityConfig {
    @Autowired
    private HttpSessionCsrfTokenRepository tokenRepository;
    @Autowired
    private ClientProperties clientConfiguration;
    private final String prefix;

    public HttpSessionCsrfTokenRepository tokenRepository() {
        return this.tokenRepository;
    }

    public void tokenRepository_$eq(HttpSessionCsrfTokenRepository x$1) {
        this.tokenRepository = x$1;
    }

    public ClientProperties clientConfiguration() {
        return this.clientConfiguration;
    }

    public void clientConfiguration_$eq(ClientProperties x$1) {
        this.clientConfiguration = x$1;
    }

    private String prefix() {
        return this.prefix;
    }

    @Bean
    public SecurityFilterChain securityFilterChainCsrfSecurityConfig(HttpSecurity http) throws Exception {
        http.securityMatchers(securityMatcher -> securityMatcher.requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)("/" + this.prefix() + "/**"))}));
        this.configureSecurity(http, this.prefix());
        CsrfTokenRequestAttributeHandler requestHandler = new CsrfTokenRequestAttributeHandler();
        requestHandler.setCsrfRequestAttributeName(null);
        return (SecurityFilterChain)http.addFilterAfter((Filter)new CsrfHeaderFilter(this.clientConfiguration()), CsrfFilter.class).addFilterBefore((Filter)this.logoutFilter(), LogoutFilter.class).csrf(csrf -> csrf.csrfTokenRepository((CsrfTokenRepository)this.tokenRepository()).csrfTokenRequestHandler((CsrfTokenRequestHandler)requestHandler)).build();
    }

    private LogoutFilter logoutFilter() {
        LogoutFilter logoutFilter = new LogoutFilter((LogoutSuccessHandler)this.withoutRedirectLogoutSuccessHandler(), new LogoutHandler[]{new CsrfLogoutHandler((CsrfTokenRepository)this.tokenRepository()), new CookieClearingLogoutHandler(new String[]{"cookiesToClear", "XSRF-TOKEN"}), this.rememberMeServices(), new SecurityContextLogoutHandler()});
        logoutFilter.setFilterProcessesUrl("/xldeploy/logout");
        return logoutFilter;
    }

    @Bean
    public WebSecurityCustomizer webCsrfSecurityCustomizer() {
        return web -> this.configureSecurity(web, this.prefix());
    }

    public DeployCsrfSecurityConfig() {
        this.prefix = "xldeploy";
    }
}

