package com.xebialabs.xldeploy.auth.config

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty
import org.springframework.context.annotation.{Bean, Configuration}
import org.springframework.core.annotation.Order
import org.springframework.security.config.annotation.web.builders.HttpSecurity
import org.springframework.security.config.annotation.web.configuration.{EnableWebSecurity, WebSecurityCustomizer}
import org.springframework.security.web.SecurityFilterChain
import org.springframework.security.web.util.matcher.AntPathRequestMatcher.antMatcher

@ConditionalOnProperty(name = Array("deploy.server.security.auth.provider"), havingValue = "default", matchIfMissing = true)
@Configuration
@EnableWebSecurity
@Order(org.springframework.core.Ordered.LOWEST_PRECEDENCE)
class DeployNoCsrfSecurityConfig extends DeploySecurityConfig {

  private val prefix = "deployit"

  @Bean
  @throws[Exception]
  def securityFilterChainNoCsrfSecurityConfig(http: HttpSecurity): SecurityFilterChain = {
    configureSecurity(http, prefix = prefix)
    http
      .headers(
        hc => hc.frameOptions(
          fc => fc.sameOrigin()
        )
      )
      .authorizeHttpRequests(
        authorizeHttpRequests => authorizeHttpRequests
          .requestMatchers(antMatcher("/api/**"))
          .fullyAuthenticated()
      )
      .csrf(cc => cc.disable())
      .build()
  }

  @Bean
  def webNoCsrfSecurityCustomizer: WebSecurityCustomizer = {
    web => configureSecurity(web, prefix = prefix)
  }
}
