package com.xebialabs.xldeploy.auth.config

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty
import org.springframework.context.annotation.Configuration
import org.springframework.core.annotation.Order
import org.springframework.security.config.annotation.web.builders.{HttpSecurity, WebSecurity}
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity

@ConditionalOnProperty(name = Array("deploy.server.security.auth.provider"), havingValue = "default", matchIfMissing = true)
@Configuration
@EnableWebSecurity
@Order(org.springframework.core.Ordered.LOWEST_PRECEDENCE)
class DeployNoCsrfSecurityConfig extends DeploySecurityConfig {

  private val prefix = "deployit"

  @throws[Exception]
  override protected def configure(http: HttpSecurity): Unit = {
    configureSecurity(http, prefix = prefix)

    http
      .headers()
      .frameOptions()
      .sameOrigin().and()
      .authorizeRequests()
      .antMatchers("/api/**").fullyAuthenticated().and()
      .csrf().disable()
  }

  override def configure(web: WebSecurity): Unit = {
    configureSecurity(web, prefix = prefix)
  }
}
