package com.xebialabs.deployit

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm._
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployedInfrastructureAsCode

import scala.reflect.ClassTag

package object provision {

  val templatePrefix: String = "template."
  val contextDelimiter: String = "%"
  val literalDelimiter: String = "'"
  val defaultDelimiter: String = "{{ }}"

  type JList[T] = java.util.List[T]
  type JArrayList[T] = java.util.ArrayList[T]
  type JHashSet[T] = java.util.HashSet[T]
  type JSet[T] = java.util.Set[T]
  type JMap[K, V] = java.util.Map[K, V]
  type JHashMap[K, V] = java.util.HashMap[K, V]
  type RefMap = Map[String, List[String]]
  type EmbeddedDeployedContainerType = EmbeddedDeployedContainer[_ <: ConfigurationItem, _ <: ConfigurationItem]
  type DeployedType = Deployed[_ <: Deployable, _ <: Container]
  type ProvisionedType = Provisioned[_ <: Provisionable, _ <: Container]
  type UdmDictionaryType = com.xebialabs.deployit.plugin.api.udm.IDictionary
  type BaseDeployedInfrastructureAsCodeType = BaseDeployedInfrastructureAsCode[_ <: DeployableArtifact, _ <: Container]

  def typeOf(ciType: String): Type = {
    Type.valueOf(ciType)
  }


  def createCi[T <: ConfigurationItem : ClassTag](id: String): T = {
    createCi(typeOf[T], id)
  }

  def createCi[T <: ConfigurationItem](ciType: String, id: String): T = {
    createCi(typeOf(ciType), id)
  }

  def createCi[T <: ConfigurationItem](ciType: Type, id: String): T = {
    ciType.getDescriptor.newInstance[T](id)
  }

  def typeOf[T <: ConfigurationItem : ClassTag]: Type = {
    Type.valueOf(implicitly[ClassTag[T]].runtimeClass)
  }

  def isProvisioning(version: Version) = version.isInstanceOf[ProvisioningPackage]

  implicit class EmptyValue(val value: Any) extends AnyVal {
    def nonEmpty: Boolean = value match {
      case cl: java.util.Collection[_] => !cl.isEmpty
      case map: java.util.Map[_, _] => !map.isEmpty
      case st: String => !st.isEmpty
      case v => v != null
    }
  }
}
