package com.xebialabs.deployit.provision
package resolver.placeholder

import com.xebialabs.deployit.plugin.api.reflect.PropertyKind
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary

import scala.collection.convert.ImplicitConversions._

abstract class PlaceholderResolver {

  def resolve(value: AnyRef, pd: Option[PropertyKind] = None, ignoreContextPlaceholders: Boolean = false): AnyRef = pd match {
    case Some(PropertyKind.STRING) | None =>
      scanPlaceholdersAndReplace(value.toString, ignoreContextPlaceholders)
    case Some(PropertyKind.LIST_OF_STRING) =>
      new JArrayList[String](value.asInstanceOf[JList[String]].map(x => scanPlaceholdersAndReplace(x, ignoreContextPlaceholders)))
    case Some(PropertyKind.SET_OF_STRING) =>
      new JHashSet[String](value.asInstanceOf[JSet[String]].map(x => scanPlaceholdersAndReplace(x, ignoreContextPlaceholders)))
    case Some(PropertyKind.MAP_STRING_STRING) =>
      new JHashMap[String, String](value.asInstanceOf[JMap[String, String]].map { case (k, v) => scanPlaceholdersAndReplace(k) -> scanPlaceholdersAndReplace(v, ignoreContextPlaceholders) })
    case _ =>
      value
  }

  def scanPlaceholdersAndReplace(propertyValue: String, ignoreContextPlaceholders: Boolean = false, delimiters: String = defaultDelimiter): String
}

object PlaceholderResolver {

  def apply(dictionary: ConsolidatedDictionary, sourceDeployed: Option[DeployedType] = None): MustachePlaceholderResolver = {
    new MustachePlaceholderResolver(dictionary, sourceDeployed)
  }
}
