package com.xebialabs.deployit.provision
package steps

import com.xebialabs.deployit.plugin.api.deployment.specification.{DeltaSpecification, Operation}
import com.xebialabs.deployit.plugin.api.rules.{Scope, StepPostConstructContext}
import com.xebialabs.deployit.plugin.api.udm._
import com.xebialabs.deployit.repository.{RepositoryService, RepositoryServiceHolder}

import scala.collection.convert.ImplicitConversions._

trait ProvisionedItemsStep extends BaseStep with ScopeValidator {

  private[steps] var deployedApplication: DeployedApplication = null
  private[steps] var provisioneds: Set[ProvisionedType] = _
  private[steps] var deployeds: Set[DeployedType] = _
  private[steps] var deploymentPackage: DeploymentPackage = _
  private[steps] var application: Application = _
  private[steps] var provisioningEnvironment: Environment = _

  def validScope: Scope

  private[steps] def validate(ctx: StepPostConstructContext) {
    if (!correctDeployedApplication(ctx).isInstanceOf[DeployedApplication]) {
      throw new IllegalArgumentException(s"This step can be applied to provisioned blueprint only")
    }
    validateScope(ctx.getScope, validScope)
  }

  private[steps] def correctDeployedApplication(ctx: StepPostConstructContext) = {
    val specification: DeltaSpecification = ctx.getSpecification
    if(specification.getOperation == Operation.DESTROY) {
      specification.getPreviousDeployedApplication
    } else {
      specification.getDeployedApplication
    }
  }

  private[steps] def setParameters(ctx: StepPostConstructContext): Unit = {
    deployedApplication = correctDeployedApplication(ctx)
    deploymentPackage = deployedApplication.getVersion.asInstanceOf[DeploymentPackage]
    provisioneds = deployedApplication.getDeployeds.collect { case p: ProvisionedType => p }.toSet
    deployeds = deployedApplication.getDeployeds.toSet
    provisioningEnvironment = deployedApplication.getEnvironment
    application = deploymentPackage.getApplication
  }

  protected def repositoryService: RepositoryService = {
    RepositoryServiceHolder.getRepositoryService
  }

  protected def getEnvironment: Environment = {
    val envId = deployedApplication.getEnvironment.getId
    val environment: Environment = repositoryService.read(envId)
    deployedApplication.setEnvironment(environment)
    deployedApplication.getEnvironment
  }
}
