package com.xebialabs.deployit.provision.host

import com.xebialabs.deployit.plugin.api.udm.{DeployedApplication, Metadata, Template}
import com.xebialabs.deployit.plugin.overthere.Host
import com.xebialabs.deployit.provision.DeployedType
import com.xebialabs.deployit.provision.resolver.TemplateResolver
import com.xebialabs.overthere.{OperatingSystemFamily, OverthereConnection}

import scala.util.{Failure, Success}

@Metadata(virtual = true, description = "Machine that runs middleware, on which scripts can be executed, etc.")
class LazyHost extends Host {

  private var hostTemplate: Template = _
  private var sourceProvisioned: DeployedType = _
  private var provisionedBlueprint: DeployedApplication = _

  @transient
  private lazy val templateResolver = TemplateResolver(provisionedBlueprint)

  override def getConnection: OverthereConnection = host.getConnection

  private lazy val host: Host = {
    templateResolver.resolveSingleRootTemplate(hostTemplate, sourceProvisioned).configurationItem match {
      case Success(host) => host.asInstanceOf[Host]
      case Failure(ex) => throw ex
    }
  }

  override def getOs: OperatingSystemFamily = OperatingSystemFamily.valueOf(templateResolver.resolveValue(hostTemplate.getProperty[String]("os")))

  override def getTemporaryDirectoryPath: String = host.getTemporaryDirectoryPath

  override def getStagingDirectoryPath: String = null

  def setHostTemplate(hostTemplate: Template): Unit = this.hostTemplate = hostTemplate

  def setProvisionedBlueprint(provisionedBlueprint: DeployedApplication): Unit = this.provisionedBlueprint = provisionedBlueprint

  def setSourceProvisioned(sourceProvisioned: DeployedType): Unit = this.sourceProvisioned = sourceProvisioned

}
