/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.io;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.InputSupplier;
import com.google.common.io.NullOutputStream;
import com.xebialabs.deployit.util.GuavaFiles;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class Exploder {
    private static final Logger logger = LoggerFactory.getLogger(Exploder.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void explode(InputSupplier<? extends InputStream> inputZip, File outputDirectory, MessageDigest sha1) throws IOException {
        ZipInputStream zipEntryStream = null;
        try {
            ZipEntry entry;
            zipEntryStream = new ZipInputStream((InputStream)inputZip.getInput());
            while ((entry = zipEntryStream.getNextEntry()) != null) {
                try {
                    File destinationDir;
                    if (entry.isDirectory()) {
                        File file = new File(outputDirectory, entry.getName());
                        if (file.exists()) continue;
                        Assert.isTrue((boolean)file.mkdirs(), (String)("Could not create directory: " + entry.getName()));
                        continue;
                    }
                    File destinationFile = new File(outputDirectory, entry.getName());
                    String parentDirPath = destinationFile.getParent();
                    if (parentDirPath != null && !(destinationDir = new File(parentDirPath)).exists()) {
                        Assert.isTrue((boolean)destinationDir.mkdirs(), (String)("Could not create directory: " + entry.getName()));
                    }
                    Assert.isTrue((boolean)destinationFile.createNewFile(), (String)("Could not create file: " + entry.getName()));
                    FileOutputStream fo = new FileOutputStream(destinationFile);
                    try {
                        FilterInputStream from = zipEntryStream;
                        if (sha1 != null) {
                            from = new DigestInputStream(zipEntryStream, sha1);
                        }
                        ByteStreams.copy((InputStream)from, (OutputStream)fo);
                    }
                    finally {
                        Closeables.closeQuietly((Closeable)fo);
                    }
                }
                finally {
                    zipEntryStream.closeEntry();
                }
            }
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(zipEntryStream);
            throw throwable;
        }
        {
            catch (IOException exc) {
                try {
                    GuavaFiles.deleteRecursively(outputDirectory);
                    throw exc;
                }
                catch (Exception e) {
                    logger.error("Could not delete {}", (Object)outputDirectory, (Object)e);
                }
                throw exc;
                break;
            }
        }
        Closeables.closeQuietly((Closeable)zipEntryStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void calculateCheckSum(InputSupplier<? extends InputStream> inputZip, MessageDigest sha1) throws IOException {
        ZipEntry entry;
        ZipInputStream zipEntryStream = null;
        try {
            zipEntryStream = new ZipInputStream((InputStream)inputZip.getInput());
            while (true) {
                if ((entry = zipEntryStream.getNextEntry()) != null) break block8;
                break;
            }
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(zipEntryStream);
            throw throwable;
        }
        {
            block8: {
                Closeables.closeQuietly((Closeable)zipEntryStream);
                return;
            }
            try {
                if (entry.isDirectory()) continue;
                ByteStreams.copy((InputStream)new DigestInputStream(zipEntryStream, sha1), (OutputStream)new NullOutputStream());
                continue;
            }
            finally {
                zipEntryStream.closeEntry();
                continue;
            }
        }
    }
}

